/*
 * Decompiled with CFR 0.152.
 */
package net.plsar.security;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import net.plsar.model.NetworkRequest;
import net.plsar.model.NetworkResponse;
import net.plsar.model.NetworkSession;
import net.plsar.model.SecurityAttribute;
import net.plsar.security.SecurityAccess;

public class SecurityManager {
    SecurityAccess securityAccess;

    public SecurityManager(SecurityAccess securityAccess) {
        this.securityAccess = securityAccess;
    }

    public SecurityAccess getSecurityAccess() {
        return this.securityAccess;
    }

    public void setSecurityAccess(SecurityAccess securityAccess) {
        this.securityAccess = securityAccess;
    }

    public boolean hasRole(String role, NetworkRequest networkRequest) {
        Set<String> roles;
        String user = this.getUser(networkRequest);
        return user != null && (roles = this.securityAccess.getRoles(user)).contains(role);
    }

    public boolean hasPermission(String permission, NetworkRequest networkRequest) {
        Set<String> permissions;
        String user = this.getUser(networkRequest);
        return user != null && (permissions = this.securityAccess.getPermissions(user)).contains(permission);
    }

    public String getUser(NetworkRequest networkRequest) {
        NetworkSession networkSession = networkRequest.getSession(true);
        String user = (String)networkSession.get("user");
        return user;
    }

    public String get(String key, NetworkRequest networkRequest) {
        NetworkSession networkSession = networkRequest.getSession(true);
        if (networkSession.getAttributes().containsKey(key)) {
            return String.valueOf(networkSession.get(key));
        }
        return null;
    }

    public void set(String key, String value, NetworkRequest networkRequest) {
        NetworkSession networkSession = networkRequest.getSession(true);
        networkSession.set(key, value);
    }

    public Boolean signin(String username, String passwordUntouched, NetworkRequest networkRequest, NetworkResponse networkResponse) {
        String hashed = this.hash(passwordUntouched);
        String password = this.securityAccess.getPassword(username);
        if (!this.isAuthenticated(networkRequest) && password.equals(hashed)) {
            NetworkSession oldNetworkSession = networkRequest.getSession(true);
            if (oldNetworkSession != null) {
                this.expireHttpSession(oldNetworkSession, networkResponse);
                networkRequest.getRouteAttributes().getSessionRegistry().remove(oldNetworkSession.getGuid());
            }
            NetworkSession networkSession = networkRequest.getSession(false);
            networkRequest.getRouteAttributes().getSessionRegistry().put(networkSession.getGuid(), true);
            networkSession.set("user", username);
            networkRequest.setSession(networkSession);
            return true;
        }
        return false;
    }

    public boolean signout(NetworkRequest networkRequest, NetworkResponse networkResponse) {
        NetworkSession oldNetworkSession = networkRequest.getSession(true);
        if (networkRequest != null) {
            this.expireHttpSession(oldNetworkSession, networkResponse);
            networkRequest.getRouteAttributes().getSessionRegistry().remove(oldNetworkSession.getGuid());
        }
        return true;
    }

    public void expireHttpSession(NetworkSession oldNetworkSession, NetworkResponse networkResponse) {
        SecurityAttribute securityAttribute = new SecurityAttribute("plsar.sessions", oldNetworkSession.getGuid());
        networkResponse.getSecurityAttributes().add(securityAttribute);
    }

    public boolean isAuthenticated(NetworkRequest networkRequest) {
        NetworkSession networkSession = networkRequest.getSession(true);
        if (networkSession != null) {
            return networkRequest.getRouteAttributes().getSessionRegistry().containsKey(networkSession.getGuid());
        }
        return false;
    }

    public boolean configure(SecurityAccess securityAccess) {
        this.securityAccess = securityAccess;
        return true;
    }

    public String hash(String password) {
        StringBuffer passwordHashed = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(password.getBytes());
            byte[] byteData = md.digest();
            for (int i = 0; i < byteData.length; ++i) {
                passwordHashed.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return passwordHashed.toString();
    }

    public static String dirty(String password) {
        StringBuffer passwordHashed = new StringBuffer();
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            md.update(password.getBytes());
            byte[] byteData = md.digest();
            for (int i = 0; i < byteData.length; ++i) {
                passwordHashed.append(Integer.toString((byteData[i] & 0xFF) + 256, 16).substring(1));
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return passwordHashed.toString();
    }
}

