/*
 * Decompiled with CFR 0.152.
 */
package net.plsar.resources;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.plsar.PlsarException;
import net.plsar.ViewConfig;

public class ServerResources {
    public Object getInstance(Class<?> klass) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        Object object = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
        return object;
    }

    public String getGuid(int n) {
        String CHARS = "AaBbCcDdEeFfGgHhIiJjKkLlMmNnOoPpQqRrSsTtUuVvWwXxYyZz";
        StringBuilder uuid = new StringBuilder();
        int divisor = n / 6;
        Random rnd = new Random();
        for (int z = 0; z < n; ++z) {
            if (z % divisor == 0 && z > 0) {
                uuid.append("-");
            }
            int index = (int)(rnd.nextFloat() * (float)CHARS.length());
            uuid.append(CHARS.charAt(index));
        }
        return uuid.toString();
    }

    public Long getTime(int days) {
        LocalDateTime ldt = LocalDateTime.now().minusDays(days);
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(this.getDateFormat());
        String date = dtf.format(ldt);
        return Long.valueOf(date);
    }

    public String getCookie(Map<String, String> headers) {
        String value = null;
        String sessionId = this.getSessionId();
        String cookies = headers.get("cookie");
        if (cookies != null) {
            String[] bits;
            for (String completes : bits = cookies.split(";")) {
                String[] parts = completes.split("=");
                String key = parts[0].trim();
                if (parts.length != 2 || !key.equals(sessionId)) continue;
                value = parts[1].trim();
            }
        }
        return value;
    }

    public String getSessionId() {
        return "plsar.sessions";
    }

    public String getDateFormat() {
        return "yyyyMMddHHmmssSSS";
    }

    private String guessContentType(Path filePath) throws IOException {
        return Files.probeContentType(filePath);
    }

    public String getRedirect(String uri) {
        String[] redirectBits = uri.split(":");
        if (redirectBits.length > 1) {
            return redirectBits[1];
        }
        return null;
    }

    public ByteArrayOutputStream getViewFileCopy(String viewKey, ConcurrentMap<String, byte[]> viewBytesMap) {
        if (viewBytesMap.containsKey(viewKey)) {
            byte[] fileBytes = (byte[])viewBytesMap.get(viewKey);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(fileBytes);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] bytes = new byte[fileBytes.length];
            try {
                int bytesRead;
                while ((bytesRead = inputStream.read(bytes, 0, bytes.length)) != -1) {
                    outputStream.write(bytes, 0, bytesRead);
                }
                inputStream.close();
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            return outputStream;
        }
        return null;
    }

    public ConcurrentMap<String, byte[]> getViewBytesMap(ViewConfig viewConfig) throws PlsarException, FileNotFoundException {
        Path resourcesPath;
        File resourcesDirectory;
        ConcurrentHashMap<String, byte[]> viewFilesBytesMap = new ConcurrentHashMap<String, byte[]>();
        Path viewsPath = Paths.get("src", "main", "webapp", viewConfig.getViewsPath());
        File viewsDirectory = new File(viewsPath.toString());
        if (viewsDirectory.isDirectory()) {
            File[] viewFiles = viewsDirectory.listFiles();
            this.getFileBytesMap(viewFiles, viewFilesBytesMap);
        }
        if ((resourcesDirectory = new File((resourcesPath = Paths.get("src", "main", "webapp", viewConfig.getViewsPath(), viewConfig.getResourcesPath())).toString())).isDirectory()) {
            File[] resourceFiles = resourcesDirectory.listFiles();
            this.getFileBytesMap(resourceFiles, viewFilesBytesMap);
        }
        return viewFilesBytesMap;
    }

    ConcurrentMap<String, byte[]> getFileBytesMap(File[] viewFiles, ConcurrentMap<String, byte[]> viewFilesBytesMap) throws FileNotFoundException {
        for (File viewFile : viewFiles) {
            if (viewFile.isDirectory()) {
                File[] directoryFiles = viewFile.listFiles();
                this.getFileBytesMap(directoryFiles, viewFilesBytesMap);
                continue;
            }
            FileInputStream fileInputStream = new FileInputStream(viewFile);
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] bytes = new byte[1024];
            try {
                int bytesRead;
                while ((bytesRead = ((InputStream)fileInputStream).read(bytes, 0, bytes.length)) != -1) {
                    outputStream.write(bytes, 0, bytesRead);
                }
                ((InputStream)fileInputStream).close();
                outputStream.flush();
                outputStream.close();
                byte[] viewFileBytes = outputStream.toByteArray();
                String viewKey = viewFile.toString().replace("src" + File.separator + "main" + File.separator + "webapp", "");
                viewFilesBytesMap.put(viewKey, viewFileBytes);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return viewFilesBytesMap;
    }
}

