/*
 * Decompiled with CFR 0.152.
 */
package net.plsar;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import net.plsar.RouteEndpoint;
import net.plsar.RouteEndpointHolder;
import net.plsar.annotations.Controller;
import net.plsar.annotations.http.Delete;
import net.plsar.annotations.http.Get;
import net.plsar.annotations.http.Post;
import net.plsar.model.RouteAttribute;
import net.plsar.resources.ServerResources;

public class RouteEndpointsResolver {
    ServerResources serverResources;
    ClassLoader klassLoader;
    RouteEndpointHolder routeEndpointHolder;

    public RouteEndpointsResolver(ServerResources serverResources) {
        this.serverResources = serverResources;
        this.routeEndpointHolder = new RouteEndpointHolder();
        this.klassLoader = Thread.currentThread().getContextClassLoader();
    }

    public RouteEndpointHolder resolve() {
        Path filePath = Paths.get("build", new String[0]);
        String completeFilePath = filePath.toAbsolutePath().toString();
        this.inspectFilePath(completeFilePath);
        return this.routeEndpointHolder;
    }

    public void inspectFilePath(String filePath) {
        File[] files;
        File pathFile = new File(filePath);
        for (File file : files = pathFile.listFiles()) {
            if (file.isDirectory()) {
                this.inspectFilePath(file.getPath());
                continue;
            }
            try {
                Method[] routeMethods;
                if (!file.getPath().endsWith(".class")) continue;
                String separator = System.getProperty("file.separator");
                String regex = "classes\\" + separator;
                String[] klassPathParts = file.getPath().split(regex);
                String klassPathSlashesRemoved = klassPathParts[1].replace("\\", ".");
                String klassPathPeriod = klassPathSlashesRemoved.replace("/", ".");
                String klassPathBefore = klassPathPeriod.replace(".class", "");
                String klassPath = klassPathBefore.replaceFirst("java.", "").replaceFirst("main.", "");
                Class<?> klass = this.klassLoader.loadClass(klassPath);
                if (klass.isAnnotation() || klass.isInterface() || !klass.isAnnotationPresent(Controller.class)) continue;
                for (Method routeMethod : routeMethods = klass.getDeclaredMethods()) {
                    String routeKey;
                    RouteEndpoint routeEndpoint;
                    String routePath;
                    Annotation annotation;
                    if (routeMethod.isAnnotationPresent(Get.class)) {
                        annotation = routeMethod.getAnnotation(Get.class);
                        routePath = annotation.value();
                        routeEndpoint = this.getCompleteRouteEndpoint("get", routePath, routeMethod, klass);
                        routeKey = routeEndpoint.getRouteVerb() + ":" + routeEndpoint.getRoutePath().toLowerCase();
                        this.routeEndpointHolder.getRouteEndpoints().put(routeKey, routeEndpoint);
                    }
                    if (routeMethod.isAnnotationPresent(Post.class)) {
                        annotation = routeMethod.getAnnotation(Post.class);
                        routePath = annotation.value();
                        routeEndpoint = this.getCompleteRouteEndpoint("post", routePath, routeMethod, klass);
                        routeKey = routeEndpoint.getRouteVerb() + ":" + routeEndpoint.getRoutePath();
                        this.routeEndpointHolder.getRouteEndpoints().put(routeKey, routeEndpoint);
                    }
                    if (!routeMethod.isAnnotationPresent(Delete.class)) continue;
                    annotation = routeMethod.getAnnotation(Delete.class);
                    routePath = annotation.value();
                    routeEndpoint = this.getCompleteRouteEndpoint("delete", routePath, routeMethod, klass);
                    routeKey = routeEndpoint.getRouteVerb() + ":" + routeEndpoint.getRoutePath();
                    this.routeEndpointHolder.getRouteEndpoints().put(routeKey, routeEndpoint);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    RouteEndpoint getCompleteRouteEndpoint(String routeVerb, String routePath, Method routeMethod, Class<?> klass) throws Exception {
        String[] routeParts;
        RouteEndpoint routeEndpoint = new RouteEndpoint();
        routeEndpoint.setRouteVerb(routeVerb);
        routeEndpoint.setRoutePath(routePath.toLowerCase());
        routeEndpoint.setRouteMethod(routeMethod);
        routeEndpoint.setKlass(klass);
        Object routeRegex = new String();
        for (String routePart : routeParts = routePath.split("/")) {
            if (routePart.equals("")) continue;
            routeRegex = (String)routeRegex + "/";
            routeRegex = routePart.contains("{") && routePart.contains("}") ? (String)routeRegex + "[a-zA-Z0-9-_]*" : (String)routeRegex + routePart;
        }
        routeEndpoint.setRegexRoutePath((String)routeRegex);
        if (routeEndpoint.getRegexRoutePath().contains("[")) {
            routeEndpoint.setRegex(true);
        }
        if (!routeEndpoint.getRegexRoutePath().contains("[")) {
            routeEndpoint.setRegex(false);
        }
        Type[] parameterAttributes = routeMethod.getGenericParameterTypes();
        int index = 0;
        for (Type parameterAttribute : parameterAttributes) {
            RouteAttribute routeAttribute = new RouteAttribute();
            routeAttribute.setTypeKlass(parameterAttribute.getTypeName());
            if (!parameterAttribute.getTypeName().startsWith("net.plsar")) {
                routeEndpoint.setRegex(true);
                routeAttribute.setRouteVariable(true);
            } else {
                routeAttribute.setRouteVariable(false);
            }
            routeEndpoint.getRouteAttributes().put(index, routeAttribute);
            ++index;
        }
        HashMap<Integer, Boolean> processed = new HashMap<Integer, Boolean>();
        for (Map.Entry<Integer, RouteAttribute> routeAttributeEntry : routeEndpoint.getRouteAttributes().entrySet()) {
            int pathIndex = 0;
            for (String routePart : routeParts) {
                if (routePart.equals("")) continue;
                RouteAttribute routeAttribute = routeAttributeEntry.getValue();
                if (routePart.contains("{") && routePart.contains("}") && routeAttribute.getRouteVariable().booleanValue() && !processed.containsKey(routeAttribute.getRoutePosition())) {
                    processed.put(routeAttribute.getRoutePosition(), true);
                    routeAttribute.setRoutePosition(pathIndex);
                }
                ++pathIndex;
            }
        }
        return routeEndpoint;
    }
}

