/*
 * Decompiled with CFR 0.152.
 */
package plsar.util;

import com.sun.net.httpserver.HttpExchange;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.util.MimeGetter;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 12\u00020\u0001:\u000201B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\u001a\u0010,\u001a\u00020'2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010-\u001a\u00020.H\u0002J\u0006\u0010/\u001a\u00020'R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\bR\u0014\u0010\u000b\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\bR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\b\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\b\"\u0004\b\u001f\u0010\u001cR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00062"}, d2={"Lplsar/util/ResourceResponse;", "", "builder", "Lplsar/util/ResourceResponse$Builder;", "(Lplsar/util/ResourceResponse$Builder;)V", "CONTENTTYPE", "", "getCONTENTTYPE", "()Ljava/lang/String;", "GET", "getGET", "WEBAPP", "getWEBAPP", "cache", "Lplsar/PLSAR$Cache;", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "(Lplsar/PLSAR$Cache;)V", "httpExchange", "Lcom/sun/net/httpserver/HttpExchange;", "getHttpExchange", "()Lcom/sun/net/httpserver/HttpExchange;", "setHttpExchange", "(Lcom/sun/net/httpserver/HttpExchange;)V", "httpVerb", "getHttpVerb", "setHttpVerb", "(Ljava/lang/String;)V", "requestUri", "getRequestUri", "setRequestUri", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "copyStream", "", "is", "Ljava/io/InputStream;", "os", "Ljava/io/OutputStream;", "outputAlert", "errorCode", "", "serve", "Builder", "Companion", "plsar-framework"})
public final class ResourceResponse {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String GET;
    @NotNull
    private final String WEBAPP;
    @NotNull
    private final String CONTENTTYPE;
    @Nullable
    private PLSAR.Cache cache;
    @Nullable
    private String requestUri;
    @Nullable
    private String httpVerb;
    @Nullable
    private HttpExchange httpExchange;
    @NotNull
    private PLSAR.Support support;

    public ResourceResponse(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.GET = "get";
        this.WEBAPP = "webapp";
        this.CONTENTTYPE = "Content-Type";
        this.cache = builder.getCache();
        this.requestUri = builder.getRequestUri();
        this.httpVerb = builder.getHttpVerb();
        this.httpExchange = builder.getHttpExchange();
        this.support = new PLSAR.Support();
    }

    @NotNull
    public final String getGET() {
        return this.GET;
    }

    @NotNull
    public final String getWEBAPP() {
        return this.WEBAPP;
    }

    @NotNull
    public final String getCONTENTTYPE() {
        return this.CONTENTTYPE;
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    @Nullable
    public final String getRequestUri() {
        return this.requestUri;
    }

    public final void setRequestUri(@Nullable String string) {
        this.requestUri = string;
    }

    @Nullable
    public final String getHttpVerb() {
        return this.httpVerb;
    }

    public final void setHttpVerb(@Nullable String string) {
        this.httpVerb = string;
    }

    @Nullable
    public final HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    public final void setHttpExchange(@Nullable HttpExchange httpExchange) {
        this.httpExchange = httpExchange;
    }

    @NotNull
    public final PLSAR.Support getSupport() {
        return this.support;
    }

    public final void setSupport(@NotNull PLSAR.Support support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
        this.support = support;
    }

    public final void serve() throws IOException {
        InputStream fis = null;
        if (this.support.isJar()) {
            String string = this.requestUri;
            Intrinsics.checkNotNull((Object)string);
            if (StringsKt.startsWith$default((String)string, (String)"/", (boolean)false, (int)2, null)) {
                String string2 = this.requestUri;
                Intrinsics.checkNotNull((Object)string2);
                CharSequence charSequence = string2;
                Regex regex = new Regex("/");
                String string3 = "";
                this.requestUri = regex.replaceFirst(charSequence, string3);
            }
            String resourcePath = "/webapp/" + this.requestUri;
            InputStream ris = this.getClass().getResourceAsStream(resourcePath);
            if (ris != null) {
                ByteArrayOutputStream unebaos = new ByteArrayOutputStream();
                byte[] bytes = new byte[13312];
                int unelength = 0;
                while (true) {
                    int n;
                    int it = n = ris.read(bytes);
                    boolean bl = false;
                    unelength = it;
                    if (n == -1) break;
                    unebaos.write(bytes, 0, unelength);
                }
                MimeGetter mimeGetter = new MimeGetter(this.requestUri);
                String mimeType = mimeGetter.resolve();
                HttpExchange httpExchange = this.httpExchange;
                Intrinsics.checkNotNull((Object)httpExchange);
                httpExchange.getResponseHeaders().set(this.CONTENTTYPE, mimeType);
                if (Intrinsics.areEqual((Object)this.httpVerb, (Object)this.GET)) {
                    HttpExchange httpExchange2 = this.httpExchange;
                    Intrinsics.checkNotNull((Object)httpExchange2);
                    httpExchange2.sendResponseHeaders(200, unebaos.size());
                    HttpExchange httpExchange3 = this.httpExchange;
                    Intrinsics.checkNotNull((Object)httpExchange3);
                    OutputStream os = httpExchange3.getResponseBody();
                    os.write(unebaos.toByteArray());
                    os.close();
                    os.flush();
                } else {
                    HttpExchange httpExchange4 = this.httpExchange;
                    Intrinsics.checkNotNull((Object)httpExchange4);
                    httpExchange4.sendResponseHeaders(200, -1L);
                }
                ris.close();
            }
        } else {
            InputStream bytes;
            String webPath = ((Object)Paths.get(this.WEBAPP, new String[0])).toString();
            String filePath = webPath + this.requestUri;
            File file = new File(filePath);
            try {
                bytes = new FileInputStream(filePath);
            }
            catch (FileNotFoundException e) {
                this.outputAlert(this.httpExchange, 404);
                return;
            }
            fis = bytes;
            MimeGetter mimeGetter = new MimeGetter(filePath);
            String mimeType = mimeGetter.resolve();
            HttpExchange httpExchange = this.httpExchange;
            Intrinsics.checkNotNull((Object)httpExchange);
            httpExchange.getResponseHeaders().set(this.CONTENTTYPE, mimeType);
            if (Intrinsics.areEqual((Object)this.httpVerb, (Object)this.GET)) {
                HttpExchange httpExchange5 = this.httpExchange;
                Intrinsics.checkNotNull((Object)httpExchange5);
                httpExchange5.sendResponseHeaders(200, file.length());
                HttpExchange httpExchange6 = this.httpExchange;
                Intrinsics.checkNotNull((Object)httpExchange6);
                OutputStream os = httpExchange6.getResponseBody();
                Intrinsics.checkNotNullExpressionValue((Object)os, (String)"os");
                this.copyStream(fis, os);
                os.close();
                os.flush();
            } else {
                HttpExchange httpExchange7 = this.httpExchange;
                Intrinsics.checkNotNull((Object)httpExchange7);
                httpExchange7.sendResponseHeaders(200, -1L);
            }
            fis.close();
        }
    }

    private final void outputAlert(HttpExchange httpExchange, int errorCode) throws IOException {
        String message = "A8i/ resource missing! " + errorCode;
        Charset charset = Charset.forName("utf-8");
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
        byte[] byArray = message.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        byte[] messageBytes = byArray;
        HttpExchange httpExchange2 = httpExchange;
        Intrinsics.checkNotNull((Object)httpExchange2);
        httpExchange2.getResponseHeaders().set("Content-Type", "text/plain; charset=utf-8");
        httpExchange.sendResponseHeaders(errorCode, messageBytes.length);
        OutputStream os = httpExchange.getResponseBody();
        os.write(messageBytes);
        os.close();
    }

    private final void copyStream(InputStream is, OutputStream os) throws IOException {
        byte[] bytes = new byte[13312];
        int n = 0;
        while (true) {
            int n2;
            int it = n2 = is.read(bytes);
            boolean bl = false;
            n = it;
            if (n2 < 0) break;
            os.write(bytes, 0, n);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010 \u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0010\u0010!\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\nJ\u0010\u0010\"\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0010\u0010#\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0010J\u0016\u0010$\u001a\u00020\u00002\u000e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0019R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0012\"\u0004\b\u0017\u0010\u0014R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006%"}, d2={"Lplsar/util/ResourceResponse$Builder;", "", "()V", "cache", "Lplsar/PLSAR$Cache;", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "(Lplsar/PLSAR$Cache;)V", "httpExchange", "Lcom/sun/net/httpserver/HttpExchange;", "getHttpExchange", "()Lcom/sun/net/httpserver/HttpExchange;", "setHttpExchange", "(Lcom/sun/net/httpserver/HttpExchange;)V", "httpVerb", "", "getHttpVerb", "()Ljava/lang/String;", "setHttpVerb", "(Ljava/lang/String;)V", "requestUri", "getRequestUri", "setRequestUri", "resources", "", "getResources", "()Ljava/util/List;", "setResources", "(Ljava/util/List;)V", "make", "Lplsar/util/ResourceResponse;", "withCache", "withHttpExchange", "withHttpVerb", "withRequestUri", "withResources", "plsar-framework"})
    public static final class Builder {
        @Nullable
        private PLSAR.Cache cache;
        @Nullable
        private String requestUri;
        @Nullable
        private String httpVerb;
        @Nullable
        private List<String> resources;
        @Nullable
        private HttpExchange httpExchange;

        @Nullable
        public final PLSAR.Cache getCache() {
            return this.cache;
        }

        public final void setCache(@Nullable PLSAR.Cache cache) {
            this.cache = cache;
        }

        @Nullable
        public final String getRequestUri() {
            return this.requestUri;
        }

        public final void setRequestUri(@Nullable String string) {
            this.requestUri = string;
        }

        @Nullable
        public final String getHttpVerb() {
            return this.httpVerb;
        }

        public final void setHttpVerb(@Nullable String string) {
            this.httpVerb = string;
        }

        @Nullable
        public final List<String> getResources() {
            return this.resources;
        }

        public final void setResources(@Nullable List<String> list) {
            this.resources = list;
        }

        @Nullable
        public final HttpExchange getHttpExchange() {
            return this.httpExchange;
        }

        public final void setHttpExchange(@Nullable HttpExchange httpExchange) {
            this.httpExchange = httpExchange;
        }

        @NotNull
        public final Builder withRequestUri(@Nullable String requestUri) {
            this.requestUri = requestUri;
            return this;
        }

        @NotNull
        public final Builder withHttpVerb(@Nullable String httpVerb) {
            this.httpVerb = httpVerb;
            return this;
        }

        @NotNull
        public final Builder withCache(@Nullable PLSAR.Cache cache) {
            this.cache = cache;
            return this;
        }

        @NotNull
        public final Builder withResources(@Nullable List<String> resources) {
            this.resources = resources;
            return this;
        }

        @NotNull
        public final Builder withHttpExchange(@Nullable HttpExchange httpExchange) {
            this.httpExchange = httpExchange;
            return this;
        }

        @NotNull
        public final ResourceResponse make() {
            return new ResourceResponse(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a8\u0006\t"}, d2={"Lplsar/util/ResourceResponse$Companion;", "", "()V", "isResource", "", "requestUri", "", "cache", "Lplsar/PLSAR$Cache;", "plsar-framework"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isResource(@Nullable String requestUri, @Nullable PLSAR.Cache cache) {
            void $this$toTypedArray$iv;
            PLSAR.Cache cache2 = cache;
            if ((cache2 != null ? cache2.getResources() : null) == null) {
                return false;
            }
            String string = requestUri;
            Intrinsics.checkNotNull((Object)string);
            Object object = string;
            Regex regex = new Regex("/");
            int n = 0;
            object = regex.split((CharSequence)object, n);
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            if (stringArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            String[] bits = stringArray;
            if (bits.length > 1) {
                String resource = bits[1];
                PLSAR.Cache cache3 = cache;
                List<String> list = cache3 != null ? cache3.getResources() : null;
                Intrinsics.checkNotNull(list);
                if (list.contains(resource)) {
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

