/*
 * Decompiled with CFR 0.152.
 */
package plsar.util;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \f2\u00020\u0001:\u0001\fB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\b\u001a\u0004\u0018\u00010\u0003J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0003R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\r"}, d2={"Lplsar/util/MimeGetter;", "", "resourceUri", "", "(Ljava/lang/String;)V", "getResourceUri", "()Ljava/lang/String;", "setResourceUri", "resolve", "within", "", "key", "Companion", "plsar-framework"})
public final class MimeGetter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private String resourceUri;
    @NotNull
    private static final Map<String, String> MIME_MAP = new HashMap();

    public MimeGetter(@Nullable String resourceUri) {
        this.resourceUri = resourceUri;
    }

    @Nullable
    public final String getResourceUri() {
        return this.resourceUri;
    }

    public final void setResourceUri(@Nullable String string) {
        this.resourceUri = string;
    }

    public final boolean within(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return MIME_MAP.containsKey(key);
    }

    @Nullable
    public final String resolve() {
        String string = Companion.getExt(this.resourceUri).toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        String key = string;
        return MIME_MAP.containsKey(key) ? MIME_MAP.get(key) : "text/html";
    }

    static {
        MIME_MAP.put("appcache", "text/cache-manifest");
        MIME_MAP.put("css", "text/css");
        MIME_MAP.put("gif", "image/gif");
        MIME_MAP.put("html", "text/html");
        MIME_MAP.put("js", "application/javascript");
        MIME_MAP.put("json", "application/json");
        MIME_MAP.put("jpg", "image/jpeg");
        MIME_MAP.put("jpeg", "image/jpeg");
        MIME_MAP.put("mp4", "video/mp4");
        MIME_MAP.put("mp3", "audio/mp3");
        MIME_MAP.put("pdf", "application/pdf");
        MIME_MAP.put("png", "image/png");
        MIME_MAP.put("svg", "image/svg+xml");
        MIME_MAP.put("xlsm", "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        MIME_MAP.put("xml", "application/xml");
        MIME_MAP.put("zip", "application/zip");
        MIME_MAP.put("md", "text/plain");
        MIME_MAP.put("txt", "text/plain");
        MIME_MAP.put("php", "text/plain");
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u00020\u00052\b\u0010\t\u001a\u0004\u0018\u00010\u0005R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lplsar/util/MimeGetter$Companion;", "", "()V", "MIME_MAP", "", "", "getMIME_MAP", "()Ljava/util/Map;", "getExt", "path", "plsar-framework"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getExt(@Nullable String path) {
            String string;
            String string2;
            String string3 = path;
            Intrinsics.checkNotNull((Object)string3);
            int slashIndex = StringsKt.lastIndexOf$default((CharSequence)string3, (char)'/', (int)0, (boolean)false, (int)6, null);
            if (slashIndex < 0) {
                string2 = path;
            } else {
                String string4 = path.substring(slashIndex + 1);
                string2 = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            }
            String basename = string2;
            int dotIdx = StringsKt.lastIndexOf$default((CharSequence)basename, (char)'.', (int)0, (boolean)false, (int)6, null);
            if (dotIdx >= 0) {
                String string5 = basename.substring(dotIdx + 1);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = "";
            }
            return string;
        }

        @NotNull
        public final Map<String, String> getMIME_MAP() {
            return MIME_MAP;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

