/*
 * Decompiled with CFR 0.152.
 */
package plsar.startup;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.cargo.ElementStorage;
import plsar.jdbc.Mediator;
import plsar.model.Element;
import plsar.model.web.EndpointMappings;
import plsar.processor.AnnotationProcessor;
import plsar.processor.ConfigurationProcessor;
import plsar.processor.ElementProcessor;
import plsar.processor.EndpointProcessor;
import plsar.processor.InstanceProcessor;
import plsar.processor.PropertiesProcessor;
import plsar.util.Settings;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lplsar/startup/ContainerInit;", "", "()V", "Builder", "plsar-framework"})
public final class ContainerInit {

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020%H\u0002J\b\u0010'\u001a\u00020%H\u0002J\b\u0010(\u001a\u00020%H\u0002J\b\u0010)\u001a\u00020%H\u0002J\b\u0010*\u001a\u00020%H\u0002J\b\u0010+\u001a\u00020%H\u0002J\b\u0010,\u001a\u00020%H\u0002J\b\u0010-\u001a\u00020%H\u0002J\b\u0010.\u001a\u00020%H\u0002J\b\u0010/\u001a\u00020%H\u0002J\b\u00100\u001a\u00020%H\u0002J\u0010\u00101\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0015\u00102\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u00103J\u0010\u00104\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u00105\u001a\u00020\u00002\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001e\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!\u00a8\u00066"}, d2={"Lplsar/startup/ContainerInit$Builder;", "", "()V", "cache", "Lplsar/PLSAR$Cache;", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "(Lplsar/PLSAR$Cache;)V", "port", "", "getPort", "()Ljava/lang/Integer;", "setPort", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "repo", "Lplsar/PLSAR$Repo;", "getRepo", "()Lplsar/PLSAR$Repo;", "setRepo", "(Lplsar/PLSAR$Repo;)V", "settings", "Lplsar/util/Settings;", "getSettings", "()Lplsar/util/Settings;", "setSettings", "(Lplsar/util/Settings;)V", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "build", "Lplsar/startup/ContainerInit;", "dispatchEvent", "", "initDatabase", "runAnnotationProcessor", "runConfigProcessor", "runElementsProcessor", "runEndpointProcessor", "runInstanceProcessor", "runProcessors", "runPropertiesProcessor", "setAttributes", "setDbAttributes", "validateDatasource", "withCache", "withPort", "(Ljava/lang/Integer;)Lplsar/startup/ContainerInit$Builder;", "withRepo", "withSettings", "plsar-framework"})
    public static final class Builder {
        @Nullable
        private Integer port;
        @Nullable
        private PLSAR.Cache cache;
        @Nullable
        private PLSAR.Repo repo;
        @NotNull
        private PLSAR.Support support = new PLSAR.Support();
        @Nullable
        private Settings settings;

        @Nullable
        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(@Nullable Integer n) {
            this.port = n;
        }

        @Nullable
        public final PLSAR.Cache getCache() {
            return this.cache;
        }

        public final void setCache(@Nullable PLSAR.Cache cache) {
            this.cache = cache;
        }

        @Nullable
        public final PLSAR.Repo getRepo() {
            return this.repo;
        }

        public final void setRepo(@Nullable PLSAR.Repo repo) {
            this.repo = repo;
        }

        @NotNull
        public final PLSAR.Support getSupport() {
            return this.support;
        }

        public final void setSupport(@NotNull PLSAR.Support support) {
            Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
            this.support = support;
        }

        @Nullable
        public final Settings getSettings() {
            return this.settings;
        }

        public final void setSettings(@Nullable Settings settings) {
            this.settings = settings;
        }

        @NotNull
        public final Builder withRepo(@Nullable PLSAR.Repo repo) {
            this.repo = repo;
            return this;
        }

        @NotNull
        public final Builder withCache(@Nullable PLSAR.Cache cache) {
            this.cache = cache;
            return this;
        }

        @NotNull
        public final Builder withSettings(@Nullable Settings settings) {
            this.settings = settings;
            return this;
        }

        private final void setAttributes() {
            Element element = new Element();
            element.setElement(this.cache);
            Object object = this.cache;
            if (object != null && (object = ((PLSAR.Cache)object).getElementStorage()) != null && (object = ((ElementStorage)object).getElements()) != null) {
                object.put((String)"cache", (Element)element);
            }
            Element repoElement = new Element();
            repoElement.setElement(this.repo);
            Object object2 = this.cache;
            if (object2 != null && (object2 = ((PLSAR.Cache)object2).getElementStorage()) != null && (object2 = ((ElementStorage)object2).getElements()) != null) {
                object2.put((String)"repo", (Element)repoElement);
            }
            Element supportElement = new Element();
            supportElement.setElement(this.support);
            Object object3 = this.cache;
            if (object3 != null && (object3 = ((PLSAR.Cache)object3).getElementStorage()) != null && (object3 = ((ElementStorage)object3).getElements()) != null) {
                object3.put((String)"support", (Element)supportElement);
            }
            PLSAR.Cache cache = this.cache;
            if ((cache != null ? cache.getResources() : null) == null) {
                PLSAR.Cache cache2 = this.cache;
                Intrinsics.checkNotNull((Object)cache2);
                cache2.setResources(new ArrayList());
            }
            PLSAR.Cache cache3 = this.cache;
            if ((cache3 != null ? cache3.getPropertiesFiles() : null) == null) {
                PLSAR.Cache cache4 = this.cache;
                Intrinsics.checkNotNull((Object)cache4);
                cache4.setPropertiesFiles(new ArrayList());
            }
        }

        private final void initDatabase() throws Exception {
            Mediator mediator = new Mediator(this.settings, this.support, this.cache);
            Element element = new Element();
            element.setElement(mediator);
            Object object = this.cache;
            if (object != null && (object = ((PLSAR.Cache)object).getElementStorage()) != null && (object = ((ElementStorage)object).getElements()) != null) {
                object.put((String)"dbmediator", (Element)element);
            }
            mediator.createDb();
        }

        private final void validateDatasource() throws Exception {
            Element element;
            Object object = this.cache;
            Element element2 = object != null && (object = ((PLSAR.Cache)object).getElementStorage()) != null && (object = ((ElementStorage)object).getElements()) != null ? object.get("datasource") : (element = null);
            if (element != null) {
                Object object2 = element.getElement();
                if (object2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.sql.DataSource");
                }
                DataSource dataSource = (DataSource)object2;
                PLSAR.Repo repo = this.repo;
                Intrinsics.checkNotNull((Object)repo);
                repo.setDataSource(dataSource);
            }
        }

        private final void setDbAttributes() throws Exception {
            this.validateDatasource();
            this.initDatabase();
        }

        private final void dispatchEvent() throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
            PLSAR.Cache cache = this.cache;
            if ((cache != null ? cache.getEvents() : null) != null) {
                PLSAR.Cache cache2 = this.cache;
                Object object = cache2 != null ? cache2.getEvents() : null;
                Intrinsics.checkNotNull((Object)object);
                Object[] objectArray = new Class[]{PLSAR.Cache.class};
                Method setupComplete = object.getClass().getDeclaredMethod("setupComplete", (Class<?>[])objectArray);
                if (setupComplete != null) {
                    setupComplete.setAccessible(true);
                    PLSAR.Cache cache3 = this.cache;
                    objectArray = new Object[]{this.cache};
                    setupComplete.invoke(cache3 != null ? cache3.getEvents() : null, objectArray);
                }
            }
        }

        private final void runElementsProcessor() throws Exception {
            ElementProcessor elementsProcessor = new ElementProcessor(this.cache).run();
            PLSAR.Cache cache = this.cache;
            if (cache != null) {
                cache.setElementProcessor(elementsProcessor);
            }
        }

        private final void runConfigProcessor() throws Exception {
            Object object = this.cache;
            if ((object != null && (object = ((PLSAR.Cache)object).getElementProcessor()) != null ? ((ElementProcessor)object).getConfigurations() : null) != null) {
                Object object2 = this.cache;
                Integer n = object2 != null && (object2 = ((PLSAR.Cache)object2).getElementProcessor()) != null && (object2 = ((ElementProcessor)object2).getConfigurations()) != null ? Integer.valueOf(object2.size()) : null;
                Intrinsics.checkNotNull(n);
                if (n > 0) {
                    new ConfigurationProcessor(this.cache).run();
                }
            }
        }

        private final void runAnnotationProcessor() throws Exception {
            new AnnotationProcessor(this.cache).run();
        }

        private final void runEndpointProcessor() throws Exception {
            EndpointProcessor endpointProcessor = new EndpointProcessor(this.cache).run();
            EndpointMappings endpointMappings = endpointProcessor.getMappings();
            PLSAR.Cache cache = this.cache;
            if (cache != null) {
                cache.setEndpointMappings(endpointMappings);
            }
        }

        private final void runPropertiesProcessor() throws Exception {
            Object object = this.cache;
            Boolean bl = object != null && (object = ((PLSAR.Cache)object).getPropertiesFiles()) != null ? Boolean.valueOf(object.isEmpty()) : null;
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) {
                new PropertiesProcessor(this.cache).run();
            }
        }

        private final void runInstanceProcessor() throws Exception {
            new InstanceProcessor(this.cache).run();
        }

        private final void runProcessors() throws Exception {
            this.runPropertiesProcessor();
            this.runInstanceProcessor();
            this.runElementsProcessor();
            this.runConfigProcessor();
            this.runAnnotationProcessor();
            this.runEndpointProcessor();
        }

        @NotNull
        public final Builder withPort(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        @NotNull
        public final ContainerInit build() throws Exception {
            this.setAttributes();
            this.runProcessors();
            this.setDbAttributes();
            this.dispatchEvent();
            return new ContainerInit();
        }
    }
}

