/*
 * Decompiled with CFR 0.152.
 */
package plsar.processor;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.cargo.PropertyStorage;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0004J\u0006\u0010\u0012\u001a\u00020\u0013R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lplsar/processor/PropertiesProcessor;", "", "cache", "Lplsar/PLSAR$Cache;", "(Lplsar/PLSAR$Cache;)V", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "getPropertiesFile", "Ljava/io/InputStream;", "propertyFile", "", "run", "", "plsar-framework"})
public final class PropertiesProcessor {
    @Nullable
    private PLSAR.Cache cache;
    @NotNull
    private PLSAR.Support support;

    public PropertiesProcessor(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
        this.support = new PLSAR.Support();
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    @NotNull
    public final PLSAR.Support getSupport() {
        return this.support;
    }

    public final void setSupport(@NotNull PLSAR.Support support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
        this.support = support;
    }

    @NotNull
    protected final InputStream getPropertiesFile(@Nullable String propertyFile) throws Exception {
        InputStream inputStream = this.getClass().getResourceAsStream("/src/main/resources/" + propertyFile);
        if (inputStream == null) {
            String resourceUri = PLSAR.Support.Companion.getResourceUri();
            File file = new File(resourceUri + File.separator + propertyFile);
            if (!file.exists()) {
                throw new Exception(propertyFile + " properties file cannot be located...");
            }
            inputStream = new FileInputStream(file);
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() throws IOException {
        PLSAR.Cache cache = this.cache;
        if ((cache != null ? cache.getPropertiesFiles() : null) != null) {
            PLSAR.Cache cache2 = this.cache;
            List<String> list = cache2 != null ? cache2.getPropertiesFiles() : null;
            Intrinsics.checkNotNull(list);
            for (String propertyFile : list) {
                InputStream inputStream = null;
                Properties prop = null;
                try {
                    inputStream = this.getPropertiesFile(propertyFile);
                    prop = new Properties();
                    prop.load(inputStream);
                    Enumeration<?> properties = prop.propertyNames();
                    while (properties.hasMoreElements()) {
                        Object obj = properties.nextElement();
                        if (obj == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                        }
                        String key = (String)obj;
                        String value = prop.getProperty(key);
                        Object object = this.cache;
                        if (object == null || (object = ((PLSAR.Cache)object).getPropertyStorage()) == null || (object = ((PropertyStorage)object).getProperties()) == null) continue;
                        object.put((String)key, (String)value);
                    }
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                finally {
                    InputStream inputStream2 = inputStream;
                    if (inputStream2 == null) continue;
                    inputStream2.close();
                }
            }
        }
    }
}

