/*
 * Decompiled with CFR 0.152.
 */
package plsar.processor;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.annotate.Variable;
import plsar.annotate.verbs.Delete;
import plsar.annotate.verbs.Get;
import plsar.annotate.verbs.Post;
import plsar.model.InstanceDetails;
import plsar.model.web.EndpointMapping;
import plsar.model.web.EndpointMappings;
import plsar.model.web.TypeFeature;
import plsar.model.web.UrlBit;
import plsar.model.web.UrlBitFeatures;
import plsar.processor.ElementProcessor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 %2\u00020\u0001:\u0001%B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0016\u001a\u00020\u0017H\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0000J*\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0004J\u001a\u0010\"\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0004J\u001a\u0010#\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0004J\u001a\u0010$\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0011H\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR*\u0010\u000e\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u00110\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006&"}, d2={"Lplsar/processor/EndpointProcessor;", "", "cache", "Lplsar/PLSAR$Cache;", "(Lplsar/PLSAR$Cache;)V", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "mappings", "Lplsar/model/web/EndpointMappings;", "getMappings", "()Lplsar/model/web/EndpointMappings;", "setMappings", "(Lplsar/model/web/EndpointMappings;)V", "processed", "", "", "Lplsar/model/InstanceDetails;", "getProcessed", "()Ljava/util/Map;", "setProcessed", "(Ljava/util/Map;)V", "allAnnotationsProcessed", "", "processWebAnnotations", "", "run", "setBaseDetailsAdd", "path", "mapping", "Lplsar/model/web/EndpointMapping;", "method", "Ljava/lang/reflect/Method;", "instanceDetails", "setDeleteMapping", "setGetMapping", "setPostMapping", "Companion", "plsar-framework"})
public final class EndpointProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PLSAR.Cache cache;
    @NotNull
    private Map<String, InstanceDetails> processed;
    @NotNull
    private EndpointMappings mappings;
    @NotNull
    public static final String GET = "Get";
    @NotNull
    public static final String POST = "Post";
    @NotNull
    public static final String PUT = "Put";
    @NotNull
    public static final String DELETE = "Delete";

    public EndpointProcessor(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
        this.processed = new HashMap();
        this.mappings = new EndpointMappings();
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    @NotNull
    public final Map<String, InstanceDetails> getProcessed() {
        return this.processed;
    }

    public final void setProcessed(@NotNull Map<String, InstanceDetails> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.processed = map;
    }

    @NotNull
    public final EndpointMappings getMappings() {
        return this.mappings;
    }

    public final void setMappings(@NotNull EndpointMappings endpointMappings) {
        Intrinsics.checkNotNullParameter((Object)endpointMappings, (String)"<set-?>");
        this.mappings = endpointMappings;
    }

    @NotNull
    public final EndpointProcessor run() throws Exception {
        while (!this.allAnnotationsProcessed()) {
            this.processWebAnnotations();
        }
        return this;
    }

    private final boolean allAnnotationsProcessed() {
        Map<String, InstanceDetails> map;
        ElementProcessor elementProcessor;
        PLSAR.Cache cache = this.cache;
        return cache != null && (elementProcessor = cache.getElementProcessor()) != null && (map = elementProcessor.getHttpInstances()) != null ? this.processed.size() == map.size() : false;
    }

    private final void processWebAnnotations() throws Exception {
        block4: {
            Object object = this.cache;
            if (object == null || (object = ((PLSAR.Cache)object).getElementProcessor()) == null || (object = ((ElementProcessor)object).getHttpInstances()) == null) break block4;
            Map<String, InstanceDetails> $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, InstanceDetails>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Class<?> clazz;
                InstanceDetails value;
                Map.Entry<String, InstanceDetails> element$iv;
                Map.Entry<String, InstanceDetails> entry = element$iv = iterator.next();
                boolean bl = false;
                String key = entry.getKey();
                InstanceDetails instanceDetails = value = entry.getValue();
                Class<?> clazz2 = clazz = instanceDetails != null ? instanceDetails.getInstanceClass() : null;
                Intrinsics.checkNotNull(clazz2);
                Method[] methods = clazz2.getDeclaredMethods();
                Intrinsics.checkNotNullExpressionValue((Object)methods, (String)"methods");
                for (Method method : methods) {
                    if (method.isAnnotationPresent(Get.class)) {
                        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                        this.setGetMapping(method, value);
                        this.processed.put(key, value);
                    }
                    if (method.isAnnotationPresent(Post.class)) {
                        Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                        this.setPostMapping(method, value);
                        this.processed.put(key, value);
                    }
                    if (!method.isAnnotationPresent(Delete.class)) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)method, (String)"method");
                    this.setDeleteMapping(method, value);
                    this.processed.put(key, value);
                }
            }
        }
    }

    protected final void setGetMapping(@NotNull Method method, @Nullable InstanceDetails instanceDetails) throws Exception {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Get get = method.getAnnotation(Get.class);
        String path = get.value();
        EndpointMapping mapping = new EndpointMapping();
        mapping.setVerb(GET);
        this.setBaseDetailsAdd(path, mapping, method, instanceDetails);
    }

    protected final void setPostMapping(@NotNull Method method, @Nullable InstanceDetails instanceDetails) throws Exception {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Post post = method.getAnnotation(Post.class);
        String path = post.value();
        EndpointMapping mapping = new EndpointMapping();
        mapping.setVerb(POST);
        this.setBaseDetailsAdd(path, mapping, method, instanceDetails);
    }

    protected final void setDeleteMapping(@NotNull Method method, @Nullable InstanceDetails instanceDetails) throws Exception {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Delete delete = method.getAnnotation(Delete.class);
        String path = delete.value();
        EndpointMapping mapping = new EndpointMapping();
        mapping.setVerb(DELETE);
        this.setBaseDetailsAdd(path, mapping, method, instanceDetails);
    }

    /*
     * WARNING - void declaration
     */
    protected final void setBaseDetailsAdd(@NotNull String path, @NotNull EndpointMapping mapping, @NotNull Method method, @Nullable InstanceDetails instanceDetails) throws Exception {
        void $this$toTypedArray$iv;
        Object part;
        void $this$toTypedArray$iv22;
        Object details;
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        mapping.setTypeNames(new ArrayList<String>());
        Type[] types = method.getGenericParameterTypes();
        Intrinsics.checkNotNullExpressionValue((Object)types, (String)"types");
        for (Type type : types) {
            ArrayList<String> arrayList = mapping.getTypeNames();
            Intrinsics.checkNotNull(arrayList);
            arrayList.add(type.getTypeName());
        }
        List typeDetails = new ArrayList();
        Annotation[][] paramAnnotations = method.getParameterAnnotations();
        Class<?>[] paramTypes = method.getParameterTypes();
        int n = ((Object[])paramAnnotations).length;
        for (int n2 = 0; n2 < n; ++n2) {
            Annotation[] annotationArray;
            Intrinsics.checkNotNullExpressionValue((Object)paramAnnotations[n2], (String)"paramAnnotations[n]");
            for (Annotation a : annotationArray) {
                if (!(a instanceof Variable)) continue;
                details = new TypeFeature();
                ((TypeFeature)details).setName(paramTypes[n2].getTypeName());
                ((TypeFeature)details).setType(paramTypes[n2].getTypeName());
                typeDetails.add(details);
            }
        }
        StringBuilder regexPath = new StringBuilder();
        regexPath.append("\\/(");
        int count = 0;
        Object object = path;
        Regex regex = new Regex("/");
        int a = 0;
        object = regex.split((CharSequence)object, a);
        int $i$f$toTypedArray = 0;
        void thisCollection$iv = $this$toTypedArray$iv22;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] parts = stringArray;
        $i$f$toTypedArray = parts.length;
        for (int $this$toTypedArray$iv22 = 0; $this$toTypedArray$iv22 < $i$f$toTypedArray; ++$this$toTypedArray$iv22) {
            part = parts[$this$toTypedArray$iv22];
            ++count;
            if (Intrinsics.areEqual((Object)part, (Object)"")) continue;
            details = (CharSequence)part;
            if (new Regex("(\\{[a-zA-Z]*\\})").matches((CharSequence)details)) {
                regexPath.append("(.*[A-Za-z0-9])");
                mapping.getVariablePositions().add(count - 1);
            } else {
                StringBuilder stringBuilder = new StringBuilder().append('(');
                String string = ((String)part).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                regexPath.append(stringBuilder.append(string).append("){1}").toString());
            }
            if (count >= parts.length) continue;
            regexPath.append("\\/");
        }
        regexPath.append(")$");
        mapping.setRegexedPath(regexPath.toString());
        mapping.setTypeDetails(typeDetails);
        mapping.setPath(path);
        mapping.setMethod(method);
        mapping.setClassDetails(instanceDetails);
        String key = mapping.getVerb() + '-' + path;
        if (this.mappings.contains(key)) {
            throw new Exception("Request path + " + path + " exists multiple times.");
        }
        part = path;
        details = new Regex("/");
        int n3 = 0;
        part = details.split((CharSequence)part, n3);
        boolean $i$f$toTypedArray2 = false;
        void thisCollection$iv2 = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] bits = stringArray2;
        UrlBitFeatures urlBitFeatures = new UrlBitFeatures();
        List urlBits = new ArrayList();
        for (String bit : bits) {
            UrlBit urlBit = new UrlBit();
            if (StringsKt.contains$default((CharSequence)bit, (CharSequence)"{{", (boolean)false, (int)2, null) && StringsKt.contains$default((CharSequence)bit, (CharSequence)"}}", (boolean)false, (int)2, null)) {
                urlBit.setVariable(true);
            } else {
                urlBit.setVariable(false);
            }
            urlBits.add(urlBit);
        }
        urlBitFeatures.setUrlBits(urlBits);
        mapping.setUrlBitFeatures(urlBitFeatures);
        this.mappings.add(key, mapping);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lplsar/processor/EndpointProcessor$Companion;", "", "()V", "DELETE", "", "GET", "POST", "PUT", "plsar-framework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

