/*
 * Decompiled with CFR 0.152.
 */
package plsar.processor;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.annotate.Dependency;
import plsar.annotate.Property;
import plsar.cargo.ElementStorage;
import plsar.cargo.PropertyStorage;
import plsar.model.Element;
import plsar.model.InstanceDetails;
import plsar.model.web.MethodFeature;
import plsar.processor.ElementProcessor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010&\u001a\u00020'H\u0004J\u001c\u0010(\u001a\u00020)2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010,\u001a\u0004\u0018\u00010\u0001H\u0004J\u0010\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020\u000bH\u0004J\u0006\u0010/\u001a\u00020\u0000J\u001c\u0010\u0015\u001a\u00020'2\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001200H\u0002J\b\u00101\u001a\u00020)H\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R*\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R&\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00120\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\r\"\u0004\b\u0019\u0010\u000fR\"\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u00062"}, d2={"Lplsar/processor/ConfigurationProcessor;", "", "cache", "Lplsar/PLSAR$Cache;", "(Lplsar/PLSAR$Cache;)V", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "issues", "", "", "", "getIssues", "()Ljava/util/Map;", "setIssues", "(Ljava/util/Map;)V", "iterableMethods", "", "Lplsar/model/web/MethodFeature;", "getIterableMethods", "()Ljava/util/List;", "setIterableMethods", "(Ljava/util/List;)V", "methods", "getMethods", "setMethods", "processedMethods", "", "getProcessedMethods", "()Ljava/util/Set;", "setProcessedMethods", "(Ljava/util/Set;)V", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "allDependenciesProcessed", "", "createAddElement", "", "method", "Ljava/lang/reflect/Method;", "object", "process", "idx", "run", "", "setMapDependencyMethods", "plsar-framework"})
public final class ConfigurationProcessor {
    @Nullable
    private PLSAR.Cache cache;
    @NotNull
    private PLSAR.Support support;
    @NotNull
    private Map<String, MethodFeature> methods;
    @NotNull
    private List<MethodFeature> iterableMethods;
    @NotNull
    private Set<MethodFeature> processedMethods;
    @NotNull
    private Map<String, Integer> issues;

    public ConfigurationProcessor(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
        this.support = new PLSAR.Support();
        this.methods = new HashMap();
        this.processedMethods = new HashSet();
        this.iterableMethods = new ArrayList();
        this.issues = new HashMap();
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    @NotNull
    public final PLSAR.Support getSupport() {
        return this.support;
    }

    public final void setSupport(@NotNull PLSAR.Support support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
        this.support = support;
    }

    @NotNull
    public final Map<String, MethodFeature> getMethods() {
        return this.methods;
    }

    public final void setMethods(@NotNull Map<String, MethodFeature> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.methods = map;
    }

    @NotNull
    public final List<MethodFeature> getIterableMethods() {
        return this.iterableMethods;
    }

    public final void setIterableMethods(@NotNull List<MethodFeature> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.iterableMethods = list;
    }

    @NotNull
    public final Set<MethodFeature> getProcessedMethods() {
        return this.processedMethods;
    }

    public final void setProcessedMethods(@NotNull Set<MethodFeature> set) {
        Intrinsics.checkNotNullParameter(set, (String)"<set-?>");
        this.processedMethods = set;
    }

    @NotNull
    public final Map<String, Integer> getIssues() {
        return this.issues;
    }

    public final void setIssues(@NotNull Map<String, Integer> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.issues = map;
    }

    @NotNull
    public final ConfigurationProcessor run() throws Exception {
        this.setMapDependencyMethods();
        this.setIterableMethods(this.methods);
        while (!this.allDependenciesProcessed()) {
            this.process(0);
        }
        return this;
    }

    protected final void process(int idx) throws Exception {
        Integer classCount;
        int idx2 = idx;
        Object object = this.cache;
        Integer n = object != null && (object = ((PLSAR.Cache)object).getObjects()) != null ? Integer.valueOf(object.size()) : (classCount = null);
        if (idx2 > this.iterableMethods.size()) {
            idx2 = 0;
        }
        int n2 = this.iterableMethods.size();
        for (int z = idx2; z < n2; ++z) {
            Method method;
            MethodFeature methodFeature = this.iterableMethods.get(z);
            Method method2 = method = methodFeature.getMethod();
            Intrinsics.checkNotNull((Object)method2);
            String methodName = this.support.getName(method2.getName());
            Object instance = methodFeature.getInstance();
            try {
                Object dependency = method.invoke(instance, new Object[0]);
                String clsName = this.support.getName(dependency.getClass().getName());
                Object object2 = this.cache;
                if ((object2 != null && (object2 = ((PLSAR.Cache)object2).getObjects()) != null ? (InstanceDetails)object2.get(clsName) : null) != null) {
                    Object object3 = this.cache;
                    InstanceDetails instanceDetails = object3 != null && (object3 = ((PLSAR.Cache)object3).getObjects()) != null ? (InstanceDetails)object3.get(clsName) : null;
                    if (instanceDetails != null) {
                        instanceDetails.setInstance(dependency);
                    }
                } else {
                    InstanceDetails instanceDetails = new InstanceDetails();
                    instanceDetails.setInstanceClass(dependency.getClass());
                    instanceDetails.setName(clsName);
                    instanceDetails.setInstance(dependency);
                    Object object4 = this.cache;
                    if (object4 != null && (object4 = ((PLSAR.Cache)object4).getObjects()) != null) {
                        object4.put(clsName, instanceDetails);
                    }
                }
                this.createAddElement(method, dependency);
                this.processedMethods.add(methodFeature);
                continue;
            }
            catch (Exception ex) {
                this.process(z + 1);
                if (this.issues.get(methodName) != null) {
                    Integer n3 = this.issues.get(methodName);
                    Intrinsics.checkNotNull((Object)n3);
                    int count = ((Number)n3).intValue();
                    this.issues.replace(methodName, ++count);
                } else {
                    this.issues.put(methodName, 1);
                }
                if (this.issues.get(methodName) == null) continue;
                Integer n4 = this.issues.get(methodName);
                Intrinsics.checkNotNull((Object)n4);
                int n5 = ((Number)n4).intValue();
                Integer n6 = classCount;
                Intrinsics.checkNotNull((Object)n6);
                if (n5 < n6) continue;
                StringBuilder builder = new StringBuilder();
                for (Map.Entry<String, Integer> entry : this.issues.entrySet()) {
                    String key = entry.getKey();
                    Integer value = entry.getValue();
                    builder.append("       " + key + " :: " + value + " attempts \n");
                }
                throw new Exception("The following dependencies have not been resolved : \n\n\n" + builder + "\n\n" + ex);
            }
        }
    }

    private final boolean setIterableMethods(Map<String, MethodFeature> methods) {
        Iterator<Map.Entry<String, MethodFeature>> iterator = methods.entrySet().iterator();
        while (iterator.hasNext()) {
            MethodFeature value = iterator.next().getValue();
            this.iterableMethods.add(value);
        }
        return true;
    }

    protected final boolean allDependenciesProcessed() {
        return this.processedMethods.size() == this.iterableMethods.size();
    }

    protected final void createAddElement(@Nullable Method method, @Nullable Object object) {
        block0: {
            Element element = new Element();
            element.setElement(object);
            Method method2 = method;
            Intrinsics.checkNotNull((Object)method2);
            String classKey = this.support.getName(method2.getName());
            Object object2 = this.cache;
            if (object2 == null || (object2 = ((PLSAR.Cache)object2).getElementStorage()) == null || (object2 = ((ElementStorage)object2).getElements()) == null) break block0;
            object2.put((String)classKey, (Element)element);
        }
    }

    protected final void setMapDependencyMethods() throws Exception {
        PLSAR.Cache cache = this.cache;
        ElementProcessor elementProcessor = cache != null ? cache.getElementProcessor() : null;
        Intrinsics.checkNotNull((Object)elementProcessor);
        for (Class<?> config : elementProcessor.getConfigurations()) {
            Object instance = null;
            Class<?> clazz = config;
            Intrinsics.checkNotNull(clazz);
            Constructor<?>[] constructors = clazz.getConstructors();
            Intrinsics.checkNotNullExpressionValue(constructors, (String)"constructors");
            for (Constructor<?> constructor : constructors) {
                if (constructor.getParameterCount() != 0) continue;
                instance = constructor.newInstance(new Object[0]);
            }
            Method[] methodArray = config.getDeclaredMethods();
            List<Method> declaredMethods = Arrays.asList(Arrays.copyOf(methodArray, methodArray.length));
            for (Method method : declaredMethods) {
                String methodKey;
                if (!method.isAnnotationPresent(Dependency.class)) continue;
                String string = method.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"method.name");
                Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                if (this.methods.containsKey(methodKey)) {
                    throw new Exception("More than one dependency with the same name defined : " + method.getName());
                }
                Object object = this.cache;
                boolean bl = object != null && (object = ((PLSAR.Cache)object).getElementStorage()) != null && (object = ((ElementStorage)object).getElements()) != null ? object.containsKey(methodKey) : false;
                if (bl) {
                    Map<String, Element> map;
                    Element existingElement;
                    System.out.println((Object)"\n\n");
                    System.out.println((Object)"Warning: you elements being injected twice, once by configuration, the other via @Bind.");
                    System.out.println((Object)("Take a look at " + config.getName() + " and @Bind for " + method.getName()));
                    System.out.println((Object)"\n\n");
                    Object object2 = this.cache;
                    Map<String, Element> map2 = object2 != null && (object2 = ((PLSAR.Cache)object2).getElementStorage()) != null ? ((ElementStorage)object2).getElements() : null;
                    Intrinsics.checkNotNull(map2);
                    Element element = existingElement = map2.get(methodKey);
                    if (element != null) {
                        element.setElement(instance);
                    }
                    if ((map = this.cache) != null && (map = ((PLSAR.Cache)((Object)map)).getElementStorage()) != null && (map = ((ElementStorage)((Object)map)).getElements()) != null) {
                        map.replace(methodKey, existingElement);
                    }
                }
                MethodFeature methodFeature = new MethodFeature();
                methodFeature.setName(method.getName());
                methodFeature.setMethod(method);
                methodFeature.setInstance(instance);
                this.methods.put(methodKey, methodFeature);
            }
            Field[] fieldArray = config.getDeclaredFields();
            List<Field> declaredFields = Arrays.asList(Arrays.copyOf(fieldArray, fieldArray.length));
            for (Field field : declaredFields) {
                if (!field.isAnnotationPresent(Property.class)) continue;
                Property property = field.getAnnotation(Property.class);
                String key = property.value();
                Object object = this.cache;
                if (!(object != null && (object = ((PLSAR.Cache)object).getPropertyStorage()) != null && (object = ((PropertyStorage)object).getProperties()) != null ? object.containsKey(key) : false)) {
                    throw new Exception(key + " property is missing");
                }
                Object object3 = this.cache;
                Map<String, String> map = object3 != null && (object3 = ((PLSAR.Cache)object3).getPropertyStorage()) != null ? ((PropertyStorage)object3).getProperties() : null;
                Intrinsics.checkNotNull(map);
                String value = map.get(key);
                field.setAccessible(true);
                field.set(instance, value);
            }
        }
    }
}

