/*
 * Decompiled with CFR 0.152.
 */
package plsar.jdbc.datasource;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 <2\u00020\u0001:\u0002;<B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010*\u001a\u00020\u0006H\u0016J\u0018\u0010*\u001a\u00020\u00062\u0006\u0010+\u001a\u00020\f2\u0006\u0010,\u001a\u00020\fH\u0016J\n\u0010-\u001a\u0004\u0018\u00010.H\u0016J\b\u0010%\u001a\u00020$H\u0016J\n\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0016\u00101\u001a\u00020\u001e2\f\u00102\u001a\b\u0012\u0002\b\u0003\u0018\u000103H\u0016J\u0010\u00104\u001a\u0002052\u0006\u00106\u001a\u00020.H\u0016J\u0010\u0010'\u001a\u0002052\u0006\u00107\u001a\u00020$H\u0016J#\u00108\u001a\u0004\u0018\u0001H9\"\u0004\b\u0000\u001092\f\u00102\u001a\b\u0012\u0004\u0012\u0002H903H\u0016\u00a2\u0006\u0002\u0010:R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0011\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u000e\"\u0004\b\u0013\u0010\u0010R\u001c\u0010\u0014\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u000e\"\u0004\b\u0016\u0010\u0010R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u000e\"\u0004\b\u0019\u0010\u0010R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u000e\"\u0004\b\u001c\u0010\u0010R\u001a\u0010\u001d\u001a\u00020\u001eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001e\u0010#\u001a\u0004\u0018\u00010$X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010)\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u0006="}, d2={"Lplsar/jdbc/datasource/Basic;", "Ljavax/sql/DataSource;", "builder", "Lplsar/jdbc/datasource/Basic$Builder;", "(Lplsar/jdbc/datasource/Basic$Builder;)V", "conn", "Ljava/sql/Connection;", "getConn", "()Ljava/sql/Connection;", "setConn", "(Ljava/sql/Connection;)V", "dbDriver", "", "getDbDriver", "()Ljava/lang/String;", "setDbDriver", "(Ljava/lang/String;)V", "dbName", "getDbName", "setDbName", "dbPassword", "getDbPassword", "setDbPassword", "dbUrl", "getDbUrl", "setDbUrl", "dbUsername", "getDbUsername", "setDbUsername", "init", "", "getInit", "()Z", "setInit", "(Z)V", "loginTimeout", "", "getLoginTimeout", "()Ljava/lang/Integer;", "setLoginTimeout", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getConnection", "username", "password", "getLogWriter", "Ljava/io/PrintWriter;", "getParentLogger", "Ljava/util/logging/Logger;", "isWrapperFor", "iface", "Ljava/lang/Class;", "setLogWriter", "", "out", "seconds", "unwrap", "T", "(Ljava/lang/Class;)Ljava/lang/Object;", "Builder", "Companion", "plsar-framework"})
public final class Basic
implements DataSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean init;
    @Nullable
    private String dbDriver;
    @Nullable
    private String dbUrl;
    @Nullable
    private String dbName;
    @Nullable
    private String dbUsername;
    @Nullable
    private String dbPassword;
    @Nullable
    private Integer loginTimeout;
    @Nullable
    private Connection conn;
    @Nullable
    private static String DB;

    public Basic(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.init = true;
        this.dbDriver = builder.getDbDriver();
        this.dbUrl = builder.getDbUrl();
        this.dbName = builder.getDbName();
        this.dbUsername = builder.getDbUsername();
        this.dbPassword = builder.getDbPassword();
        DB = this.dbName;
    }

    public final boolean getInit() {
        return this.init;
    }

    public final void setInit(boolean bl) {
        this.init = bl;
    }

    @Nullable
    public final String getDbDriver() {
        return this.dbDriver;
    }

    public final void setDbDriver(@Nullable String string) {
        this.dbDriver = string;
    }

    @Nullable
    public final String getDbUrl() {
        return this.dbUrl;
    }

    public final void setDbUrl(@Nullable String string) {
        this.dbUrl = string;
    }

    @Nullable
    public final String getDbName() {
        return this.dbName;
    }

    public final void setDbName(@Nullable String string) {
        this.dbName = string;
    }

    @Nullable
    public final String getDbUsername() {
        return this.dbUsername;
    }

    public final void setDbUsername(@Nullable String string) {
        this.dbUsername = string;
    }

    @Nullable
    public final String getDbPassword() {
        return this.dbPassword;
    }

    public final void setDbPassword(@Nullable String string) {
        this.dbPassword = string;
    }

    @Nullable
    public final Integer getLoginTimeout() {
        return this.loginTimeout;
    }

    public final void setLoginTimeout(@Nullable Integer n) {
        this.loginTimeout = n;
    }

    @Nullable
    public final Connection getConn() {
        return this.conn;
    }

    public final void setConn(@Nullable Connection connection) {
        this.conn = connection;
    }

    @Override
    @NotNull
    public Connection getConnection() throws SQLException {
        Connection connection;
        try {
            Class.forName(this.dbDriver);
            Connection connection2 = DriverManager.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
            connection2.setAutoCommit(false);
            this.conn = connection2;
            connection = connection2;
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"{\n            Class.forN\u2026     connection\n        }");
        }
        catch (SQLException ex) {
            throw new RuntimeException("Problem connecting to the database", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Problem connecting to the database", ex);
        }
        return connection;
    }

    @Override
    @NotNull
    public Connection getConnection(@NotNull String username, @NotNull String password) throws SQLException {
        Connection connection;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        try {
            Class.forName(this.dbDriver);
            connection = DriverManager.getConnection(this.dbUrl, username, password);
            Intrinsics.checkNotNullExpressionValue((Object)connection, (String)"{\n            Class.forN\u2026name, password)\n        }");
        }
        catch (SQLException ex) {
            throw new RuntimeException("Problem connecting to the database", ex);
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("Problem connecting to the database", ex);
        }
        return connection;
    }

    @Override
    @Nullable
    public PrintWriter getLogWriter() throws SQLException {
        return null;
    }

    @Override
    public void setLogWriter(@NotNull PrintWriter out) throws SQLException {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.loginTimeout = seconds;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        Integer n = this.loginTimeout;
        Intrinsics.checkNotNull((Object)n);
        return n;
    }

    @Override
    @Nullable
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    @Override
    @Nullable
    public <T> T unwrap(@NotNull Class<T> iface) throws SQLException {
        Intrinsics.checkNotNullParameter(iface, (String)"iface");
        return null;
    }

    @Override
    public boolean isWrapperFor(@Nullable Class<?> iface) throws SQLException {
        return false;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0015\u001a\u00020\u0016J\u0010\u0010\t\u001a\u00020\u00002\b\u0010\t\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0017\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0018\u001a\u00020\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u0019\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001a\u001a\u00020\u00002\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0006\"\u0004\b\u000b\u0010\bR\u001c\u0010\f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u0006\"\u0004\b\u000e\u0010\bR\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0006\"\u0004\b\u0011\u0010\bR\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0006\"\u0004\b\u0014\u0010\b\u00a8\u0006\u001b"}, d2={"Lplsar/jdbc/datasource/Basic$Builder;", "", "()V", "dbDriver", "", "getDbDriver", "()Ljava/lang/String;", "setDbDriver", "(Ljava/lang/String;)V", "dbName", "getDbName", "setDbName", "dbPassword", "getDbPassword", "setDbPassword", "dbUrl", "getDbUrl", "setDbUrl", "dbUsername", "getDbUsername", "setDbUsername", "build", "Lplsar/jdbc/datasource/Basic;", "driver", "password", "url", "username", "plsar-framework"})
    public static final class Builder {
        @Nullable
        private String dbUrl;
        @Nullable
        private String dbName;
        @Nullable
        private String dbUsername;
        @Nullable
        private String dbPassword;
        @Nullable
        private String dbDriver;

        @Nullable
        public final String getDbUrl() {
            return this.dbUrl;
        }

        public final void setDbUrl(@Nullable String string) {
            this.dbUrl = string;
        }

        @Nullable
        public final String getDbName() {
            return this.dbName;
        }

        public final void setDbName(@Nullable String string) {
            this.dbName = string;
        }

        @Nullable
        public final String getDbUsername() {
            return this.dbUsername;
        }

        public final void setDbUsername(@Nullable String string) {
            this.dbUsername = string;
        }

        @Nullable
        public final String getDbPassword() {
            return this.dbPassword;
        }

        public final void setDbPassword(@Nullable String string) {
            this.dbPassword = string;
        }

        @Nullable
        public final String getDbDriver() {
            return this.dbDriver;
        }

        public final void setDbDriver(@Nullable String string) {
            this.dbDriver = string;
        }

        @NotNull
        public final Builder url(@Nullable String dbUrl) {
            this.dbUrl = dbUrl;
            return this;
        }

        @NotNull
        public final Builder dbName(@Nullable String dbName) {
            this.dbName = dbName;
            return this;
        }

        @NotNull
        public final Builder username(@Nullable String dbUsername) {
            this.dbUsername = dbUsername;
            return this;
        }

        @NotNull
        public final Builder password(@Nullable String dbPassword) {
            this.dbPassword = dbPassword;
            return this;
        }

        @NotNull
        public final Builder driver(@Nullable String dbDriver) {
            this.dbDriver = dbDriver;
            return this;
        }

        @NotNull
        public final Basic build() {
            return new Basic(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lplsar/jdbc/datasource/Basic$Companion;", "", "()V", "DB", "", "plsar-framework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

