/*
 * Decompiled with CFR 0.152.
 */
package plsar.jdbc;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Connection;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.h2.tools.RunScript;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.util.Settings;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B!\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001aR\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001c"}, d2={"Lplsar/jdbc/Mediator;", "", "settings", "Lplsar/util/Settings;", "support", "Lplsar/PLSAR$Support;", "cache", "Lplsar/PLSAR$Cache;", "(Lplsar/util/Settings;Lplsar/PLSAR$Support;Lplsar/PLSAR$Cache;)V", "CREATEDB_URI", "", "getCREATEDB_URI", "()Ljava/lang/String;", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "(Lplsar/PLSAR$Cache;)V", "getSettings", "()Lplsar/util/Settings;", "setSettings", "(Lplsar/util/Settings;)V", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "createDb", "", "dropDb", "plsar-framework"})
public final class Mediator {
    @Nullable
    private Settings settings;
    @NotNull
    private PLSAR.Support support;
    @Nullable
    private PLSAR.Cache cache;
    @NotNull
    private final String CREATEDB_URI;

    public Mediator(@Nullable Settings settings, @NotNull PLSAR.Support support, @Nullable PLSAR.Cache cache) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"support");
        this.settings = settings;
        this.support = support;
        this.cache = cache;
        this.CREATEDB_URI = "src/main/resources/create-db.sql";
    }

    @Nullable
    public final Settings getSettings() {
        return this.settings;
    }

    public final void setSettings(@Nullable Settings settings) {
        this.settings = settings;
    }

    @NotNull
    public final PLSAR.Support getSupport() {
        return this.support;
    }

    public final void setSupport(@NotNull PLSAR.Support support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
        this.support = support;
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    @NotNull
    public final String getCREATEDB_URI() {
        return this.CREATEDB_URI;
    }

    public final void createDb() throws Exception {
        String artifactPath = PLSAR.Support.Companion.getResourceUri();
        Settings settings = this.settings;
        Intrinsics.checkNotNull((Object)settings);
        if (!settings.isNoAction()) {
            Settings settings2 = this.settings;
            Intrinsics.checkNotNull((Object)settings2);
            if (settings2.isCreateDb()) {
                StringBuilder stringBuilder;
                StringBuilder createSql = null;
                if (this.support.isJar()) {
                    JarFile jarFile;
                    JarFile jarFile2 = jarFile = this.support.getJarFile();
                    Intrinsics.checkNotNull((Object)jarFile2);
                    JarEntry jarEntry = jarFile2.getJarEntry(this.CREATEDB_URI);
                    InputStream in = jarFile.getInputStream(jarEntry);
                    Intrinsics.checkNotNullExpressionValue((Object)in, (String)"`in`");
                    stringBuilder = this.support.convert(in);
                } else {
                    File createFile = new File(artifactPath + File.separator + "create-db.sql");
                    InputStream in = new FileInputStream(createFile);
                    stringBuilder = this.support.convert(in);
                }
                createSql = stringBuilder;
                PLSAR.Cache cache = this.cache;
                Intrinsics.checkNotNull((Object)cache);
                Object object = cache.getElement("datasource");
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type javax.sql.DataSource");
                }
                DataSource datasource = (DataSource)object;
                Connection conn = datasource.getConnection();
                Settings settings3 = this.settings;
                Intrinsics.checkNotNull((Object)settings3);
                if (settings3.isDropDb()) {
                    RunScript.execute((Connection)conn, (Reader)new StringReader("drop all objects;"));
                }
                RunScript.execute((Connection)conn, (Reader)new StringReader(createSql.toString()));
                conn.commit();
                conn.close();
            }
        }
    }

    public final void dropDb() {
        Settings settings = this.settings;
        Intrinsics.checkNotNull((Object)settings);
        if (!settings.isNoAction()) {
            Settings settings2 = this.settings;
            Intrinsics.checkNotNull((Object)settings2);
            if (settings2.isCreateDb()) {
                try {
                    PLSAR.Cache cache = this.cache;
                    Intrinsics.checkNotNull((Object)cache);
                    Object object = cache.getElement("datasource");
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type javax.sql.DataSource");
                    }
                    DataSource datasource = (DataSource)object;
                    Connection conn = datasource.getConnection();
                    RunScript.execute((Connection)conn, (Reader)new StringReader("drop all objects;"));
                    conn.commit();
                    conn.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

