/*
 * Decompiled with CFR 0.152.
 */
package plsar;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpServer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.net.InetSocketAddress;
import java.net.URL;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Scanner;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.cargo.ElementStorage;
import plsar.cargo.ObjectStorage;
import plsar.cargo.PropertyStorage;
import plsar.model.Element;
import plsar.model.InstanceDetails;
import plsar.model.web.EndpointMappings;
import plsar.model.web.HttpRequest;
import plsar.processor.ElementProcessor;
import plsar.processor.ExperienceProcessor;
import plsar.startup.ExchangeStartup;
import plsar.util.Settings;
import plsar.web.Fragment;
import plsar.web.HttpTransmission;
import plsar.web.Interceptor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\u0018\u0000 82\u00020\u0001:\u00056789:B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u0014J\u000e\u00101\u001a\u00020/2\u0006\u00102\u001a\u00020 J\u0006\u00103\u001a\u00020\u0000J\u0006\u00104\u001a\u000205R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R*\u0010\u0011\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u00140\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR*\u0010\u001f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010 0\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0016\"\u0004\b\"\u0010\u0018R\u0015\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\n\n\u0002\u0010'\u001a\u0004\b%\u0010&R\u001c\u0010(\u001a\u0004\u0018\u00010)X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-\u00a8\u0006;"}, d2={"Lplsar/PLSAR;", "", "builder", "Lplsar/PLSAR$Builder;", "(Lplsar/PLSAR$Builder;)V", "cache", "Lplsar/PLSAR$Cache;", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "(Lplsar/PLSAR$Cache;)V", "experienceProcessor", "Lplsar/processor/ExperienceProcessor;", "getExperienceProcessor", "()Lplsar/processor/ExperienceProcessor;", "setExperienceProcessor", "(Lplsar/processor/ExperienceProcessor;)V", "fragments", "", "", "Lplsar/web/Fragment;", "getFragments", "()Ljava/util/Map;", "setFragments", "(Ljava/util/Map;)V", "httpServer", "Lcom/sun/net/httpserver/HttpServer;", "getHttpServer", "()Lcom/sun/net/httpserver/HttpServer;", "setHttpServer", "(Lcom/sun/net/httpserver/HttpServer;)V", "interceptors", "Lplsar/web/Interceptor;", "getInterceptors", "setInterceptors", "port", "", "getPort", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "registerFragment", "", "fragment", "registerInterceptor", "interceptor", "start", "stop", "", "Builder", "Cache", "Companion", "Repo", "Support", "plsar-framework"})
public final class PLSAR {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final Integer port;
    @Nullable
    private Cache cache;
    @Nullable
    private Support support;
    @Nullable
    private ExperienceProcessor experienceProcessor;
    @Nullable
    private HttpServer httpServer;
    @NotNull
    private Map<String, Fragment> fragments;
    @NotNull
    private Map<String, Interceptor> interceptors;
    @NotNull
    public static final String SECURITYTAG = "plsar.sessions";
    @NotNull
    public static final String RESOURCES = "/src/main/resources/";

    public PLSAR(@NotNull Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        this.port = builder.getPort();
        this.support = builder.getSupport();
        this.httpServer = builder.getHttpServer();
        this.fragments = new HashMap();
        this.interceptors = new HashMap();
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    @Nullable
    public final Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable Cache cache) {
        this.cache = cache;
    }

    @Nullable
    public final Support getSupport() {
        return this.support;
    }

    public final void setSupport(@Nullable Support support) {
        this.support = support;
    }

    @Nullable
    public final ExperienceProcessor getExperienceProcessor() {
        return this.experienceProcessor;
    }

    public final void setExperienceProcessor(@Nullable ExperienceProcessor experienceProcessor) {
        this.experienceProcessor = experienceProcessor;
    }

    @Nullable
    public final HttpServer getHttpServer() {
        return this.httpServer;
    }

    public final void setHttpServer(@Nullable HttpServer httpServer) {
        this.httpServer = httpServer;
    }

    @NotNull
    public final Map<String, Fragment> getFragments() {
        return this.fragments;
    }

    public final void setFragments(@NotNull Map<String, Fragment> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.fragments = map;
    }

    @NotNull
    public final Map<String, Interceptor> getInterceptors() {
        return this.interceptors;
    }

    public final void setInterceptors(@NotNull Map<String, Interceptor> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.interceptors = map;
    }

    public final void stop() {
        block0: {
            HttpServer httpServer = this.httpServer;
            if (httpServer == null) break block0;
            httpServer.stop(0);
        }
    }

    @NotNull
    public final PLSAR start() throws Exception {
        ExperienceProcessor experienceProcessor = this.experienceProcessor = new ExperienceProcessor();
        Intrinsics.checkNotNull((Object)experienceProcessor);
        ExchangeStartup exchangeStartup = new ExchangeStartup(this.port, this.fragments, this.interceptors, experienceProcessor);
        exchangeStartup.start();
        this.cache = exchangeStartup.getCache();
        HttpTransmission modulator = new HttpTransmission(this.cache);
        HttpServer httpServer = this.httpServer;
        Intrinsics.checkNotNull((Object)httpServer);
        httpServer.createContext("/", modulator);
        HttpServer httpServer2 = this.httpServer;
        Intrinsics.checkNotNull((Object)httpServer2);
        httpServer2.start();
        return this;
    }

    public final boolean registerFragment(@NotNull Fragment fragment) {
        Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
        Support support = this.support;
        Intrinsics.checkNotNull((Object)support);
        String key = support.getName(fragment.getClass().getName());
        this.fragments.put(key, fragment);
        return true;
    }

    public final boolean registerInterceptor(@NotNull Interceptor interceptor) {
        Intrinsics.checkNotNullParameter((Object)interceptor, (String)"interceptor");
        Support support = this.support;
        Intrinsics.checkNotNull((Object)support);
        String key = support.getName(interceptor.getClass().getName());
        this.interceptors.put(key, interceptor);
        return true;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0010J\u0006\u0010\u001e\u001a\u00020\u001fJ\u0015\u0010\u000f\u001a\u00020\u00002\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\u0002\u0010 R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001e\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0015\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006!"}, d2={"Lplsar/PLSAR$Builder;", "", "()V", "executors", "Ljava/util/concurrent/ExecutorService;", "getExecutors", "()Ljava/util/concurrent/ExecutorService;", "setExecutors", "(Ljava/util/concurrent/ExecutorService;)V", "httpServer", "Lcom/sun/net/httpserver/HttpServer;", "getHttpServer", "()Lcom/sun/net/httpserver/HttpServer;", "setHttpServer", "(Lcom/sun/net/httpserver/HttpServer;)V", "port", "", "getPort", "()Ljava/lang/Integer;", "setPort", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "ambiance", "numberThreads", "create", "Lplsar/PLSAR;", "(Ljava/lang/Integer;)Lplsar/PLSAR$Builder;", "plsar-framework"})
    public static final class Builder {
        @Nullable
        private Integer port;
        @Nullable
        private HttpServer httpServer;
        @Nullable
        private ExecutorService executors;
        @Nullable
        private Support support;

        @Nullable
        public final Integer getPort() {
            return this.port;
        }

        public final void setPort(@Nullable Integer n) {
            this.port = n;
        }

        @Nullable
        public final HttpServer getHttpServer() {
            return this.httpServer;
        }

        public final void setHttpServer(@Nullable HttpServer httpServer) {
            this.httpServer = httpServer;
        }

        @Nullable
        public final ExecutorService getExecutors() {
            return this.executors;
        }

        public final void setExecutors(@Nullable ExecutorService executorService) {
            this.executors = executorService;
        }

        @Nullable
        public final Support getSupport() {
            return this.support;
        }

        public final void setSupport(@Nullable Support support) {
            this.support = support;
        }

        @NotNull
        public final Builder port(@Nullable Integer port) {
            this.port = port;
            return this;
        }

        @NotNull
        public final Builder ambiance(int numberThreads) throws IOException {
            block0: {
                this.support = new Support();
                this.executors = Executors.newFixedThreadPool(numberThreads);
                Integer n = this.port;
                Intrinsics.checkNotNull((Object)n);
                HttpServer httpServer = this.httpServer = HttpServer.create(new InetSocketAddress(n), 0);
                if (httpServer == null) break block0;
                httpServer.setExecutor(this.executors);
            }
            return this;
        }

        @NotNull
        public final PLSAR create() {
            return new PLSAR(this);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0001XB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010V\u001a\u0004\u0018\u00010\u00012\u0006\u0010W\u001a\u00020\u0013R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R#\u0010\u0011\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001c\u0010\u001d\u001a\u0004\u0018\u00010\u0001X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001c\u0010\"\u001a\u0004\u0018\u00010#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R,\u0010(\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010)\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0016\"\u0004\b+\u0010,R,\u0010-\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0006\u0012\u0004\u0018\u00010.\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010\u0016\"\u0004\b0\u0010,R\u001a\u00101\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001d\u00107\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u000209088F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\u0016R&\u0010;\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010<8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b=\u0010>\"\u0004\b?\u0010@R\u001a\u0010A\u001a\u00020BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bC\u0010D\"\u0004\bE\u0010FR\u001c\u0010G\u001a\u0004\u0018\u00010HX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR&\u0010M\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0018\u00010<8FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010>\"\u0004\bO\u0010@R\u001c\u0010P\u001a\u0004\u0018\u00010QX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010S\"\u0004\bT\u0010U\u00a8\u0006Y"}, d2={"Lplsar/PLSAR$Cache;", "", "builder", "Lplsar/PLSAR$Cache$Builder;", "(Lplsar/PLSAR$Cache$Builder;)V", "elementProcessor", "Lplsar/processor/ElementProcessor;", "getElementProcessor", "()Lplsar/processor/ElementProcessor;", "setElementProcessor", "(Lplsar/processor/ElementProcessor;)V", "elementStorage", "Lplsar/cargo/ElementStorage;", "getElementStorage", "()Lplsar/cargo/ElementStorage;", "setElementStorage", "(Lplsar/cargo/ElementStorage;)V", "elements", "", "", "Lplsar/model/Element;", "getElements", "()Ljava/util/Map;", "endpointMappings", "Lplsar/model/web/EndpointMappings;", "getEndpointMappings", "()Lplsar/model/web/EndpointMappings;", "setEndpointMappings", "(Lplsar/model/web/EndpointMappings;)V", "events", "getEvents", "()Ljava/lang/Object;", "setEvents", "(Ljava/lang/Object;)V", "experienceProcessor", "Lplsar/processor/ExperienceProcessor;", "getExperienceProcessor", "()Lplsar/processor/ExperienceProcessor;", "setExperienceProcessor", "(Lplsar/processor/ExperienceProcessor;)V", "fragments", "Lplsar/web/Fragment;", "getFragments", "setFragments", "(Ljava/util/Map;)V", "interceptors", "Lplsar/web/Interceptor;", "getInterceptors", "setInterceptors", "objectStorage", "Lplsar/cargo/ObjectStorage;", "getObjectStorage", "()Lplsar/cargo/ObjectStorage;", "setObjectStorage", "(Lplsar/cargo/ObjectStorage;)V", "objects", "", "Lplsar/model/InstanceDetails;", "getObjects", "propertiesFiles", "", "getPropertiesFiles", "()Ljava/util/List;", "setPropertiesFiles", "(Ljava/util/List;)V", "propertyStorage", "Lplsar/cargo/PropertyStorage;", "getPropertyStorage", "()Lplsar/cargo/PropertyStorage;", "setPropertyStorage", "(Lplsar/cargo/PropertyStorage;)V", "repo", "Lplsar/PLSAR$Repo;", "getRepo", "()Lplsar/PLSAR$Repo;", "setRepo", "(Lplsar/PLSAR$Repo;)V", "resources", "getResources", "setResources", "settings", "Lplsar/util/Settings;", "getSettings", "()Lplsar/util/Settings;", "setSettings", "(Lplsar/util/Settings;)V", "getElement", "name", "Builder", "plsar-framework"})
    public static final class Cache {
        @Nullable
        private Object events;
        @Nullable
        private Settings settings;
        @Nullable
        private Map<String, ? extends Fragment> fragments;
        @Nullable
        private Map<String, ? extends Interceptor> interceptors;
        @NotNull
        private ObjectStorage objectStorage;
        @NotNull
        private PropertyStorage propertyStorage;
        @NotNull
        private ElementStorage elementStorage;
        @Nullable
        private Repo repo;
        @Nullable
        private ExperienceProcessor experienceProcessor;
        @Nullable
        private ElementProcessor elementProcessor;
        @Nullable
        private EndpointMappings endpointMappings;
        @Nullable
        private List<String> resources;
        @Nullable
        private List<String> propertiesFiles;

        public Cache(@NotNull Builder builder) {
            Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
            this.repo = builder.getRepo();
            this.fragments = builder.getFragments();
            this.interceptors = builder.getInterceptors();
            this.settings = builder.getSettings();
            this.experienceProcessor = builder.getExperienceProcessor();
            this.elementStorage = new ElementStorage();
            this.propertyStorage = new PropertyStorage();
            this.objectStorage = new ObjectStorage();
        }

        @Nullable
        public final Object getEvents() {
            return this.events;
        }

        public final void setEvents(@Nullable Object object) {
            this.events = object;
        }

        @Nullable
        public final Settings getSettings() {
            return this.settings;
        }

        public final void setSettings(@Nullable Settings settings) {
            this.settings = settings;
        }

        @Nullable
        public final Map<String, Fragment> getFragments() {
            return this.fragments;
        }

        public final void setFragments(@Nullable Map<String, ? extends Fragment> map) {
            this.fragments = map;
        }

        @Nullable
        public final Map<String, Interceptor> getInterceptors() {
            return this.interceptors;
        }

        public final void setInterceptors(@Nullable Map<String, ? extends Interceptor> map) {
            this.interceptors = map;
        }

        @NotNull
        public final ObjectStorage getObjectStorage() {
            return this.objectStorage;
        }

        public final void setObjectStorage(@NotNull ObjectStorage objectStorage) {
            Intrinsics.checkNotNullParameter((Object)objectStorage, (String)"<set-?>");
            this.objectStorage = objectStorage;
        }

        @NotNull
        public final PropertyStorage getPropertyStorage() {
            return this.propertyStorage;
        }

        public final void setPropertyStorage(@NotNull PropertyStorage propertyStorage) {
            Intrinsics.checkNotNullParameter((Object)propertyStorage, (String)"<set-?>");
            this.propertyStorage = propertyStorage;
        }

        @NotNull
        public final ElementStorage getElementStorage() {
            return this.elementStorage;
        }

        public final void setElementStorage(@NotNull ElementStorage elementStorage) {
            Intrinsics.checkNotNullParameter((Object)elementStorage, (String)"<set-?>");
            this.elementStorage = elementStorage;
        }

        @Nullable
        public final Repo getRepo() {
            return this.repo;
        }

        public final void setRepo(@Nullable Repo repo) {
            this.repo = repo;
        }

        @Nullable
        public final ExperienceProcessor getExperienceProcessor() {
            return this.experienceProcessor;
        }

        public final void setExperienceProcessor(@Nullable ExperienceProcessor experienceProcessor) {
            this.experienceProcessor = experienceProcessor;
        }

        @Nullable
        public final ElementProcessor getElementProcessor() {
            return this.elementProcessor;
        }

        public final void setElementProcessor(@Nullable ElementProcessor elementProcessor) {
            this.elementProcessor = elementProcessor;
        }

        @Nullable
        public final EndpointMappings getEndpointMappings() {
            return this.endpointMappings;
        }

        public final void setEndpointMappings(@Nullable EndpointMappings endpointMappings) {
            this.endpointMappings = endpointMappings;
        }

        @Nullable
        public final Object getElement(@NotNull String name) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            String string = name.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String key = string;
            if (this.elementStorage.getElements().containsKey(key)) {
                Element element = this.elementStorage.getElements().get(key);
                object = element != null ? element.getElement() : null;
            } else {
                object = null;
            }
            return object;
        }

        @Nullable
        public final Map<String, Element> getElements() {
            return this.elementStorage.getElements();
        }

        @Nullable
        public final List<String> getResources() {
            Settings settings = this.settings;
            return settings != null ? settings.getResources() : null;
        }

        public final void setResources(@Nullable List<String> list) {
            this.resources = list;
        }

        @Nullable
        public final List<String> getPropertiesFiles() {
            Settings settings = this.settings;
            return settings != null ? settings.getPropertiesFiles() : null;
        }

        public final void setPropertiesFiles(@Nullable List<String> list) {
            this.propertiesFiles = list;
        }

        @NotNull
        public final Map<String, InstanceDetails> getObjects() {
            return this.objectStorage.getObjects();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010!\u001a\u00020\"J \u0010#\u001a\u00020\u00002\u0018\u0010\t\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\nJ \u0010$\u001a\u00020\u00002\u0018\u0010\u0011\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\nJ\u0010\u0010%\u001a\u00020\u00002\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0010\u0010&\u001a\u00020\u00002\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cJ\u0010\u0010'\u001a\u00020\u00002\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004R\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\bR,\u0010\t\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\f\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R,\u0010\u0011\u001a\u0014\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u0012\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u000e\"\u0004\b\u0014\u0010\u0010R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 \u00a8\u0006("}, d2={"Lplsar/PLSAR$Cache$Builder;", "", "()V", "experienceProcessor", "Lplsar/processor/ExperienceProcessor;", "getExperienceProcessor", "()Lplsar/processor/ExperienceProcessor;", "setExperienceProcessor", "(Lplsar/processor/ExperienceProcessor;)V", "fragments", "", "", "Lplsar/web/Fragment;", "getFragments", "()Ljava/util/Map;", "setFragments", "(Ljava/util/Map;)V", "interceptors", "Lplsar/web/Interceptor;", "getInterceptors", "setInterceptors", "repo", "Lplsar/PLSAR$Repo;", "getRepo", "()Lplsar/PLSAR$Repo;", "setRepo", "(Lplsar/PLSAR$Repo;)V", "settings", "Lplsar/util/Settings;", "getSettings", "()Lplsar/util/Settings;", "setSettings", "(Lplsar/util/Settings;)V", "make", "Lplsar/PLSAR$Cache;", "withFragments", "withInterceptors", "withRepo", "withSettings", "withUxProcessor", "plsar-framework"})
        public static final class Builder {
            @Nullable
            private Repo repo;
            @Nullable
            private Settings settings;
            @Nullable
            private ExperienceProcessor experienceProcessor;
            @Nullable
            private Map<String, ? extends Fragment> fragments;
            @Nullable
            private Map<String, ? extends Interceptor> interceptors;

            @Nullable
            public final Repo getRepo() {
                return this.repo;
            }

            public final void setRepo(@Nullable Repo repo) {
                this.repo = repo;
            }

            @Nullable
            public final Settings getSettings() {
                return this.settings;
            }

            public final void setSettings(@Nullable Settings settings) {
                this.settings = settings;
            }

            @Nullable
            public final ExperienceProcessor getExperienceProcessor() {
                return this.experienceProcessor;
            }

            public final void setExperienceProcessor(@Nullable ExperienceProcessor experienceProcessor) {
                this.experienceProcessor = experienceProcessor;
            }

            @Nullable
            public final Map<String, Fragment> getFragments() {
                return this.fragments;
            }

            public final void setFragments(@Nullable Map<String, ? extends Fragment> map) {
                this.fragments = map;
            }

            @Nullable
            public final Map<String, Interceptor> getInterceptors() {
                return this.interceptors;
            }

            public final void setInterceptors(@Nullable Map<String, ? extends Interceptor> map) {
                this.interceptors = map;
            }

            @NotNull
            public final Builder withSettings(@Nullable Settings settings) {
                this.settings = settings;
                return this;
            }

            @NotNull
            public final Builder withFragments(@Nullable Map<String, ? extends Fragment> fragments) {
                this.fragments = fragments;
                return this;
            }

            @NotNull
            public final Builder withInterceptors(@Nullable Map<String, ? extends Interceptor> interceptors) {
                this.interceptors = interceptors;
                return this;
            }

            @NotNull
            public final Builder withUxProcessor(@Nullable ExperienceProcessor experienceProcessor) {
                this.experienceProcessor = experienceProcessor;
                return this;
            }

            @NotNull
            public final Builder withRepo(@Nullable Repo repo) {
                this.repo = repo;
                return this;
            }

            @NotNull
            public final Cache make() {
                return new Cache(this);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0001'B\u0005\u00a2\u0006\u0002\u0010\u0002J#\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0004J4\u0010\u0015\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0086\u0002\u00a2\u0006\u0002\u0010\u0016J%\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\u0010\u0019J7\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u001b2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e2\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014\u00a2\u0006\u0002\u0010\u001cJ%\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\u0010\u001fJ%\u0010 \u001a\u00020\f2\u0006\u0010!\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000eH\u0004\u00a2\u0006\u0002\u0010\"J#\u0010#\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0010\u0010$\u001a\u00020%2\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004J#\u0010&\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u000e\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u000e\u00a2\u0006\u0002\u0010\u000fR\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006("}, d2={"Lplsar/PLSAR$Repo;", "", "()V", "ds", "Ljavax/sql/DataSource;", "getDs", "()Ljavax/sql/DataSource;", "setDs", "(Ljavax/sql/DataSource;)V", "delete", "", "preSql", "", "params", "", "(Ljava/lang/String;[Ljava/lang/Object;)Z", "extractData", "rs", "Ljava/sql/ResultSet;", "cls", "Ljava/lang/Class;", "get", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Class;)Ljava/lang/Object;", "getInt", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Integer;", "getList", "", "(Ljava/lang/String;[Ljava/lang/Object;Ljava/lang/Class;)Ljava/util/List;", "getLong", "", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/Long;", "hydrateSql", "sql", "(Ljava/lang/String;[Ljava/lang/Object;)Ljava/lang/String;", "save", "setDataSource", "", "update", "Companion", "plsar-framework"})
    public static final class Repo {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private DataSource ds;

        @Nullable
        public final DataSource getDs() {
            return this.ds;
        }

        public final void setDs(@Nullable DataSource dataSource) {
            this.ds = dataSource;
        }

        public final void setDataSource(@Nullable DataSource ds) {
            this.ds = ds;
        }

        @Nullable
        public final Object get(@NotNull String preSql, @NotNull Object[] params, @NotNull Class<?> cls) {
            Intrinsics.checkNotNullParameter((Object)preSql, (String)"preSql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            Object result = null;
            String sql = "";
            try {
                sql = this.hydrateSql(preSql, params);
                DataSource dataSource = this.ds;
                Intrinsics.checkNotNull((Object)dataSource);
                Connection connection = dataSource.getConnection();
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
                    result = this.extractData(rs, cls);
                }
                if (result == null) {
                    throw new Exception(cls + " not found using '" + sql + '\'');
                }
                connection.commit();
                connection.close();
            }
            catch (SQLException ex) {
                System.out.println((Object)("bad sql grammar : " + sql));
                System.out.println((Object)"\n\n\n");
                ex.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        @Nullable
        public final Integer getInt(@NotNull String preSql, @NotNull Object[] params) {
            Intrinsics.checkNotNullParameter((Object)preSql, (String)"preSql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Integer result = null;
            String sql = "";
            try {
                sql = this.hydrateSql(preSql, params);
                DataSource dataSource = this.ds;
                Intrinsics.checkNotNull((Object)dataSource);
                Connection connection = dataSource.getConnection();
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    result = Integer.parseInt(rs.getObject(1).toString());
                }
                if (result == null) {
                    throw new Exception("no results using '" + sql + '\'');
                }
                connection.commit();
                connection.close();
            }
            catch (SQLException ex) {
                System.out.println((Object)("bad sql grammar : " + sql));
                System.out.println((Object)"\n\n\n");
                ex.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        @Nullable
        public final Long getLong(@NotNull String preSql, @NotNull Object[] params) {
            Intrinsics.checkNotNullParameter((Object)preSql, (String)"preSql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Long result = null;
            String sql = "";
            try {
                sql = this.hydrateSql(preSql, params);
                DataSource dataSource = this.ds;
                Intrinsics.checkNotNull((Object)dataSource);
                Connection connection = dataSource.getConnection();
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                if (rs.next()) {
                    result = Long.parseLong(rs.getObject(1).toString());
                }
                if (result == null) {
                    throw new Exception("no results using '" + sql + '\'');
                }
                connection.commit();
                connection.close();
            }
            catch (SQLException ex) {
                System.out.println((Object)("bad sql grammar : " + sql));
                System.out.println((Object)"\n\n\n");
                ex.printStackTrace();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return result;
        }

        public final boolean save(@NotNull String preSql, @NotNull Object[] params) {
            Intrinsics.checkNotNullParameter((Object)preSql, (String)"preSql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            try {
                String sql = this.hydrateSql(preSql, params);
                DataSource dataSource = this.ds;
                Intrinsics.checkNotNull((Object)dataSource);
                Connection connection = dataSource.getConnection();
                Statement stmt = connection.createStatement();
                stmt.execute(sql);
                connection.commit();
                connection.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }

        @NotNull
        public final List<Object> getList(@NotNull String preSql, @NotNull Object[] params, @NotNull Class<?> cls) {
            Intrinsics.checkNotNullParameter((Object)preSql, (String)"preSql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            List results = new ArrayList();
            try {
                String sql = this.hydrateSql(preSql, params);
                DataSource dataSource = this.ds;
                Intrinsics.checkNotNull((Object)dataSource);
                Connection connection = dataSource.getConnection();
                Statement stmt = connection.createStatement();
                ResultSet rs = stmt.executeQuery(sql);
                results = new ArrayList();
                while (rs.next()) {
                    Intrinsics.checkNotNullExpressionValue((Object)rs, (String)"rs");
                    Object obj = this.extractData(rs, cls);
                    results.add(obj);
                }
                connection.commit();
                connection.close();
            }
            catch (ClassCastException ccex) {
                System.out.println((Object)"");
                System.out.println((Object)("Wrong Class type, attempted to cast the return data as a " + cls));
                System.out.println((Object)"");
                ccex.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return results;
        }

        public final boolean update(@NotNull String preSql, @NotNull Object[] params) {
            Intrinsics.checkNotNullParameter((Object)preSql, (String)"preSql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            try {
                String sql = this.hydrateSql(preSql, params);
                DataSource dataSource = this.ds;
                Intrinsics.checkNotNull((Object)dataSource);
                Connection connection = dataSource.getConnection();
                Statement stmt = connection.createStatement();
                boolean rs = stmt.execute(sql);
                connection.commit();
                connection.close();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
            return true;
        }

        public final boolean delete(@NotNull String preSql, @NotNull Object[] params) {
            Intrinsics.checkNotNullParameter((Object)preSql, (String)"preSql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            try {
                String sql = this.hydrateSql(preSql, params);
                DataSource dataSource = this.ds;
                Intrinsics.checkNotNull((Object)dataSource);
                Connection connection = dataSource.getConnection();
                Statement stmt = connection.createStatement();
                stmt.execute(sql);
                connection.commit();
                connection.close();
            }
            catch (Exception ex) {
                return false;
            }
            return true;
        }

        @NotNull
        protected final String hydrateSql(@NotNull String sql, @NotNull Object[] params) {
            Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            String sql2 = sql;
            for (Object object : params) {
                Object object2;
                if (object != null) {
                    String parameter = object.toString();
                    if (Intrinsics.areEqual((Object)object.getClass().getTypeName(), (Object)"java.lang.String")) {
                        parameter = StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)parameter, (String)"'", (String)"''", (boolean)false, (int)4, null), (String)"$", (String)"\\$", (boolean)false, (int)4, null), (String)"#", (String)"\\#", (boolean)false, (int)4, null), (String)"@", (String)"\\@", (boolean)false, (int)4, null);
                    }
                    object2 = sql2;
                    sql2 = new Regex("\\[\\+\\]").replaceFirst((CharSequence)object2, parameter);
                    continue;
                }
                CharSequence charSequence = sql2;
                object2 = new Regex("\\[\\+\\]");
                String string = "null";
                sql2 = object2.replaceFirst(charSequence, string);
            }
            return sql2;
        }

        @NotNull
        protected final Object extractData(@NotNull ResultSet rs, @NotNull Class<?> cls) throws Exception {
            Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            Object object = new Object();
            Constructor<?>[] constructors = cls.getConstructors();
            Intrinsics.checkNotNullExpressionValue(constructors, (String)"constructors");
            Constructor<?>[] constructorArray = constructors;
            int n = constructorArray.length;
            for (int i = 0; i < n; ++i) {
                Constructor<?> constructor = constructorArray[i];
                if (constructor.getParameterCount() != 0) continue;
                Intrinsics.checkNotNullExpressionValue(constructor.newInstance(new Object[0]), (String)"constructor.newInstance()");
            }
            Field[] fields = object.getClass().getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
            for (Field field : fields) {
                String name;
                field.setAccessible(true);
                String originalName = field.getName();
                String regex = "([a-z])([A-Z]+)";
                String replacement = "$1_$2";
                Intrinsics.checkNotNullExpressionValue((Object)originalName, (String)"originalName");
                CharSequence charSequence = originalName;
                Intrinsics.checkNotNullExpressionValue((Object)new Regex(regex).replace(charSequence, replacement).toLowerCase(), (String)"this as java.lang.String).toLowerCase()");
                Class<?> clazz = field.getType();
                Intrinsics.checkNotNullExpressionValue(clazz, (String)"field.type");
                Type type = clazz;
                if (!Companion.hasColumn(rs, name)) continue;
                if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"int") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Integer")) {
                    field.set(object, rs.getInt(name));
                    continue;
                }
                if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"double") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Double")) {
                    field.set(object, rs.getDouble(name));
                    continue;
                }
                if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"float") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Float")) {
                    field.set(object, Float.valueOf(rs.getFloat(name)));
                    continue;
                }
                if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"long") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Long")) {
                    field.set(object, rs.getLong(name));
                    continue;
                }
                if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"boolean") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Boolean")) {
                    field.set(object, rs.getBoolean(name));
                    continue;
                }
                if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.math.BigDecimal")) {
                    field.set(object, rs.getBigDecimal(name));
                    continue;
                }
                if (!Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.String")) continue;
                field.set(object, rs.getString(name));
            }
            return object;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lplsar/PLSAR$Repo$Companion;", "", "()V", "hasColumn", "", "rs", "Ljava/sql/ResultSet;", "columnName", "", "plsar-framework"})
        public static final class Companion {
            private Companion() {
            }

            public final boolean hasColumn(@NotNull ResultSet rs, @NotNull String columnName) throws SQLException {
                Intrinsics.checkNotNullParameter((Object)rs, (String)"rs");
                Intrinsics.checkNotNullParameter((Object)columnName, (String)"columnName");
                ResultSetMetaData rsmd = rs.getMetaData();
                int x = 1;
                int n = rsmd.getColumnCount();
                if (x <= n) {
                    while (true) {
                        String string = rsmd.getColumnName(x);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"rsmd.getColumnName(x)");
                        String string2 = string.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase()");
                        if (Intrinsics.areEqual((Object)columnName, (Object)string2)) {
                            return true;
                        }
                        if (x == n) break;
                        ++x;
                    }
                }
                return false;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0012\n\u0002\b\u0007\u0018\u0000 22\u00020\u0001:\u00012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u001a\u001a\u00060\u001bj\u0002`\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\u001f\u0010\u001f\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#H\u0086\u0002J\u0018\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u00042\b\u0010&\u001a\u0004\u0018\u00010'J\u0010\u0010(\u001a\u00020\u00042\b\u0010)\u001a\u0004\u0018\u00010\u0004J\u0010\u0010*\u001a\u00020\u00042\b\u0010+\u001a\u0004\u0018\u00010,J\u000e\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020\u001eJ\u001c\u0010/\u001a\u0004\u0018\u00010\u00012\u0006\u0010 \u001a\u00020!2\n\u0010\"\u001a\u0006\u0012\u0002\b\u00030#J\u0010\u00100\u001a\u00020\u00042\b\u00101\u001a\u0004\u0018\u00010\u0004R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u001a\u0010\n\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\t\"\u0004\b\u000b\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0012\u001a\u0004\u0018\u00010\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0006R\u0011\u0010\u0018\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u0006\u00a8\u00063"}, d2={"Lplsar/PLSAR$Support;", "", "()V", "classesUri", "", "getClassesUri", "()Ljava/lang/String;", "isFat", "", "()Z", "isJar", "setJar", "(Z)V", "jarEntries", "Ljava/util/Enumeration;", "Ljava/util/jar/JarEntry;", "getJarEntries", "()Ljava/util/Enumeration;", "jarFile", "Ljava/util/jar/JarFile;", "getJarFile", "()Ljava/util/jar/JarFile;", "main", "getMain", "project", "getProject", "convert", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "in", "Ljava/io/InputStream;", "get", "request", "Lplsar/model/web/HttpRequest;", "cls", "Ljava/lang/Class;", "getCookie", "cookieName", "headers", "Lcom/sun/net/httpserver/Headers;", "getName", "nameWithExt", "getPayload", "bytes", "", "getPayloadBytes", "requestStream", "propagate", "removeLast", "s", "Companion", "plsar-framework"})
    public static final class Support {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private boolean isJar = this.isFat();

        public final boolean isJar() {
            return this.isJar;
        }

        public final void setJar(boolean bl) {
            this.isJar = bl;
        }

        @NotNull
        public final String removeLast(@Nullable String s) {
            String string;
            if (s == null || s.length() == 0) {
                string = "";
            } else {
                String string2 = s.substring(0, s.length() - 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            }
            return string;
        }

        public final boolean isFat() {
            String uri = null;
            try {
                uri = this.getClassesUri();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            String string = uri;
            Intrinsics.checkNotNull((Object)string);
            return StringsKt.contains$default((CharSequence)string, (CharSequence)"jar:file:", (boolean)false, (int)2, null);
        }

        @NotNull
        public final String getPayload(@Nullable byte[] bytes) {
            StringBuilder sb = new StringBuilder();
            Intrinsics.checkNotNull((Object)bytes);
            for (byte b : bytes) {
                sb.append((char)b);
            }
            String string = sb.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sb.toString()");
            return string;
        }

        @NotNull
        public final byte[] getPayloadBytes(@NotNull InputStream requestStream) {
            Intrinsics.checkNotNullParameter((Object)requestStream, (String)"requestStream");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                byte[] buf = new byte[19456];
                int bytesRead = 0;
                while (true) {
                    int n;
                    int it = n = requestStream.read(buf);
                    boolean bl = false;
                    bytesRead = it;
                    if (n == -1) break;
                    bos.write(buf, 0, bytesRead);
                }
                requestStream.close();
                bos.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            byte[] byArray = bos.toByteArray();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"bos.toByteArray()");
            return byArray;
        }

        @NotNull
        public final Enumeration<JarEntry> getJarEntries() {
            JarFile jarFile;
            JarFile jarFile2 = jarFile = this.getJarFile();
            Intrinsics.checkNotNull((Object)jarFile2);
            Enumeration<JarEntry> enumeration = jarFile2.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"jarFile!!.entries()");
            return enumeration;
        }

        @NotNull
        public final String getName(@Nullable String nameWithExt) {
            String string = nameWithExt;
            Intrinsics.checkNotNull((Object)string);
            int index = StringsKt.lastIndexOf$default((CharSequence)string, (String)".", (int)0, (boolean)false, (int)6, null);
            String qualifiedName = nameWithExt;
            if (index > 0) {
                String string2 = qualifiedName.substring(index + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                qualifiedName = string2;
            }
            String string3 = qualifiedName.toLowerCase();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase()");
            return string3;
        }

        @NotNull
        public final String getMain() {
            try {
                JarFile jarFile;
                JarFile jarFile2 = jarFile = this.getJarFile();
                Intrinsics.checkNotNull((Object)jarFile2);
                JarEntry jarEntry = jarFile2.getJarEntry("META-INF/MANIFEST.MF");
                InputStream in = jarFile.getInputStream(jarEntry);
                Scanner scanner = new Scanner(in);
                String line = "";
                do {
                    Intrinsics.checkNotNullExpressionValue((Object)scanner.nextLine(), (String)"scanner.nextLine()");
                    if (!StringsKt.contains$default((CharSequence)line, (CharSequence)"Main-Class", (boolean)false, (int)2, null)) continue;
                    line = StringsKt.replace$default((String)line, (String)"Main-Class", (String)"", (boolean)false, (int)4, null);
                    break;
                } while (scanner.hasNext());
                String $this$trim$iv = StringsKt.replace$default((String)line, (String)":", (String)"", (boolean)false, (int)4, null);
                boolean $i$f$trim = false;
                CharSequence $this$trim$iv$iv = $this$trim$iv;
                boolean $i$f$trim2 = false;
                int startIndex$iv$iv = 0;
                int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                boolean startFound$iv$iv = false;
                while (startIndex$iv$iv <= endIndex$iv$iv) {
                    boolean match$iv$iv;
                    int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                    char it = $this$trim$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                    if (!startFound$iv$iv) {
                        if (!match$iv$iv) {
                            startFound$iv$iv = true;
                            continue;
                        }
                        ++startIndex$iv$iv;
                        continue;
                    }
                    if (!match$iv$iv) break;
                    --endIndex$iv$iv;
                }
                line = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                return line;
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
                throw new IllegalStateException("Apologies, it seems you are trying to run this as a jar but have not main defined.");
            }
        }

        @Nullable
        public final JarFile getJarFile() {
            try {
                URL jarUri = PLSAR.class.getClassLoader().getResource("plsar/");
                String string = jarUri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarUri.path");
                String string2 = string;
                int n = 5;
                String string3 = jarUri.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jarUri.path");
                int n2 = StringsKt.indexOf$default((CharSequence)string3, (String)"!", (int)0, (boolean)false, (int)6, null);
                String string4 = string2.substring(n, n2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                String jarPath = string4;
                return new JarFile(jarPath);
            }
            catch (IOException ex) {
                ex.printStackTrace();
                return null;
            }
        }

        @Nullable
        public final String getClassesUri() throws Exception {
            String[] stringArray = new String[]{"main", "kotlin"};
            String classesUri = ((Object)Paths.get("src", stringArray).toAbsolutePath()).toString();
            File classesDir = new File(classesUri);
            if (classesDir.exists()) {
                return classesUri;
            }
            String string = this.getClass().getResource("").toURI().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.getResource(\"\").toURI().toString()");
            classesUri = string;
            return classesUri;
        }

        @Nullable
        public final Object get(@NotNull HttpRequest request, @NotNull Class<?> cls) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            return this.propagate(request, cls);
        }

        @Nullable
        public final Object propagate(@NotNull HttpRequest request, @NotNull Class<?> cls) {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter(cls, (String)"cls");
            Object object = null;
            try {
                object = cls.getConstructor(new Class[0]).newInstance(new Object[0]);
                Field[] fields = cls.getDeclaredFields();
                Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
                for (Field field : fields) {
                    String name = field.getName();
                    String value = request.value(name);
                    if (value == null || Intrinsics.areEqual((Object)value, (Object)"")) continue;
                    field.setAccessible(true);
                    Class<?> clazz = field.getType();
                    Intrinsics.checkNotNullExpressionValue(clazz, (String)"field.type");
                    Type type = clazz;
                    if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"int") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Integer")) {
                        field.set(object, Integer.valueOf(value));
                    }
                    if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"double") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Double")) {
                        field.set(object, Double.valueOf(value));
                    }
                    if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"float") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Float")) {
                        field.set(object, Float.valueOf(value));
                    }
                    if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"long") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Long")) {
                        field.set(object, Long.valueOf(value));
                    }
                    if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"boolean") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Boolean")) {
                        field.set(object, Boolean.valueOf(value));
                    }
                    if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.math.BigDecimal")) {
                        field.set(object, new BigDecimal(value));
                    }
                    if (!Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.String")) continue;
                    field.set(object, value);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            return object;
        }

        @NotNull
        public final String getProject() {
            String string;
            if (this.isJar) {
                Object $this$toTypedArray$iv;
                JarFile jarFile;
                JarFile jarFile2 = jarFile = this.getJarFile();
                Intrinsics.checkNotNull((Object)jarFile2);
                String path = jarFile2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"path");
                Object object = path;
                Regex regex = new Regex("/");
                int n = 0;
                object = regex.split((CharSequence)object, n);
                boolean $i$f$toTypedArray2 = false;
                void thisCollection$iv2 = $this$toTypedArray$iv;
                String[] stringArray = thisCollection$iv2.toArray(new String[0]);
                if (stringArray == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                }
                String[] bits = stringArray;
                if (bits.length == 0) {
                    $this$toTypedArray$iv = path;
                    Regex $i$f$toTypedArray2 = new Regex("\\");
                    int thisCollection$iv2 = 0;
                    $this$toTypedArray$iv = $i$f$toTypedArray2.split((CharSequence)$this$toTypedArray$iv, thisCollection$iv2);
                    boolean $i$f$toTypedArray22 = false;
                    Object thisCollection$iv22 = $this$toTypedArray$iv;
                    String[] stringArray2 = thisCollection$iv22.toArray(new String[0]);
                    if (stringArray2 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    bits = stringArray2;
                }
                String namePre = bits[bits.length - 1];
                string = StringsKt.replace$default((String)namePre, (String)".jar", (String)"", (boolean)false, (int)4, null);
            } else {
                string = "";
            }
            return string;
        }

        @NotNull
        public final StringBuilder convert(@NotNull InputStream in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            StringBuilder builder = new StringBuilder();
            Scanner scanner = new Scanner(in);
            do {
                String string = scanner.nextLine();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scanner.nextLine()");
                builder.append(StringsKt.trimIndent((String)string));
            } while (scanner.hasNext());
            try {
                in.close();
            }
            catch (IOException ioex) {
                ioex.printStackTrace();
            }
            return builder;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String getCookie(@NotNull String cookieName, @Nullable Headers headers) {
            List cookies;
            Intrinsics.checkNotNullParameter((Object)cookieName, (String)"cookieName");
            String value = "";
            if (headers != null && (cookies = (List)headers.get("Cookie")) != null) {
                for (String cookie : cookies) {
                    String[] bits;
                    void $this$toTypedArray$iv;
                    Intrinsics.checkNotNullExpressionValue((Object)cookie, (String)"cookie");
                    Object object = cookie;
                    Regex regex = new Regex(";");
                    int n = 0;
                    object = regex.split((CharSequence)object, n);
                    boolean $i$f$toTypedArray = false;
                    void thisCollection$iv = $this$toTypedArray$iv;
                    if (thisCollection$iv.toArray(new String[0]) == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    for (String completes : bits) {
                        boolean match$iv$iv;
                        char it;
                        int index$iv$iv;
                        String[] parts;
                        void $this$toTypedArray$iv2;
                        Object object2 = completes;
                        Regex regex2 = new Regex("=");
                        int n2 = 0;
                        object2 = regex2.split((CharSequence)object2, n2);
                        boolean $i$f$toTypedArray2 = false;
                        void thisCollection$iv2 = $this$toTypedArray$iv2;
                        if (thisCollection$iv2.toArray(new String[0]) == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String $this$trim$iv = parts[0];
                        boolean $i$f$trim = false;
                        CharSequence $this$trim$iv$iv = $this$trim$iv;
                        boolean $i$f$trim2 = false;
                        int startIndex$iv$iv = 0;
                        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        boolean startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        String key = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                        if (parts.length <= 1 || !Intrinsics.areEqual((Object)key, (Object)cookieName)) continue;
                        $this$trim$iv = parts[1];
                        $i$f$trim = false;
                        $this$trim$iv$iv = $this$trim$iv;
                        $i$f$trim2 = false;
                        startIndex$iv$iv = 0;
                        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                            it = $this$trim$iv$iv.charAt(index$iv$iv);
                            boolean bl = false;
                            boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        value = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                    }
                }
            }
            return value;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lplsar/PLSAR$Support$Companion;", "", "()V", "resourceUri", "", "getResourceUri", "()Ljava/lang/String;", "SESSION_GUID", "z", "", "plsar-framework"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final String SESSION_GUID(int z) {
                String CHARS = ".01234567890";
                StringBuilder guid = new StringBuilder();
                guid.append("A8i.");
                Random rnd = new Random();
                while (guid.length() < z) {
                    int index = (int)(rnd.nextFloat() * (float)CHARS.length());
                    guid.append(CHARS.charAt(index));
                }
                String string = guid.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"guid.toString()");
                return string;
            }

            @NotNull
            public final String getResourceUri() throws Exception {
                String[] stringArray = new String[]{"main", "resources"};
                String resourceUri = ((Object)Paths.get("src", stringArray).toAbsolutePath()).toString();
                File resourceDir = new File(resourceUri);
                if (resourceDir.exists()) {
                    return resourceUri;
                }
                String RESOURCES_URI = PLSAR.RESOURCES;
                URL uRL = PLSAR.class.getResource(RESOURCES_URI);
                if (uRL == null) {
                    throw new FileNotFoundException("A8i : unable to find resource " + RESOURCES_URI);
                }
                URL indexUri = uRL;
                String string = indexUri.toURI().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"indexUri.toURI().toString()");
                return string;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lplsar/PLSAR$Companion;", "", "()V", "RESOURCES", "", "SECURITYTAG", "plsar-framework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

