/*
 * Decompiled with CFR 0.152.
 */
package plsar.web;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.annotate.Design;
import plsar.annotate.Json;
import plsar.annotate.Media;
import plsar.annotate.Meta;
import plsar.annotate.Plain;
import plsar.annotate.Text;
import plsar.annotate.Title;
import plsar.model.InstanceDetails;
import plsar.model.web.EndpointMapping;
import plsar.model.web.EndpointMappings;
import plsar.model.web.EndpointPosition;
import plsar.model.web.HttpRequest;
import plsar.model.web.HttpResponse;
import plsar.model.web.HttpSession;
import plsar.model.web.UrlBit;
import plsar.model.web.UrlBitFeatures;
import plsar.processor.ExperienceProcessor;
import plsar.util.MimeGetter;
import plsar.util.ResourceResponse;
import plsar.util.UriTranslator;
import plsar.web.ElementCompiler;
import plsar.web.Fragment;
import plsar.web.Interceptor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 92\u00020\u0001:\u00019B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J?\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00172\b\u0010\u0019\u001a\u0004\u0018\u00010\n2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0002\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\b\u0012\u0004\u0012\u00020%0$2\b\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010'\u001a\u00020\u001fH\u0004J\u001c\u0010(\u001a\u0004\u0018\u00010\u001f2\u0006\u0010)\u001a\u00020\n2\b\u0010&\u001a\u0004\u0018\u00010\nH\u0004J\u0010\u0010*\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020!H\u0004J%\u0010,\u001a\b\u0012\u0004\u0012\u00020\n0$2\u0012\u0010-\u001a\u000e\u0012\b\u0012\u0006\u0012\u0002\b\u00030.\u0018\u00010\u0017\u00a2\u0006\u0002\u0010/J\u0018\u00100\u001a\b\u0012\u0004\u0012\u00020\n0$2\b\u0010&\u001a\u0004\u0018\u00010\nH\u0004J\u0010\u00101\u001a\u00020\n2\u0006\u0010&\u001a\u00020\nH\u0004J\u0018\u00102\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010$2\u0006\u0010'\u001a\u00020\u001fH\u0004J\u0010\u00103\u001a\u0002042\u0006\u0010 \u001a\u00020!H\u0016J\u001c\u00105\u001a\u0002062\b\u0010&\u001a\u0004\u0018\u00010\n2\b\u00107\u001a\u0004\u0018\u00010\nH\u0004J\u001a\u00108\u001a\u0002062\b\u0010&\u001a\u0004\u0018\u00010\n2\u0006\u0010\u001e\u001a\u00020\u001fH\u0004R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R*\u0010\b\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006:"}, d2={"Lplsar/web/HttpTransmission;", "Lcom/sun/net/httpserver/HttpHandler;", "cache", "Lplsar/PLSAR$Cache;", "(Lplsar/PLSAR$Cache;)V", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "sessions", "", "", "Lplsar/model/web/HttpSession;", "getSessions", "()Ljava/util/Map;", "setSessions", "(Ljava/util/Map;)V", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "getEndpointParameters", "", "", "requestUri", "httpRequest", "Lplsar/model/web/HttpRequest;", "httpResponse", "Lplsar/model/web/HttpResponse;", "endpointMapping", "Lplsar/model/web/EndpointMapping;", "httpExchange", "Lcom/sun/net/httpserver/HttpExchange;", "(Ljava/lang/String;Lplsar/model/web/HttpRequest;Lplsar/model/web/HttpResponse;Lplsar/model/web/EndpointMapping;Lcom/sun/net/httpserver/HttpExchange;)[Ljava/lang/Object;", "getEndpointValues", "", "Lplsar/model/web/EndpointPosition;", "uri", "mapping", "getHttpMapping", "verb", "getHttpResponse", "exchange", "getParameterTypes", "clsParamaters", "Ljava/lang/Class;", "([Ljava/lang/Class;)Ljava/util/List;", "getPathParts", "getRedirect", "getRegexParts", "handle", "", "lengthMatches", "", "mappingUri", "variablesMatchUp", "Companion", "plsar-framework"})
public final class HttpTransmission
implements HttpHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PLSAR.Cache cache;
    @NotNull
    private PLSAR.Support support;
    @NotNull
    private Map<String, HttpSession> sessions;
    @NotNull
    public static final String REDIRECT = "[redirect]";

    public HttpTransmission(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
        this.support = new PLSAR.Support();
        this.sessions = new ConcurrentHashMap();
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    @NotNull
    public final PLSAR.Support getSupport() {
        return this.support;
    }

    public final void setSupport(@NotNull PLSAR.Support support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
        this.support = support;
    }

    @NotNull
    public final Map<String, HttpSession> getSessions() {
        return this.sessions;
    }

    public final void setSessions(@NotNull Map<String, HttpSession> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.sessions = map;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void handle(@NotNull HttpExchange httpExchange) {
        Intrinsics.checkNotNullParameter((Object)httpExchange, (String)"httpExchange");
        OutputStream outputStream = httpExchange.getResponseBody();
        try {
            Method method;
            EndpointMapping endpointMapping;
            Map<String, Interceptor> interceptors;
            InputStream inputStream = httpExchange.getRequestBody();
            Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"inputStream");
            byte[] payloadBytes = this.support.getPayloadBytes(inputStream);
            ElementCompiler requestCompiler = new ElementCompiler(this.cache, payloadBytes, this.sessions, httpExchange);
            HttpRequest httpRequest = requestCompiler.compile();
            String payload = this.support.getPayload(payloadBytes);
            httpRequest.setRequestBody(payload);
            PLSAR.Cache cache = this.cache;
            Map<String, Interceptor> map = interceptors = cache != null ? cache.getInterceptors() : null;
            Intrinsics.checkNotNull(map);
            Iterator<Map.Entry<String, Interceptor>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Interceptor interceptor;
                Interceptor interceptor2 = interceptor = iterator.next().getValue();
                Intrinsics.checkNotNull((Object)interceptor2);
                interceptor2.intercept(httpRequest, httpExchange);
            }
            UriTranslator transformer = new UriTranslator(this.support, httpExchange);
            String requestUri = transformer.translate();
            httpRequest.setValues(transformer.getParameters());
            String string = httpExchange.getRequestMethod();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"httpExchange.requestMethod");
            String string2 = string.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            String httpVerb = string2;
            if (ResourceResponse.Companion.isResource(requestUri, this.cache)) {
                new ResourceResponse.Builder().withCache(this.cache).withRequestUri(requestUri).withHttpVerb(httpVerb).withHttpExchange(httpExchange).make().serve();
                return;
            }
            HttpResponse httpResponse = this.getHttpResponse(httpExchange);
            if (httpRequest.getSession() != null) {
                HttpSession httpSession;
                HttpSession httpSession2 = httpSession = httpRequest.getSession();
                Intrinsics.checkNotNull((Object)httpSession2);
                for (Map.Entry<String, Object> object : httpSession2.data().entrySet()) {
                    String key = object.getKey();
                    Object value1 = object.getValue();
                    String value = value1.toString();
                    httpResponse.set(key, value);
                }
            }
            if ((endpointMapping = this.getHttpMapping(httpVerb, requestUri)) == null) {
                try {
                    String message = "404 not found.";
                    httpExchange.sendResponseHeaders(200, message.length());
                    String string3 = message;
                    byte[] byArray = string3.getBytes(Charsets.UTF_8);
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                    outputStream.write(byArray);
                    outputStream.flush();
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                return;
            }
            Object[] signature = this.getEndpointParameters(requestUri, httpRequest, httpResponse, endpointMapping, httpExchange);
            Method method2 = method = endpointMapping.getMethod();
            Intrinsics.checkNotNull((Object)method2);
            method2.setAccessible(true);
            String design = null;
            if (method.isAnnotationPresent(Design.class)) {
                Design annotationDos = method.getAnnotation(Design.class);
                design = annotationDos.value();
            }
            InstanceDetails instanceDetails = endpointMapping.getClassDetails();
            Object instance = instanceDetails != null ? instanceDetails.getInstance() : null;
            Parameter[] numberOfParameters = method.getParameters();
            String methodResponse = null;
            if (numberOfParameters.length == 0) {
                Object object = method.invoke(instance, new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                methodResponse = (String)object;
            } else {
                Object object = method.invoke(instance, Arrays.copyOf(signature, signature.length));
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
                }
                methodResponse = (String)object;
            }
            if (method.isAnnotationPresent(Text.class) || method.isAnnotationPresent(Plain.class)) {
                Headers headers = httpExchange.getResponseHeaders();
                headers.add("content-type", "text/html");
                httpExchange.sendResponseHeaders(200, methodResponse.length());
                String string4 = methodResponse;
                byte[] byArray = string4.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                outputStream.write(byArray);
            } else if (method.isAnnotationPresent(Json.class)) {
                Headers headers = httpExchange.getResponseHeaders();
                headers.add("content-type", "application/json");
                httpExchange.sendResponseHeaders(200, methodResponse.length());
                String string5 = methodResponse;
                byte[] byArray = string5.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                outputStream.write(byArray);
            } else if (method.isAnnotationPresent(Media.class)) {
                MimeGetter mimeGetter = new MimeGetter(requestUri);
                Headers headers = httpExchange.getResponseHeaders();
                headers.add("content-type", mimeGetter.resolve());
                String string6 = methodResponse;
                byte[] byArray = string6.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                outputStream.write(byArray);
            } else {
                Object webPath;
                if (StringsKt.startsWith$default((String)methodResponse, (String)REDIRECT, (boolean)false, (int)2, null)) {
                    httpExchange.setAttribute("message", httpResponse.get("message"));
                    String redirect = this.getRedirect(methodResponse);
                    Headers headers = httpExchange.getResponseHeaders();
                    headers.add("Location", redirect);
                    httpExchange.sendResponseHeaders(302, -1L);
                    httpExchange.close();
                    return;
                }
                String title = httpResponse.getTitle();
                String keywords = httpResponse.getKeywords();
                String description = httpResponse.getDescription();
                if (method.isAnnotationPresent(Title.class)) {
                    System.out.println((Object)"title annotation present");
                    Title titleAnnotation = method.getAnnotation(Title.class);
                    title = titleAnnotation.value();
                }
                if (method.isAnnotationPresent(Meta.class)) {
                    System.out.println((Object)"meta annotation present");
                    Meta meta = method.getAnnotation(Meta.class);
                    keywords = meta.keywords();
                    description = meta.description();
                }
                System.out.println((Object)(title + ", " + keywords + ", " + description));
                if (!this.support.isJar()) {
                    String htmlPath;
                    File viewFile;
                    webPath = Paths.get("web-ux", new String[0]);
                    if (StringsKt.startsWith$default((String)methodResponse, (String)"/", (boolean)false, (int)2, null)) {
                        CharSequence charSequence = methodResponse;
                        Regex regex = new Regex("/");
                        String string7 = "";
                        methodResponse = regex.replaceFirst(charSequence, string7);
                    }
                    if (!(viewFile = new File(htmlPath = webPath.toFile().getAbsolutePath() + File.separator + methodResponse)).exists()) {
                        try {
                            String message = "view " + htmlPath + " cannot be found.";
                            httpExchange.sendResponseHeaders(200, message.length());
                            String string8 = message;
                            byte[] byArray = string8.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                            outputStream.write(byArray);
                            outputStream.flush();
                            outputStream.close();
                            return;
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    InputStream fis = new FileInputStream(viewFile);
                    ByteArrayOutputStream unebaos = new ByteArrayOutputStream();
                    byte[] bytes2 = new byte[13312];
                    int unelength = 0;
                    while (true) {
                        int n;
                        int it = n = fis.read(bytes2);
                        boolean bl = false;
                        unelength = it;
                        if (n == -1) break;
                        unebaos.write(bytes2, 0, unelength);
                    }
                    String pageContent = unebaos.toString(StandardCharsets.UTF_8.name());
                    if (design != null) {
                        void $this$toTypedArray$iv;
                        String namespace;
                        String string9;
                        String designPath = webPath.toFile().getAbsolutePath() + File.separator + design;
                        File designFile = new File(designPath);
                        if (!designFile.exists()) {
                            try {
                                String message = "design " + designPath + " cannot be found.";
                                httpExchange.sendResponseHeaders(200, message.length());
                                String string10 = message;
                                byte[] byArray = string10.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                outputStream.write(byArray);
                                outputStream.flush();
                                outputStream.close();
                                return;
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        InputStream dis = new FileInputStream(designFile);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int deuxlength = 0;
                        while (true) {
                            int n;
                            int it = n = dis.read(bytes2);
                            boolean bl = false;
                            deuxlength = it;
                            if (n == -1) break;
                            baos.write(bytes2, 0, deuxlength);
                        }
                        String designContent2 = baos.toString(StandardCharsets.UTF_8.name());
                        Intrinsics.checkNotNullExpressionValue((Object)designContent2, (String)"designContent");
                        String[] stringArray = new String[]{"\\."};
                        Collection $this$toTypedArray$iv2 = StringsKt.split$default((CharSequence)designContent2, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$toTypedArray22 = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv2;
                        String[] stringArray2 = thisCollection$iv.toArray(new String[0]);
                        if (stringArray2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] bl = stringArray2;
                        List<String> entries = Arrays.asList(Arrays.copyOf(bl, bl.length));
                        Object object = this.cache;
                        if (object != null && (object = ((PLSAR.Cache)object).getExperienceProcessor()) != null) {
                            Intrinsics.checkNotNullExpressionValue(entries, (String)"entries");
                            string9 = ((ExperienceProcessor)object).setNamespace(entries);
                        } else {
                            string9 = namespace = null;
                        }
                        if (!StringsKt.contains$default((CharSequence)designContent2, (CharSequence)('<' + namespace + ":content/>"), (boolean)false, (int)2, null)) {
                            try {
                                String message = "template file is missing <" + namespace + ":content/>";
                                httpExchange.sendResponseHeaders(200, message.length());
                                String $i$f$toTypedArray22 = message;
                                byte[] byArray = $i$f$toTypedArray22.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                outputStream.write(byArray);
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        Object $i$f$toTypedArray22 = designContent2;
                        thisCollection$iv = new Regex('<' + namespace + ":content/>");
                        int n = 0;
                        $i$f$toTypedArray22 = thisCollection$iv.split((CharSequence)$i$f$toTypedArray22, n);
                        boolean $i$f$toTypedArray3 = false;
                        void thisCollection$iv2 = $this$toTypedArray$iv;
                        String[] stringArray3 = thisCollection$iv2.toArray(new String[0]);
                        if (stringArray3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] bits = stringArray3;
                        String header = bits[0];
                        String bottom = bits[1];
                        header = header + pageContent;
                        String completePage = header + bottom;
                        String string11 = title;
                        Intrinsics.checkNotNull((Object)string11);
                        completePage = StringsKt.replace$default((String)completePage, (String)"${title}", (String)string11, (boolean)false, (int)4, null);
                        if (keywords != null) {
                            completePage = StringsKt.replace$default((String)completePage, (String)"${keywords}", (String)keywords, (boolean)false, (int)4, null);
                        }
                        if (description != null) {
                            completePage = StringsKt.replace$default((String)completePage, (String)"${description}", (String)description, (boolean)false, (int)4, null);
                        }
                        String designOutput = "";
                        try {
                            PLSAR.Cache cache2 = this.cache;
                            ExperienceProcessor uxProcessor = cache2 != null ? cache2.getExperienceProcessor() : null;
                            PLSAR.Cache cache3 = this.cache;
                            Map<String, Fragment> fragments = cache3 != null ? cache3.getFragments() : null;
                            ExperienceProcessor experienceProcessor = uxProcessor;
                            Intrinsics.checkNotNull((Object)experienceProcessor);
                            designOutput = experienceProcessor.process(fragments, completePage, httpResponse, httpRequest, httpExchange);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                String message = "Please check your html template file. " + ex.getMessage();
                                httpExchange.sendResponseHeaders(200, message.length());
                                String string12 = message;
                                byte[] byArray = string12.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                outputStream.write(byArray);
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        Charset charset = Charset.forName("utf-8");
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                        byte[] byArray = designOutput.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                        byte[] bs = byArray;
                        httpExchange.sendResponseHeaders(200, bs.length);
                        outputStream.write(bs);
                    } else {
                        String pageOutput = null;
                        try {
                            PLSAR.Cache cache4 = this.cache;
                            ExperienceProcessor uxProcessor = cache4 != null ? cache4.getExperienceProcessor() : null;
                            PLSAR.Cache cache5 = this.cache;
                            Map<String, Fragment> fragments = cache5 != null ? cache5.getFragments() : null;
                            ExperienceProcessor experienceProcessor = uxProcessor;
                            Intrinsics.checkNotNull((Object)experienceProcessor);
                            Intrinsics.checkNotNullExpressionValue((Object)pageContent, (String)"pageContent");
                            pageOutput = experienceProcessor.process(fragments, pageContent, httpResponse, httpRequest, httpExchange);
                            if (!StringsKt.startsWith$default((String)pageOutput, (String)"<html>", (boolean)false, (int)2, null)) {
                                pageOutput = "<html>" + pageOutput;
                                pageOutput = pageOutput + "</html>";
                            }
                            httpExchange.sendResponseHeaders(200, pageOutput.length());
                            String baos = pageOutput;
                            byte[] byArray = baos.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                            outputStream.write(byArray);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                String message = "Please check your html template file. " + ex.getMessage();
                                httpExchange.sendResponseHeaders(200, message.length());
                                String baos = message;
                                byte[] byArray = baos.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                outputStream.write(byArray);
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else {
                    if (StringsKt.startsWith$default((String)methodResponse, (String)"/", (boolean)false, (int)2, null)) {
                        webPath = methodResponse;
                        Regex htmlPath = new Regex("/");
                        String viewFile = "";
                        methodResponse = htmlPath.replaceFirst((CharSequence)webPath, viewFile);
                    }
                    String pagePath = "/webapp/" + methodResponse;
                    InputStream pageInput = this.getClass().getResourceAsStream(pagePath);
                    ByteArrayOutputStream unebaos = new ByteArrayOutputStream();
                    byte[] bytes = new byte[13312];
                    int unelength = 0;
                    while (true) {
                        int bytes2;
                        int it = bytes2 = pageInput.read(bytes);
                        boolean bl = false;
                        unelength = it;
                        if (bytes2 == -1) break;
                        unebaos.write(bytes, 0, unelength);
                    }
                    String pageContent = unebaos.toString(StandardCharsets.UTF_8.name());
                    if (design != null) {
                        void $this$toTypedArray$iv;
                        String namespace;
                        String string13;
                        String designPath = "/webapp/" + design;
                        InputStream designInput = this.getClass().getResourceAsStream(designPath);
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        int length = 0;
                        while (true) {
                            int e;
                            int it = e = designInput.read(bytes);
                            boolean bl = false;
                            length = it;
                            if (e == -1) break;
                            baos.write(bytes, 0, length);
                        }
                        String designContent = baos.toString(StandardCharsets.UTF_8.name());
                        Intrinsics.checkNotNullExpressionValue((Object)designContent, (String)"designContent");
                        String[] designContent2 = new String[]{"\\."};
                        Collection $this$toTypedArray$iv3 = StringsKt.split$default((CharSequence)designContent, (String[])designContent2, (boolean)false, (int)0, (int)6, null);
                        boolean $i$f$toTypedArray42 = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv3;
                        String[] stringArray = thisCollection$iv.toArray(new String[0]);
                        if (stringArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] bl = stringArray;
                        List<String> entries = Arrays.asList(Arrays.copyOf(bl, bl.length));
                        Object object = this.cache;
                        if (object != null && (object = ((PLSAR.Cache)object).getExperienceProcessor()) != null) {
                            Intrinsics.checkNotNullExpressionValue(entries, (String)"entries");
                            string13 = ((ExperienceProcessor)object).setNamespace(entries);
                        } else {
                            string13 = namespace = null;
                        }
                        if (!StringsKt.contains$default((CharSequence)designContent, (CharSequence)('<' + namespace + ":content/>"), (boolean)false, (int)2, null)) {
                            try {
                                String message = "your template file is missing <" + namespace + ":content/>";
                                httpExchange.sendResponseHeaders(200, message.length());
                                String $i$f$toTypedArray42 = message;
                                byte[] byArray = $i$f$toTypedArray42.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                outputStream.write(byArray);
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        Object $i$f$toTypedArray42 = designContent;
                        thisCollection$iv = new Regex('<' + namespace + ":content/>");
                        int bits = 0;
                        $i$f$toTypedArray42 = thisCollection$iv.split((CharSequence)$i$f$toTypedArray42, bits);
                        boolean $i$f$toTypedArray5 = false;
                        void thisCollection$iv3 = $this$toTypedArray$iv;
                        String[] stringArray4 = thisCollection$iv3.toArray(new String[0]);
                        if (stringArray4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                        }
                        String[] bits2 = stringArray4;
                        String header = bits2[0];
                        String bottom = bits2[1];
                        header = header + pageContent;
                        String completePage = header + bottom;
                        String string14 = title;
                        Intrinsics.checkNotNull((Object)string14);
                        completePage = StringsKt.replace$default((String)completePage, (String)"${title}", (String)string14, (boolean)false, (int)4, null);
                        if (keywords != null) {
                            completePage = StringsKt.replace$default((String)completePage, (String)"${keywords}", (String)keywords, (boolean)false, (int)4, null);
                        }
                        if (description != null) {
                            completePage = StringsKt.replace$default((String)completePage, (String)"${description}", (String)description, (boolean)false, (int)4, null);
                        }
                        String designOutput = "";
                        try {
                            PLSAR.Cache cache6 = this.cache;
                            ExperienceProcessor uxProcessor = cache6 != null ? cache6.getExperienceProcessor() : null;
                            PLSAR.Cache cache7 = this.cache;
                            Map<String, Fragment> fragments = cache7 != null ? cache7.getFragments() : null;
                            ExperienceProcessor experienceProcessor = uxProcessor;
                            Intrinsics.checkNotNull((Object)experienceProcessor);
                            designOutput = experienceProcessor.process(fragments, completePage, httpResponse, httpRequest, httpExchange);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                String message = "Please check your html template file. " + ex.getMessage();
                                httpExchange.sendResponseHeaders(200, message.length());
                                String string15 = message;
                                byte[] byArray = string15.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                outputStream.write(byArray);
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        Charset charset = Charset.forName("utf-8");
                        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(charsetName)");
                        byte[] byArray = designOutput.getBytes(charset);
                        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                        byte[] bs = byArray;
                        httpExchange.sendResponseHeaders(200, bs.length);
                        outputStream.write(bs);
                    } else {
                        String pageOutput = null;
                        try {
                            PLSAR.Cache cache8 = this.cache;
                            ExperienceProcessor uxProcessor = cache8 != null ? cache8.getExperienceProcessor() : null;
                            PLSAR.Cache cache9 = this.cache;
                            Map<String, Fragment> fragments = cache9 != null ? cache9.getFragments() : null;
                            ExperienceProcessor experienceProcessor = uxProcessor;
                            Intrinsics.checkNotNull((Object)experienceProcessor);
                            Intrinsics.checkNotNullExpressionValue((Object)pageContent, (String)"pageContent");
                            pageOutput = experienceProcessor.process(fragments, pageContent, httpResponse, httpRequest, httpExchange);
                            if (!StringsKt.startsWith$default((String)pageOutput, (String)"<html>", (boolean)false, (int)2, null)) {
                                pageOutput = "<html>" + pageOutput;
                                pageOutput = pageOutput + "</html>";
                            }
                            httpExchange.sendResponseHeaders(200, pageOutput.length());
                            String string16 = pageOutput;
                            byte[] byArray = string16.getBytes(Charsets.UTF_8);
                            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                            outputStream.write(byArray);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            try {
                                String message = "Please check your html template file. " + ex.getMessage();
                                httpExchange.sendResponseHeaders(200, message.length());
                                String string17 = message;
                                byte[] byArray = string17.getBytes(Charsets.UTF_8);
                                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                                outputStream.write(byArray);
                                outputStream.flush();
                                outputStream.close();
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                }
            }
            outputStream.flush();
            outputStream.close();
        }
        catch (ClassCastException ccex) {
            ccex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            try {
                String message = "not good. let us know.";
                httpExchange.sendResponseHeaders(200, message.length());
                String string = message;
                byte[] byArray = string.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
                outputStream.write(byArray);
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @NotNull
    protected final String getRedirect(@NotNull String uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        CharSequence charSequence = uri;
        Regex regex = new Regex("]");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] redirectBits = stringArray;
        return redirectBits.length > 1 ? redirectBits[1] : "";
    }

    private final Object[] getEndpointParameters(String requestUri, HttpRequest httpRequest, HttpResponse httpResponse, EndpointMapping endpointMapping, HttpExchange httpExchange) {
        List<EndpointPosition> endpointValues = this.getEndpointValues(requestUri, endpointMapping);
        List params = new ArrayList();
        ArrayList<String> typeNames = endpointMapping.getTypeNames();
        int idx = 0;
        ArrayList<String> arrayList = typeNames;
        Intrinsics.checkNotNull(arrayList);
        int n = arrayList.size();
        for (int z = 0; z < n; ++z) {
            String type = typeNames.get(z);
            if (Intrinsics.areEqual((Object)type, (Object)"com.sun.net.httpserver.HttpExchange")) {
                params.add(httpExchange);
            }
            if (Intrinsics.areEqual((Object)type, (Object)"plsar.model.web.HttpRequest")) {
                HttpRequest httpRequest2 = httpRequest;
                Intrinsics.checkNotNull((Object)httpRequest2);
                params.add(httpRequest2);
            }
            if (Intrinsics.areEqual((Object)type, (Object)"plsar.model.web.HttpResponse")) {
                params.add(httpResponse);
            }
            if (Intrinsics.areEqual((Object)type, (Object)"int") || Intrinsics.areEqual((Object)type, (Object)"java.lang.Integer")) {
                Integer n2 = Integer.valueOf(endpointValues.get(idx).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"valueOf(endpointValues[idx].value)");
                params.add(n2);
                ++idx;
            }
            if (Intrinsics.areEqual((Object)type, (Object)"long") || Intrinsics.areEqual((Object)type, (Object)"java.lang.Long")) {
                Long l = Long.valueOf(endpointValues.get(idx).getValue());
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"valueOf(endpointValues[idx].value)");
                params.add(l);
                ++idx;
            }
            if (!Intrinsics.areEqual((Object)type, (Object)"java.lang.String")) continue;
            params.add(endpointValues.get(idx).getValue());
            ++idx;
        }
        Collection $this$toTypedArray$iv = params;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return objectArray;
    }

    @NotNull
    protected final List<EndpointPosition> getEndpointValues(@Nullable String uri, @NotNull EndpointMapping mapping) {
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        List<String> pathParts = this.getPathParts(uri);
        List<String> regexParts = this.getRegexParts(mapping);
        List httpValues = new ArrayList();
        List<String> list = regexParts;
        Intrinsics.checkNotNull(list);
        int n = list.size();
        for (int n2 = 0; n2 < n; ++n2) {
            String regex = regexParts.get(n2);
            if (!StringsKt.contains$default((CharSequence)regex, (CharSequence)"A-Za-z0-9", (boolean)false, (int)2, null)) continue;
            httpValues.add(new EndpointPosition(n2, pathParts.get(n2)));
        }
        return httpValues;
    }

    @NotNull
    protected final List<String> getPathParts(@Nullable String uri) {
        String string = uri;
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        Regex regex = new Regex("/");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray2 = stringArray;
        List<String> list = Arrays.asList(Arrays.copyOf(stringArray2, stringArray2.length));
        Intrinsics.checkNotNullExpressionValue(list, (String)"asList(*uri!!.split(\"/\".toRegex()).toTypedArray())");
        return list;
    }

    @Nullable
    protected final List<String> getRegexParts(@NotNull EndpointMapping mapping) {
        List list;
        Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
        String string = mapping.getRegexedPath();
        if (string != null) {
            CharSequence charSequence = string;
            Regex regex = new Regex("/");
            int n = 0;
            list = regex.split(charSequence, n);
        } else {
            list = null;
        }
        return list;
    }

    @Nullable
    protected final EndpointMapping getHttpMapping(@NotNull String verb, @Nullable String uri) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)verb, (String)"verb");
        Object object2 = this.cache;
        if (object2 != null && (object2 = ((PLSAR.Cache)object2).getEndpointMappings()) != null && (object2 = ((EndpointMappings)object2).getMappings()) != null) {
            Map<String, EndpointMapping> $this$forEach$iv = object2;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, EndpointMapping>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, EndpointMapping> element$iv;
                Map.Entry<String, EndpointMapping> entry = element$iv = iterator.next();
                boolean bl = false;
                EndpointMapping mapping = entry.getValue();
                String mappingUri = mapping.getPath();
                String string = mapping.getPath();
                Boolean bl2 = string != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string, (String)"/", (boolean)false, (int)2, null)) : null;
                Intrinsics.checkNotNull(bl2);
                if (!bl2.booleanValue()) {
                    mappingUri = '/' + mappingUri;
                }
                if (!Intrinsics.areEqual((Object)mappingUri, (Object)uri)) continue;
                return mapping;
            }
        }
        Map<String, EndpointMapping> map = (object = this.cache) != null && (object = ((PLSAR.Cache)object).getEndpointMappings()) != null ? ((EndpointMappings)object).getMappings() : null;
        Intrinsics.checkNotNull(map);
        Iterator<Map.Entry<String, EndpointMapping>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            EndpointMapping mapping = iterator.next().getValue();
            String string2 = mapping.getRegexedPath();
            Intrinsics.checkNotNull((Object)string2);
            Matcher matcher = Pattern.compile(string2).matcher(String.valueOf(uri));
            String mappingUri = mapping.getPath();
            String string3 = mapping.getPath();
            Boolean bl = string3 != null ? Boolean.valueOf(StringsKt.startsWith$default((String)string3, (String)"/", (boolean)false, (int)2, null)) : null;
            Intrinsics.checkNotNull(bl);
            if (!bl.booleanValue()) {
                mappingUri = '/' + mappingUri;
            }
            if (!matcher.matches()) continue;
            String string4 = mapping.getVerb();
            if (string4 != null) {
                String string5 = string4.toLowerCase(Locale.ROOT);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            } else {
                string = null;
            }
            if (!Intrinsics.areEqual((Object)string, (Object)verb) || !this.variablesMatchUp(uri, mapping) || !this.lengthMatches(uri, mappingUri)) continue;
            return mapping;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean lengthMatches(@Nullable String uri, @Nullable String mappingUri) {
        void $this$toTypedArray$iv;
        void $this$toTypedArray$iv2;
        String string = uri;
        Intrinsics.checkNotNull((Object)string);
        Object object = string;
        Regex regex = new Regex("/");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray22 = false;
        Regex thisCollection$iv = $this$toTypedArray$iv2;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] uriBits = stringArray;
        String string2 = mappingUri;
        Intrinsics.checkNotNull((Object)string2);
        Object $i$f$toTypedArray22 = string2;
        thisCollection$iv = new Regex("/");
        int n2 = 0;
        $i$f$toTypedArray22 = thisCollection$iv.split((CharSequence)$i$f$toTypedArray22, n2);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv2 = $this$toTypedArray$iv;
        String[] stringArray2 = thisCollection$iv2.toArray(new String[0]);
        if (stringArray2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] mappingBits = stringArray2;
        return uriBits.length == mappingBits.length;
    }

    /*
     * WARNING - void declaration
     */
    protected final boolean variablesMatchUp(@Nullable String uri, @NotNull EndpointMapping endpointMapping) {
        UrlBitFeatures urlBitFeatures;
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)endpointMapping, (String)"endpointMapping");
        String string = uri;
        Intrinsics.checkNotNull((Object)string);
        Object object = string;
        Regex regex = new Regex("/");
        int n = 0;
        object = regex.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] stringArray2 = stringArray;
        List<String> bits = Arrays.asList(Arrays.copyOf(stringArray2, stringArray2.length));
        UrlBitFeatures urlBitFeatures2 = urlBitFeatures = endpointMapping.getUrlBitFeatures();
        List<UrlBit> urlBits = urlBitFeatures2 != null ? urlBitFeatures2.getUrlBits() : null;
        Method method = endpointMapping.getMethod();
        Class<?>[] typeParameters = method != null ? method.getParameterTypes() : null;
        List<String> parameterTypes = this.getParameterTypes(typeParameters);
        int idx = 0;
        List<UrlBit> list = urlBits;
        Intrinsics.checkNotNull(list);
        int n2 = list.size();
        for (int q = 0; q < n2; ++q) {
            UrlBit urlBit = urlBits.get(q);
            if (!Intrinsics.areEqual((Object)urlBit.isVariable(), (Object)true)) continue;
            try {
                String methodType = parameterTypes.get(idx);
                String bit = bits.get(q);
                if (!Intrinsics.areEqual((Object)bit, (Object)"")) {
                    if (Intrinsics.areEqual((Object)methodType, (Object)"java.lang.Integer")) {
                        Intrinsics.checkNotNullExpressionValue((Object)bit, (String)"bit");
                        Integer.parseInt(bit);
                    }
                    if (Intrinsics.areEqual((Object)methodType, (Object)"java.lang.Long")) {
                        Intrinsics.checkNotNullExpressionValue((Object)bit, (String)"bit");
                        Long.parseLong(bit);
                    }
                }
                ++idx;
                continue;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    @NotNull
    public final List<String> getParameterTypes(@Nullable Class<?>[] clsParamaters) {
        List parameterTypes = new ArrayList();
        Intrinsics.checkNotNull(clsParamaters);
        for (Class<?> cls : clsParamaters) {
            String type = cls.getTypeName();
            Intrinsics.checkNotNullExpressionValue((Object)type, (String)"type");
            if (StringsKt.contains$default((CharSequence)type, (CharSequence)"HttpExchange", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)type, (CharSequence)"HttpRequest", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)type, (CharSequence)"HttpResponse", (boolean)false, (int)2, null)) continue;
            parameterTypes.add(type);
        }
        return parameterTypes;
    }

    @NotNull
    protected final HttpResponse getHttpResponse(@NotNull HttpExchange exchange) {
        Intrinsics.checkNotNullParameter((Object)exchange, (String)"exchange");
        HttpResponse httpResponse = new HttpResponse();
        if (exchange.getAttribute("message") != null) {
            httpResponse.set("message", exchange.getAttribute("message"));
            exchange.setAttribute("message", "");
        }
        return httpResponse;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lplsar/web/HttpTransmission$Companion;", "", "()V", "REDIRECT", "", "plsar-framework"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

