/*
 * Decompiled with CFR 0.152.
 */
package plsar.processor;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.annotate.Events;
import plsar.model.InstanceDetails;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010&\u001a\u00020\u000f2\b\u0010'\u001a\u0004\u0018\u00010\u0014H\u0004J\"\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00142\b\u0010,\u001a\u0004\u0018\u00010\u0014H\u0002J\u0018\u0010-\u001a\u0004\u0018\u00010\u00012\f\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/H\u0004J\u0016\u00100\u001a\u00020\u001b2\f\u0010.\u001a\b\u0012\u0002\b\u0003\u0018\u00010/H\u0004J\u0010\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u0014H\u0004J \u00101\u001a\u00020\u00142\u0006\u00103\u001a\u00020\u00142\u0006\u00104\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u0014H\u0004J\u0010\u00105\u001a\u0002062\u0006\u00107\u001a\u00020\u0014H\u0004J\u0010\u00108\u001a\u0002062\u0006\u00107\u001a\u00020\u0014H\u0004J\u0010\u00109\u001a\u0002062\u0006\u00107\u001a\u00020\u0014H\u0004J\u0006\u0010:\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140;H\u0002R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000f8DX\u0084\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R \u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R&\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u001b0\u001aX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006<"}, d2={"Lplsar/processor/InstanceProcessor;", "", "cache", "Lplsar/PLSAR$Cache;", "(Lplsar/PLSAR$Cache;)V", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "classInstanceLoader", "Ljava/lang/ClassLoader;", "getClassInstanceLoader", "()Ljava/lang/ClassLoader;", "setClassInstanceLoader", "(Ljava/lang/ClassLoader;)V", "classesJar", "", "getClassesJar", "()Lkotlin/Unit;", "jarDeps", "Ljava/util/ArrayList;", "", "getJarDeps", "()Ljava/util/ArrayList;", "setJarDeps", "(Ljava/util/ArrayList;)V", "objects", "", "Lplsar/model/InstanceDetails;", "getObjects", "()Ljava/util/Map;", "setObjects", "(Ljava/util/Map;)V", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "getClasses", "uri", "getLastIndxOf", "", "nth", "ch", "string", "getObject", "cls", "Ljava/lang/Class;", "getObjectDetails", "getPath", "path", "name", "key", "isDep", "", "jarEntry", "isDirt", "isWithinRunningProgram", "run", "", "plsar-framework"})
public final class InstanceProcessor {
    @Nullable
    private PLSAR.Cache cache;
    @NotNull
    private PLSAR.Support support;
    @NotNull
    private ClassLoader classInstanceLoader;
    public ArrayList<String> jarDeps;
    @NotNull
    private Map<String, InstanceDetails> objects;

    public InstanceProcessor(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
        this.support = new PLSAR.Support();
        this.objects = new HashMap();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Intrinsics.checkNotNullExpressionValue((Object)classLoader, (String)"currentThread().contextClassLoader");
        this.classInstanceLoader = classLoader;
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    @NotNull
    public final PLSAR.Support getSupport() {
        return this.support;
    }

    public final void setSupport(@NotNull PLSAR.Support support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
        this.support = support;
    }

    @NotNull
    public final ClassLoader getClassInstanceLoader() {
        return this.classInstanceLoader;
    }

    public final void setClassInstanceLoader(@NotNull ClassLoader classLoader) {
        Intrinsics.checkNotNullParameter((Object)classLoader, (String)"<set-?>");
        this.classInstanceLoader = classLoader;
    }

    @NotNull
    public final ArrayList<String> getJarDeps() {
        ArrayList<String> arrayList = this.jarDeps;
        if (arrayList != null) {
            return arrayList;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"jarDeps");
        return null;
    }

    public final void setJarDeps(@NotNull ArrayList<String> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.jarDeps = arrayList;
    }

    @NotNull
    public final Map<String, InstanceDetails> getObjects() {
        return this.objects;
    }

    public final void setObjects(@NotNull Map<String, InstanceDetails> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.objects = map;
    }

    @NotNull
    public final InstanceProcessor run() {
        if (this.support.isJar()) {
            this.setJarDeps();
            this.getClassesJar();
        } else {
            String uri = null;
            try {
                uri = this.support.getClassesUri();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.getClasses(uri);
        }
        return this;
    }

    private final List<String> setJarDeps() {
        this.setJarDeps(new ArrayList<String>());
        PLSAR.Support support = this.support;
        Enumeration<JarEntry> entries = support != null ? support.getJarEntries() : null;
        do {
            String dep;
            Enumeration<JarEntry> enumeration = entries;
            Intrinsics.checkNotNull(enumeration);
            JarEntry jarEntry = enumeration.nextElement();
            String string = jarEntry.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarEntry.toString()");
            String path = this.getPath(string);
            if (!StringsKt.contains$default((CharSequence)path, (CharSequence)"META-INF.maven.", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)path.substring(14), (String)"this as java.lang.String).substring(startIndex)");
            ArrayList<String> arrayList = this.getJarDeps();
            if (arrayList == null) continue;
            arrayList.add(dep);
        } while (entries.hasMoreElements());
        return this.getJarDeps();
    }

    protected final boolean isDep(@NotNull String jarEntry) {
        Intrinsics.checkNotNullParameter((Object)jarEntry, (String)"jarEntry");
        String jarPath = this.getPath(jarEntry);
        ArrayList<String> arrayList = this.getJarDeps();
        Intrinsics.checkNotNull(arrayList);
        for (String dep : arrayList) {
            CharSequence charSequence = jarPath;
            Intrinsics.checkNotNullExpressionValue((Object)dep, (String)"dep");
            if (!StringsKt.contains$default((CharSequence)charSequence, (CharSequence)dep, (boolean)false, (int)2, null)) continue;
            return true;
        }
        return false;
    }

    private final int getLastIndxOf(int nth, String ch, String string) {
        int n;
        int nth2 = nth;
        if (nth2 <= 0) {
            String string2 = string;
            Intrinsics.checkNotNull((Object)string2);
            n = string2.length();
        } else {
            String string3 = string;
            Intrinsics.checkNotNull((Object)string3);
            String string4 = string3.substring(0, StringsKt.lastIndexOf$default((CharSequence)string, (String)ch, (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            n = this.getLastIndxOf(--nth2, ch, string4);
        }
        return n;
    }

    protected final boolean isWithinRunningProgram(@NotNull String jarEntry) {
        String main;
        Intrinsics.checkNotNullParameter((Object)jarEntry, (String)"jarEntry");
        String string = main = this.support.getMain();
        Intrinsics.checkNotNull((Object)string);
        String string2 = string.substring(0, this.getLastIndxOf(1, ".", main) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String path = string2;
        String jarPath = this.getPath(jarEntry);
        return StringsKt.contains$default((CharSequence)jarPath, (CharSequence)path, (boolean)false, (int)2, null);
    }

    protected final boolean isDirt(@NotNull String jarEntry) {
        Intrinsics.checkNotNullParameter((Object)jarEntry, (String)"jarEntry");
        if (this.support.isJar() && !this.isWithinRunningProgram(jarEntry) && this.isDep(jarEntry)) {
            return true;
        }
        if (this.support.isJar() && !StringsKt.endsWith$default((String)jarEntry, (String)".class", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)jarEntry, (CharSequence)"org/h2", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)jarEntry, (CharSequence)"javax/servlet/http", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)jarEntry, (CharSequence)"package-info", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.startsWith$default((String)jarEntry, (String)"module-info", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)jarEntry, (CharSequence)"META-INF/", (boolean)false, (int)2, null)) {
            return true;
        }
        if (StringsKt.contains$default((CharSequence)jarEntry, (CharSequence)"$", (boolean)false, (int)2, null)) {
            return true;
        }
        return StringsKt.endsWith$default((String)jarEntry, (String)"Exception", (boolean)false, (int)2, null);
    }

    @NotNull
    protected final Unit getClassesJar() {
        try {
            URL jarUriTres = this.classInstanceLoader.getResource("plsar/");
            String string = jarUriTres.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jarUriTres.path");
            String string2 = string;
            int n = 5;
            String string3 = jarUriTres.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"jarUriTres.path");
            int n2 = StringsKt.indexOf$default((CharSequence)string3, (String)"!", (int)0, (boolean)false, (int)6, null);
            String string4 = string2.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String jarPath = string4;
            JarFile file = new JarFile(jarPath);
            Enumeration<JarEntry> enumeration = file.entries();
            Intrinsics.checkNotNullExpressionValue(enumeration, (String)"file.entries()");
            Enumeration<JarEntry> jarFile = enumeration;
            while (jarFile.hasMoreElements()) {
                JarEntry jarEntry;
                if (jarFile.nextElement() == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.util.jar.JarEntry");
                }
                if (jarEntry.isDirectory()) continue;
                String string5 = jarEntry.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"jarEntry.toString()");
                if (this.isDirt(string5)) continue;
                String string6 = jarEntry.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"jarEntry.toString()");
                String path = this.getPath(string6);
                Class<?> cls = this.classInstanceLoader.loadClass(path);
                if (cls.isAnnotation() || cls.isInterface() || cls.getName() == this.getClass().getName()) continue;
                if (cls.isAnnotationPresent(Events.class)) {
                    PLSAR.Cache cache = this.cache;
                    if (cache != null) {
                        cache.setEvents(this.getObject(cls));
                    }
                }
                InstanceDetails instanceDetails = this.getObjectDetails(cls);
                Object object = this.cache;
                if (object == null || (object = ((PLSAR.Cache)object).getObjects()) == null) continue;
                String string7 = instanceDetails.getName();
                Intrinsics.checkNotNull((Object)string7);
                object.put(string7, instanceDetails);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return Unit.INSTANCE;
    }

    protected final void getClasses(@Nullable String uri) {
        File pathFile = new File(uri);
        File[] files = pathFile.listFiles();
        Intrinsics.checkNotNullExpressionValue((Object)files, (String)"files");
        for (File file : files) {
            if (file.isDirectory()) {
                this.getClasses(file.getPath());
                continue;
            }
            try {
                String string = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                if (this.isDirt(string)) continue;
                String string2 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"file.path");
                if (!StringsKt.endsWith$default((String)string2, (String)".class", (boolean)false, (int)2, null)) {
                    String string3 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"file.path");
                    if (!StringsKt.endsWith$default((String)string3, (String)".kt", (boolean)false, (int)2, null)) continue;
                }
                String string4 = file.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"file.path");
                String path = this.getPath("kotlin", "kotlin", string4);
                String string5 = file.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"file.toString()");
                if (StringsKt.endsWith$default((String)string5, (String)".class", (boolean)false, (int)2, null)) {
                    String string6 = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"file.path");
                    path = this.getPath("class", "classes", string6);
                }
                Class<?> cls = null;
                try {
                    cls = this.classInstanceLoader.loadClass(path);
                }
                catch (Exception ex) {
                    cls = this.classInstanceLoader.loadClass(path + "Kt");
                }
                Class<?> clazz = cls;
                if (clazz != null ? clazz.isAnnotation() : false) continue;
                Class<?> clazz2 = cls;
                if (clazz2 != null ? clazz2.isInterface() : false) continue;
                Class<?> clazz3 = cls;
                if ((clazz3 != null ? clazz3.getName() : null) == this.getClass().getName()) continue;
                Class<?> clazz4 = cls;
                boolean bl = clazz4 != null ? clazz4.isAnnotationPresent(Events.class) : false;
                if (bl) {
                    PLSAR.Cache cache = this.cache;
                    if (cache != null) {
                        cache.setEvents(this.getObject(cls));
                    }
                }
                InstanceDetails instanceDetails = this.getObjectDetails(cls);
                Object object = this.cache;
                if (object == null || (object = ((PLSAR.Cache)object).getObjects()) == null) continue;
                String string7 = instanceDetails.getName();
                Intrinsics.checkNotNull((Object)string7);
                object.put(string7, instanceDetails);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    @NotNull
    protected final String getPath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String path2 = path;
        if (StringsKt.startsWith$default((String)path2, (String)"/", (boolean)false, (int)2, null)) {
            CharSequence charSequence = path2;
            Regex regex = new Regex("/");
            String string = "";
            path2 = regex.replaceFirst(charSequence, string);
        }
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)path2, (String)"\\", (String)".", (boolean)false, (int)4, null), (String)"/", (String)".", (boolean)false, (int)4, null), (String)".class", (String)"", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected final String getPath(@NotNull String name, @NotNull String key, @NotNull String path) {
        void $this$toTypedArray$iv;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String separator = System.getProperty("file.separator");
        String regex = key + '\\' + separator;
        Object object = path;
        Regex regex2 = new Regex(regex);
        int n = 0;
        object = regex2.split((CharSequence)object, n);
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        String[] pathParts = stringArray;
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)pathParts[1], (String)"\\", (String)".", (boolean)false, (int)4, null), (String)"/", (String)".", (boolean)false, (int)4, null), (String)".kt", (String)"", (boolean)false, (int)4, null);
    }

    @NotNull
    protected final InstanceDetails getObjectDetails(@Nullable Class<?> cls) throws IllegalAccessException, InvocationTargetException, InstantiationException {
        InstanceDetails instanceDetails = new InstanceDetails();
        instanceDetails.setInstanceClass(cls);
        Class<?> clazz = cls;
        instanceDetails.setName(this.support.getName(clazz != null ? clazz.getName() : null));
        Object instance = this.getObject(cls);
        instanceDetails.setInstance(instance);
        return instanceDetails;
    }

    @Nullable
    protected final Object getObject(@Nullable Class<?> cls) {
        Object instance = null;
        try {
            Constructor<?> constructor;
            GenericDeclaration genericDeclaration = cls;
            instance = genericDeclaration != null && (genericDeclaration = (constructor = ((Class)genericDeclaration).getConstructor(new Class[0]))) != null ? ((Constructor)genericDeclaration).newInstance(new Object[0]) : null;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return instance;
    }
}

