/*
 * Decompiled with CFR 0.152.
 */
package plsar.processor;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.annotate.Config;
import plsar.annotate.Element;
import plsar.annotate.HttpRouter;
import plsar.annotate.Inject;
import plsar.annotate.Property;
import plsar.annotate.Repo;
import plsar.annotate.Service;
import plsar.cargo.ElementStorage;
import plsar.model.InstanceDetails;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010&\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010&\u001a\u00020'2\u0016\u0010(\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0)H\u0004J\u0006\u0010*\u001a\u00020\u0000R*\u0010\u0005\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004R&\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR*\u0010\u001d\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\n\"\u0004\b\u001f\u0010\fR\u001a\u0010 \u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u001a\"\u0004\b\"\u0010\u001cR\u001a\u0010#\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001a\"\u0004\b%\u0010\u001c\u00a8\u0006+"}, d2={"Lplsar/processor/ElementProcessor;", "", "cache", "Lplsar/PLSAR$Cache;", "(Lplsar/PLSAR$Cache;)V", "annotatedInstances", "", "", "Lplsar/model/InstanceDetails;", "getAnnotatedInstances", "()Ljava/util/Map;", "setAnnotatedInstances", "(Ljava/util/Map;)V", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "configurations", "", "Ljava/lang/Class;", "getConfigurations", "()Ljava/util/List;", "setConfigurations", "(Ljava/util/List;)V", "elementCount", "", "getElementCount", "()I", "setElementCount", "(I)V", "httpInstances", "getHttpInstances", "setHttpInstances", "jdbcCount", "getJdbcCount", "setJdbcCount", "serviceCount", "getServiceCount", "setServiceCount", "buildAddElement", "", "entry", "", "run", "plsar-framework"})
public final class ElementProcessor {
    @Nullable
    private PLSAR.Cache cache;
    private int jdbcCount;
    private int serviceCount;
    private int elementCount;
    @NotNull
    private List<Class<?>> configurations;
    @NotNull
    private Map<String, InstanceDetails> httpInstances;
    @NotNull
    private Map<String, InstanceDetails> annotatedInstances;

    public ElementProcessor(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
        this.configurations = new ArrayList();
        this.httpInstances = new HashMap();
        this.annotatedInstances = new HashMap();
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    public final int getJdbcCount() {
        return this.jdbcCount;
    }

    public final void setJdbcCount(int n) {
        this.jdbcCount = n;
    }

    public final int getServiceCount() {
        return this.serviceCount;
    }

    public final void setServiceCount(int n) {
        this.serviceCount = n;
    }

    public final int getElementCount() {
        return this.elementCount;
    }

    public final void setElementCount(int n) {
        this.elementCount = n;
    }

    @NotNull
    public final List<Class<?>> getConfigurations() {
        return this.configurations;
    }

    public final void setConfigurations(@NotNull List<Class<?>> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.configurations = list;
    }

    @NotNull
    public final Map<String, InstanceDetails> getHttpInstances() {
        return this.httpInstances;
    }

    public final void setHttpInstances(@NotNull Map<String, InstanceDetails> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.httpInstances = map;
    }

    @NotNull
    public final Map<String, InstanceDetails> getAnnotatedInstances() {
        return this.annotatedInstances;
    }

    public final void setAnnotatedInstances(@NotNull Map<String, InstanceDetails> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.annotatedInstances = map;
    }

    @NotNull
    public final ElementProcessor run() {
        PLSAR.Cache cache = this.cache;
        Intrinsics.checkNotNull((Object)cache);
        Iterator<Map.Entry<String, InstanceDetails>> iterator = cache.getObjects().entrySet().iterator();
        while (iterator.hasNext()) {
            Class<?> cls2;
            InstanceDetails value = iterator.next().getValue();
            Class<?> clazz = cls2 = value.getInstanceClass();
            Intrinsics.checkNotNull(clazz);
            if (!clazz.isAnnotationPresent(Config.class)) continue;
            List<Class<?>> list = this.configurations;
            if (list == null) continue;
            list.add(cls2);
        }
        PLSAR.Cache cache2 = this.cache;
        Map<String, InstanceDetails> map = cache2 != null ? cache2.getObjects() : null;
        Intrinsics.checkNotNull(map);
        for (Map.Entry<String, InstanceDetails> entry : map.entrySet()) {
            Class<?> cls;
            Class<?> clazz = cls = entry.getValue().getInstanceClass();
            Intrinsics.checkNotNull(clazz);
            if (clazz.isAnnotationPresent(Element.class)) {
                this.buildAddElement(entry);
                int cls2 = this.elementCount;
                this.elementCount = cls2 + 1;
            }
            if (cls.isAnnotationPresent(Repo.class)) {
                this.buildAddElement(entry);
                int cls2 = this.jdbcCount;
                this.jdbcCount = cls2 + 1;
            }
            if (cls.isAnnotationPresent(Service.class)) {
                this.buildAddElement(entry);
                int cls2 = this.serviceCount;
                this.serviceCount = cls2 + 1;
            }
            if (cls.isAnnotationPresent(HttpRouter.class)) {
                this.httpInstances.put(entry.getKey(), entry.getValue());
            }
            Field[] fields = cls.getDeclaredFields();
            Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
            for (Field field : fields) {
                if (field.isAnnotationPresent(Inject.class)) {
                    this.annotatedInstances.put(entry.getKey(), entry.getValue());
                }
                if (!field.isAnnotationPresent(Property.class)) continue;
                this.annotatedInstances.put(entry.getKey(), entry.getValue());
            }
        }
        return this;
    }

    protected final void buildAddElement(@NotNull Map.Entry<String, InstanceDetails> entry) {
        Intrinsics.checkNotNullParameter(entry, (String)"entry");
        plsar.model.Element element = new plsar.model.Element();
        String key = entry.getKey();
        InstanceDetails instanceDetails = entry.getValue();
        Object instance = instanceDetails != null ? instanceDetails.getInstance() : null;
        element.setElement(instance);
        PLSAR.Cache cache = this.cache;
        ElementStorage elementStorage = cache != null ? cache.getElementStorage() : null;
        Intrinsics.checkNotNull((Object)elementStorage);
        elementStorage.getElements().put(key, element);
    }
}

