/*
 * Decompiled with CFR 0.152.
 */
package plsar.processor;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.annotate.Inject;
import plsar.annotate.Property;
import plsar.cargo.ElementStorage;
import plsar.cargo.PropertyStorage;
import plsar.model.Element;
import plsar.model.InstanceDetails;
import plsar.processor.ElementProcessor;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001c\u001a\u00020\u001dH\u0004J$\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u00012\b\u0010#\u001a\u0004\u0018\u00010\u0011H\u0004J\u0016\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0002\b\u0003\u0018\u00010'H\u0004J\b\u0010(\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020%H\u0002J\u0006\u0010+\u001a\u00020\u001fR\"\u0010\u0005\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u0004R*\u0010\u000f\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006,"}, d2={"Lplsar/processor/AnnotationProcessor;", "", "cache", "Lplsar/PLSAR$Cache;", "(Lplsar/PLSAR$Cache;)V", "annotations", "", "Lplsar/model/InstanceDetails;", "getAnnotations", "()Ljava/util/List;", "setAnnotations", "(Ljava/util/List;)V", "getCache", "()Lplsar/PLSAR$Cache;", "setCache", "processed", "", "", "getProcessed", "()Ljava/util/Map;", "setProcessed", "(Ljava/util/Map;)V", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "allAnnotationsProcessed", "", "attachValue", "", "field", "Ljava/lang/reflect/Field;", "object", "stringValue", "getAnnotatedFieldsCount", "", "clazz", "Ljava/lang/Class;", "map", "processAnnotations", "idx", "run", "plsar-framework"})
public final class AnnotationProcessor {
    @Nullable
    private PLSAR.Cache cache;
    @NotNull
    private PLSAR.Support support;
    @NotNull
    private Map<String, InstanceDetails> processed;
    @NotNull
    private List<InstanceDetails> annotations;

    public AnnotationProcessor(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
        this.support = new PLSAR.Support();
        this.processed = new HashMap();
        this.annotations = new ArrayList();
        this.map();
    }

    @Nullable
    public final PLSAR.Cache getCache() {
        return this.cache;
    }

    public final void setCache(@Nullable PLSAR.Cache cache) {
        this.cache = cache;
    }

    @NotNull
    public final PLSAR.Support getSupport() {
        return this.support;
    }

    public final void setSupport(@NotNull PLSAR.Support support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
        this.support = support;
    }

    @NotNull
    public final Map<String, InstanceDetails> getProcessed() {
        return this.processed;
    }

    public final void setProcessed(@NotNull Map<String, InstanceDetails> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.processed = map;
    }

    @NotNull
    public final List<InstanceDetails> getAnnotations() {
        return this.annotations;
    }

    public final void setAnnotations(@NotNull List<InstanceDetails> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.annotations = list;
    }

    public final void run() throws Exception {
        if (!this.allAnnotationsProcessed()) {
            this.processAnnotations(0);
        }
    }

    private final void processAnnotations(int idx) throws Exception {
        int idx2 = idx;
        if (idx2 > this.annotations.size()) {
            idx2 = 0;
        }
        int n = this.annotations.size();
        for (int z = idx2; z < n; ++z) {
            InstanceDetails instanceDetails;
            InstanceDetails instanceDetails2 = instanceDetails = this.annotations.get(z);
            int fieldsCount = this.getAnnotatedFieldsCount(instanceDetails2 != null ? instanceDetails2.getInstanceClass() : null);
            int processedFieldsCount = 0;
            InstanceDetails instanceDetails3 = instanceDetails;
            Object object = instanceDetails3 != null ? instanceDetails3.getInstance() : null;
            Object object2 = instanceDetails;
            Field[] fields = object2 != null && (object2 = ((InstanceDetails)object2).getInstanceClass()) != null ? ((Class)object2).getDeclaredFields() : null;
            Intrinsics.checkNotNull((Object)fields);
            for (Field field : fields) {
                if (field.isAnnotationPresent(Inject.class)) {
                    String fieldKey;
                    String string = field.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"field.name");
                    Intrinsics.checkNotNullExpressionValue((Object)string.toLowerCase(Locale.ROOT), (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
                    Object object3 = this.cache;
                    boolean bl = object3 != null && (object3 = ((PLSAR.Cache)object3).getElementStorage()) != null && (object3 = ((ElementStorage)object3).getElements()) != null ? object3.containsKey(fieldKey) : false;
                    if (bl) {
                        Object object4 = this.cache;
                        Object element = object4 != null && (object4 = ((PLSAR.Cache)object4).getElementStorage()) != null && (object4 = ((ElementStorage)object4).getElements()) != null && (object4 = object4.get(fieldKey)) != null ? ((Element)object4).getElement() : null;
                        field.setAccessible(true);
                        field.set(object, element);
                        ++processedFieldsCount;
                    } else {
                        this.processAnnotations(z + 1);
                    }
                }
                if (!field.isAnnotationPresent(Property.class)) continue;
                Property annotation = field.getAnnotation(Property.class);
                String key = annotation.value();
                Object object5 = this.cache;
                boolean bl = object5 != null && (object5 = ((PLSAR.Cache)object5).getPropertyStorage()) != null && (object5 = ((PropertyStorage)object5).getProperties()) != null ? object5.containsKey(key) : false;
                if (bl) {
                    field.setAccessible(true);
                    Object object6 = this.cache;
                    Map<String, String> map = object6 != null && (object6 = ((PLSAR.Cache)object6).getPropertyStorage()) != null ? ((PropertyStorage)object6).getProperties() : null;
                    Intrinsics.checkNotNull(map);
                    String value = map.get(key);
                    Intrinsics.checkNotNullExpressionValue((Object)field, (String)"field");
                    this.attachValue(field, object, value);
                    ++processedFieldsCount;
                    continue;
                }
                this.processAnnotations(z + 1);
                StringBuilder stringBuilder = new StringBuilder().append(field.getName()).append(" is missing on ");
                Object object7 = object;
                Intrinsics.checkNotNull((Object)object7);
                throw new Exception(stringBuilder.append(object7.getClass().getName()).toString());
            }
            if (fieldsCount != processedFieldsCount) {
                this.processAnnotations(z + 1);
                continue;
            }
            String key = this.support.getName(instanceDetails.getName());
            this.processed.put(key, instanceDetails);
        }
    }

    protected final void attachValue(@NotNull Field field, @Nullable Object object, @Nullable String stringValue) throws Exception {
        Comparable<Boolean> value;
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Class<?> clazz = field.getType();
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"field.type");
        Type type = clazz;
        if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.String")) {
            field.set(object, stringValue);
        }
        if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"boolean") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Boolean")) {
            value = Boolean.valueOf(stringValue);
            field.set(object, value);
        }
        if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"int") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Integer")) {
            value = Integer.valueOf(stringValue);
            field.set(object, value);
        }
        if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"float") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Float")) {
            value = Float.valueOf(stringValue);
            field.set(object, value);
        }
        if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"double") || Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.lang.Double")) {
            value = Double.valueOf(stringValue);
            field.set(object, value);
        }
        if (Intrinsics.areEqual((Object)type.getTypeName(), (Object)"java.math.BigDecimal")) {
            value = new BigDecimal(stringValue);
            field.set(object, value);
        }
    }

    protected final int getAnnotatedFieldsCount(@Nullable Class<?> clazz) throws Exception {
        int count = 0;
        Class<?> clazz2 = clazz;
        Intrinsics.checkNotNull(clazz2);
        Field[] fields = clazz2.getDeclaredFields();
        Intrinsics.checkNotNullExpressionValue((Object)fields, (String)"fields");
        for (Field field : fields) {
            if (field.isAnnotationPresent(Inject.class)) {
                ++count;
            }
            if (!field.isAnnotationPresent(Property.class)) continue;
            ++count;
        }
        return count;
    }

    private final void map() {
        block1: {
            Object object = this.cache;
            if (object == null || (object = ((PLSAR.Cache)object).getElementProcessor()) == null || (object = ((ElementProcessor)object).getAnnotatedInstances()) == null) break block1;
            Map<String, InstanceDetails> $this$forEach$iv = object;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<String, InstanceDetails>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, InstanceDetails> element$iv;
                Map.Entry<String, InstanceDetails> entry = element$iv = iterator.next();
                boolean bl = false;
                InstanceDetails instanceDetails = entry.getValue();
                if (this.annotations.contains(instanceDetails)) continue;
                List<InstanceDetails> list = this.annotations;
                if (list == null) continue;
                list.add(instanceDetails);
            }
        }
    }

    protected final boolean allAnnotationsProcessed() {
        Map<String, InstanceDetails> map;
        ElementProcessor elementProcessor;
        PLSAR.Cache cache = this.cache;
        return cache != null && (elementProcessor = cache.getElementProcessor()) != null && (map = elementProcessor.getAnnotatedInstances()) != null ? this.processed.size() == map.size() : false;
    }
}

