/*
 * Decompiled with CFR 0.152.
 */
package plsar.model.web;

import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar.PLSAR;
import plsar.model.web.FormElement;
import plsar.model.web.HttpSession;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B%\u0012\u0016\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010)\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003J\u0015\u0010*\u001a\u0004\u0018\u00010\n2\b\u0010+\u001a\u0004\u0018\u00010\u0004H\u0086\u0002J\b\u0010,\u001a\u00020\u0005H\u0002J\u0010\u0010-\u001a\u0004\u0018\u00010\u00012\u0006\u0010+\u001a\u00020\u0004J\u0012\u0010.\u001a\u0004\u0018\u00010/2\b\u0010+\u001a\u0004\u0018\u00010\u0004J\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u00052\u0006\u00100\u001a\u000201J\u001d\u00102\u001a\u0002032\b\u0010+\u001a\u0004\u0018\u00010\u00042\b\u00104\u001a\u0004\u0018\u00010\nH\u0086\u0002J\u0006\u0010\u001f\u001a\u000203J\u0010\u00105\u001a\u0002032\b\u00106\u001a\u0004\u0018\u00010\u0004J\u0012\u00107\u001a\u0004\u0018\u00010\u00042\b\u0010+\u001a\u0004\u0018\u00010\u0004R*\u0010\t\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\n0\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R*\u0010\u0002\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\f\"\u0004\b\"\u0010\u000eR\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(\u00a8\u00068"}, d2={"Lplsar/model/web/HttpRequest;", "", "sessions", "", "", "Lplsar/model/web/HttpSession;", "httpExchange", "Lcom/sun/net/httpserver/HttpExchange;", "(Ljava/util/Map;Lcom/sun/net/httpserver/HttpExchange;)V", "elements", "Lplsar/model/web/FormElement;", "getElements", "()Ljava/util/Map;", "setElements", "(Ljava/util/Map;)V", "headers", "Lcom/sun/net/httpserver/Headers;", "getHeaders", "()Lcom/sun/net/httpserver/Headers;", "getHttpExchange", "()Lcom/sun/net/httpserver/HttpExchange;", "setHttpExchange", "(Lcom/sun/net/httpserver/HttpExchange;)V", "requestBody", "getRequestBody", "()Ljava/lang/String;", "setRequestBody", "(Ljava/lang/String;)V", "session", "getSession", "()Lplsar/model/web/HttpSession;", "setSession", "(Lplsar/model/web/HttpSession;)V", "getSessions", "setSessions", "support", "Lplsar/PLSAR$Support;", "getSupport", "()Lplsar/PLSAR$Support;", "setSupport", "(Lplsar/PLSAR$Support;)V", "data", "get", "key", "getHttpSession", "getMultiple", "getPayload", "", "newitup", "", "set", "", "formElement", "setValues", "parameters", "value", "plsar-framework"})
public final class HttpRequest {
    @NotNull
    private Map<String, HttpSession> sessions;
    @Nullable
    private HttpSession session;
    @NotNull
    private HttpExchange httpExchange;
    @NotNull
    private Map<String, FormElement> elements;
    @Nullable
    private String requestBody;
    @NotNull
    private PLSAR.Support support;

    public HttpRequest(@NotNull Map<String, HttpSession> sessions, @NotNull HttpExchange httpExchange) {
        Intrinsics.checkNotNullParameter(sessions, (String)"sessions");
        Intrinsics.checkNotNullParameter((Object)httpExchange, (String)"httpExchange");
        this.sessions = sessions;
        this.support = new PLSAR.Support();
        this.elements = new HashMap();
        this.httpExchange = httpExchange;
        this.setSession();
    }

    @NotNull
    public final Map<String, HttpSession> getSessions() {
        return this.sessions;
    }

    public final void setSessions(@NotNull Map<String, HttpSession> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.sessions = map;
    }

    @Nullable
    public final HttpSession getSession() {
        return this.session;
    }

    public final void setSession(@Nullable HttpSession httpSession) {
        this.session = httpSession;
    }

    @NotNull
    public final HttpExchange getHttpExchange() {
        return this.httpExchange;
    }

    public final void setHttpExchange(@NotNull HttpExchange httpExchange) {
        Intrinsics.checkNotNullParameter((Object)httpExchange, (String)"<set-?>");
        this.httpExchange = httpExchange;
    }

    @NotNull
    public final Map<String, FormElement> getElements() {
        return this.elements;
    }

    public final void setElements(@NotNull Map<String, FormElement> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.elements = map;
    }

    @Nullable
    public final String getRequestBody() {
        return this.requestBody;
    }

    public final void setRequestBody(@Nullable String string) {
        this.requestBody = string;
    }

    @NotNull
    public final PLSAR.Support getSupport() {
        return this.support;
    }

    public final void setSupport(@NotNull PLSAR.Support support) {
        Intrinsics.checkNotNullParameter((Object)support, (String)"<set-?>");
        this.support = support;
    }

    @NotNull
    public final Map<String, FormElement> data() {
        return this.elements;
    }

    @NotNull
    public final Headers getHeaders() {
        Headers headers = this.httpExchange.getRequestHeaders();
        Intrinsics.checkNotNullExpressionValue((Object)headers, (String)"httpExchange.requestHeaders");
        return headers;
    }

    public final void setSession() {
        String id = this.support.getCookie("plsar.sessions", this.httpExchange.getRequestHeaders());
        if (this.sessions.containsKey(id)) {
            this.session = this.sessions.get(id);
        }
    }

    @Nullable
    public final HttpSession getSession(boolean newitup) {
        String id = this.support.getCookie("plsar.sessions", this.httpExchange.getRequestHeaders());
        if (!newitup) {
            if (this.sessions.containsKey(id)) {
                this.session = this.sessions.get(id);
                return this.sessions.get(id);
            }
        } else if (newitup) {
            return this.getHttpSession();
        }
        return null;
    }

    private final HttpSession getHttpSession() {
        HttpSession httpSession = new HttpSession(this.sessions, this.httpExchange);
        this.sessions.put(httpSession.getId(), httpSession);
        String compound = "plsar.sessions=" + httpSession.getId();
        this.httpExchange.getResponseHeaders().set("Set-Cookie", compound);
        return httpSession;
    }

    public final void set(@Nullable String key, @Nullable FormElement formElement) {
        this.elements.put(key, formElement);
    }

    @Nullable
    public final String value(@Nullable String key) {
        String string;
        if (this.elements.containsKey(key)) {
            FormElement formElement = this.elements.get(key);
            Intrinsics.checkNotNull((Object)formElement);
            string = formElement.getValue();
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final FormElement get(@Nullable String key) {
        return this.elements.containsKey(key) ? this.elements.get(key) : null;
    }

    @Nullable
    public final Object getMultiple(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        ArrayList<String> values = new ArrayList<String>();
        for (Map.Entry<String, FormElement> entry : this.elements.entrySet()) {
            String key1 = entry.getKey();
            FormElement value = entry.getValue();
            if (!Intrinsics.areEqual((Object)key, (Object)key1)) continue;
            FormElement formElement = value;
            Intrinsics.checkNotNull((Object)formElement);
            if (formElement.getValue() == null) continue;
            values.add(value.getValue());
        }
        Collection $this$toTypedArray$iv = values;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        Object[] objectArray = thisCollection$iv.toArray(new Object[0]);
        if (objectArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        return objectArray;
    }

    @Nullable
    public final byte[] getPayload(@Nullable String key) {
        if (this.elements.containsKey(key)) {
            FormElement formElement = this.elements.get(key);
            Intrinsics.checkNotNull((Object)formElement);
            if (formElement.getFileBytes() != null) {
                FormElement formElement2 = this.elements.get(key);
                Intrinsics.checkNotNull((Object)formElement2);
                return formElement2.getFileBytes();
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public final void setValues(@Nullable String parameters) {
        String string = parameters;
        Intrinsics.checkNotNull((Object)string);
        CharSequence charSequence = string;
        Regex regex = new Regex("&");
        int n = 0;
        Collection $this$toTypedArray$iv = regex.split(charSequence, n);
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        if (stringArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        }
        for (String keyValue : stringArray) {
            String[] parts;
            void $this$toTypedArray$iv2;
            Object object = keyValue;
            Regex regex2 = new Regex("=");
            int n2 = 0;
            object = regex2.split((CharSequence)object, n2);
            boolean $i$f$toTypedArray2 = false;
            void thisCollection$iv2 = $this$toTypedArray$iv2;
            if (thisCollection$iv2.toArray(new String[0]) == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            if (parts.length <= 1) continue;
            String key = parts[0];
            String value = parts[1];
            FormElement formElement = new FormElement();
            formElement.setName(key);
            formElement.setValue(value);
            this.elements.put(key, formElement);
        }
    }
}

