/*
 * Decompiled with CFR 0.152.
 */
package plsar-auth;

import com.sun.net.httpserver.HttpExchange;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import plsar-auth.support.DbAccess;
import plsar.model.web.HttpRequest;
import plsar.model.web.HttpSession;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010$\u001a\u00020\u00132\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007J\u0011\u0010%\u001a\u00020\u00042\u0006\u0010&\u001a\u00020\u0004H\u0086\u0002J\u0010\u0010'\u001a\u00020\u00132\b\u0010(\u001a\u0004\u0018\u00010\u0004J\u0010\u0010)\u001a\u00020\u00132\b\u0010*\u001a\u0004\u0018\u00010\u0004J\u000e\u0010+\u001a\u00020\u00042\u0006\u0010,\u001a\u00020\u0004J\u0010\u0010-\u001a\u00020.2\b\u0010\f\u001a\u0004\u0018\u00010\rJ\u0010\u0010-\u001a\u00020.2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u0019\u0010/\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u00042\u0006\u00100\u001a\u00020\u0004H\u0086\u0002J\u0016\u00101\u001a\u00020\u00132\u0006\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004J\u0006\u00104\u001a\u00020\u0013R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\f\u001a\u00020\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001c0\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0013\u0010!\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u00065"}, d2={"Lplsar-auth/Auth;", "", "()V", "HASH_256", "", "USER_KEY", "dbAccess", "Lplsar-auth/support/DbAccess;", "getDbAccess", "()Lplsar-auth/support/DbAccess;", "setDbAccess", "(Lplsar-auth/support/DbAccess;)V", "exchange", "Lcom/sun/net/httpserver/HttpExchange;", "getExchange", "()Lcom/sun/net/httpserver/HttpExchange;", "exchangeStorage", "Ljava/lang/ThreadLocal;", "isAuthenticated", "", "()Z", "request", "Lplsar/model/web/HttpRequest;", "getRequest", "()Lplsar/model/web/HttpRequest;", "requestStorage", "sessions", "", "Lplsar/model/web/HttpSession;", "getSessions", "()Ljava/util/Map;", "setSessions", "(Ljava/util/Map;)V", "user", "getUser", "()Ljava/lang/String;", "configure", "get", "key", "hasPermission", "permission", "hasRole", "role", "hash", "password", "save", "", "set", "value", "signin", "username", "passwordUntouched", "signout", "plsar-auth-framework"})
public final class Auth {
    @NotNull
    public static final Auth INSTANCE = new Auth();
    @NotNull
    public static final String USER_KEY = "user";
    @NotNull
    public static final String HASH_256 = "SHA-256";
    @Nullable
    private static DbAccess dbAccess;
    @NotNull
    private static Map<String, HttpSession> sessions;
    @NotNull
    private static final ThreadLocal<HttpRequest> requestStorage;
    @NotNull
    private static final ThreadLocal<HttpExchange> exchangeStorage;

    private Auth() {
    }

    @Nullable
    public final DbAccess getDbAccess() {
        return dbAccess;
    }

    public final void setDbAccess(@Nullable DbAccess dbAccess) {
        Auth.dbAccess = dbAccess;
    }

    @NotNull
    public final Map<String, HttpSession> getSessions() {
        return sessions;
    }

    public final void setSessions(@NotNull Map<String, HttpSession> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        sessions = map;
    }

    public final void save(@Nullable HttpRequest request) {
        requestStorage.set(request);
    }

    public final void save(@Nullable HttpExchange exchange) {
        exchangeStorage.set(exchange);
    }

    @NotNull
    public final HttpRequest getRequest() {
        HttpRequest httpRequest = requestStorage.get();
        Intrinsics.checkNotNullExpressionValue((Object)httpRequest, (String)"requestStorage.get()");
        return httpRequest;
    }

    @NotNull
    public final HttpExchange getExchange() {
        HttpExchange httpExchange = exchangeStorage.get();
        Intrinsics.checkNotNullExpressionValue((Object)httpExchange, (String)"exchangeStorage.get()");
        return httpExchange;
    }

    public final boolean hasRole(@Nullable String role) {
        Auth auth = INSTANCE;
        Intrinsics.checkNotNull((Object)auth);
        String user = auth.getUser();
        if (user != null) {
            Set<String> roles;
            DbAccess dbAccess = Auth.dbAccess;
            Set<String> set = roles = dbAccess != null ? dbAccess.getRoles(user) : null;
            Intrinsics.checkNotNull(set);
            if (set.contains(role)) {
                return true;
            }
        }
        return false;
    }

    public final boolean hasPermission(@Nullable String permission) {
        String user = INSTANCE.getUser();
        if (user != null) {
            Set<String> permissions;
            DbAccess dbAccess = Auth.dbAccess;
            Set<String> set = permissions = dbAccess != null ? dbAccess.getPermissions(user) : null;
            Intrinsics.checkNotNull(set);
            if (set.contains(permission)) {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public final String getUser() {
        String string;
        HttpRequest req = INSTANCE.getRequest();
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            Object object = httpSession.get(USER_KEY);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.String");
            }
            string = (String)object;
        } else {
            string = "";
        }
        return string;
    }

    @NotNull
    public final String get(@NotNull String key) {
        String string;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        HttpRequest req = INSTANCE.getRequest();
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            String string2 = String.valueOf(httpSession.get(key));
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"{\n            java.lang.\u2026sion?.get(key))\n        }");
        } else {
            string = "";
        }
        return string;
    }

    public final boolean set(@NotNull String key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        HttpRequest req = INSTANCE.getRequest();
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            httpSession.set(key, (Object)value);
        }
        return true;
    }

    public final boolean signin(@NotNull String username, @NotNull String passwordUntouched) {
        String password;
        Intrinsics.checkNotNullParameter((Object)username, (String)"username");
        Intrinsics.checkNotNullParameter((Object)passwordUntouched, (String)"passwordUntouched");
        String hashed = INSTANCE.hash(passwordUntouched);
        DbAccess dbAccess = Auth.dbAccess;
        String string = password = dbAccess != null ? dbAccess.getPassword(username) : null;
        if (!this.isAuthenticated() && Intrinsics.areEqual((Object)password, (Object)hashed)) {
            HttpSession httpSession;
            HttpRequest req = INSTANCE.getRequest();
            HttpSession oldHttpSession = req.getSession(false);
            if (oldHttpSession != null) {
                oldHttpSession.dispose();
            }
            HttpSession httpSession2 = httpSession = req.getSession(true);
            Intrinsics.checkNotNull((Object)httpSession2);
            httpSession2.set(USER_KEY, (Object)username);
            sessions.put(httpSession.getId(), httpSession);
            return true;
        }
        return false;
    }

    public final boolean signout() {
        HttpRequest req = INSTANCE.getRequest();
        HttpSession httpSession = req.getSession(false);
        if (httpSession != null) {
            httpSession.dispose();
            httpSession.remove(USER_KEY);
            if (sessions.containsKey(httpSession.getId())) {
                sessions.remove(httpSession.getId());
            }
        }
        return true;
    }

    public final boolean isAuthenticated() {
        HttpSession httpSession;
        HttpRequest req = INSTANCE.getRequest();
        return req != null && (httpSession = req.getSession(false)) != null && sessions.containsKey(httpSession.getId());
    }

    public final boolean configure(@Nullable DbAccess dbAccess) {
        Auth.dbAccess = dbAccess;
        return true;
    }

    @NotNull
    public final String hash(@NotNull String password) {
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        MessageDigest md = null;
        StringBuffer passwordHashed = new StringBuffer();
        try {
            md = MessageDigest.getInstance(HASH_256);
            String string = password;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            md.update(byArray);
            byte[] byArray2 = md.digest();
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"md.digest()");
            byte[] byteData = byArray2;
            int n = byteData.length;
            for (int i = 0; i < n; ++i) {
                String string2;
                Intrinsics.checkNotNullExpressionValue((Object)Integer.toString((byte)(byteData[i] & 0xFFFFFFFF) + 256, 16), (String)"toString((byteData[i] an\u2026ff.toByte()) + 0x100, 16)");
                int n2 = 1;
                String string3 = string2.substring(n2);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                passwordHashed.append(string3);
            }
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String string = passwordHashed.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"passwordHashed.toString()");
        return string;
    }

    static {
        sessions = new ConcurrentHashMap();
        requestStorage = new InheritableThreadLocal();
        exchangeStorage = new InheritableThreadLocal();
    }
}

