package net.playq.tk.aws.sagemaker.test

import distage.ModuleDef
import izumi.distage.model.providers.Functoid
import izumi.reflect.Tag
import net.playq.tk.aws.sagemaker.config.SagemakerConfig
import net.playq.tk.test.{ModuleOverrides, WithProduction}
import org.scalatest.Assertions

trait SagemakerTestEnv extends ModuleOverrides with WithProduction with Assertions {
  private[this] var forcedLocalTest: Boolean   = false
  protected[this] final def localTest: Boolean = forcedLocalTest
  @deprecated("Local test code found in build", "always")
  protected[this] final def forceLocalTest(): Unit = { forcedLocalTest = true }

  override def moduleOverrides: distage.Module = super.moduleOverrides ++ new ModuleDef {
    if (forcedLocalTest) {
      modify[SagemakerConfig](_.copy(roleArn = "arn:aws:iam::372184970924:role/groups/TGServices"))
    }
  }

  /**
    * Sagemaker tests require credentials to run which CI has access to.
    *
    * To run locally you may try to assume (uncomment in `aws-sagemaker-reference.conf`)
    * role `arn:aws:iam::372184970924:role/groups/TGServices` or equivalent.
    * You may need to ask devops to set it up for you.
    */
  final def skipIfNotOnCI[A: Tag](testFunctoid: => Functoid[A]): Functoid[A] = {
    val ciBuildNumber = Option(System.getenv("BUILD_NUMBER")).getOrElse("")
    if (ciBuildNumber.isEmpty && !forcedLocalTest) {
      Functoid[A] {
        () =>
          cancel("Skipping Sagemaker tests locally (real infrastructure access is required)")
      }
    } else {
      testFunctoid
    }
  }
}
