/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.trade.TradeService;
import org.knowm.xchange.service.trade.params.CancelOrderByIdParams;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParamCurrencyPair;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;
import org.knowm.xchange.yobit.YoBit;
import org.knowm.xchange.yobit.YoBitAdapters;
import org.knowm.xchange.yobit.YoBitExchange;
import org.knowm.xchange.yobit.dto.BaseYoBitResponse;
import org.knowm.xchange.yobit.service.YoBitBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public abstract class YoBitTradeServiceRaw
extends YoBitBaseService<YoBit>
implements TradeService {
    public YoBitTradeServiceRaw(YoBitExchange exchange) {
        super(YoBit.class, exchange);
    }

    public OpenOrders getOpenOrders() throws IOException {
        throw new NotYetImplementedForExchangeException("Need to specify OpenOrdersParams");
    }

    public BaseYoBitResponse activeOrders(OpenOrdersParamCurrencyPair params) throws IOException {
        CurrencyPair currencyPair = params.getCurrencyPair();
        String market = YoBitAdapters.adaptCcyPairToUrlFormat(currencyPair);
        BaseYoBitResponse response = this.service.activeOrders(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, "ActiveOrders", (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), market);
        if (!response.success) {
            throw new ExchangeException("failed to get open orders");
        }
        return response;
    }

    public BaseYoBitResponse trade(LimitOrder limitOrder) throws IOException {
        String market = YoBitAdapters.adaptCcyPairToUrlFormat(limitOrder.getCurrencyPair());
        String direction = limitOrder.getType().equals((Object)Order.OrderType.BID) ? "buy" : "sell";
        BaseYoBitResponse response = this.service.trade(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, "Trade", (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), market, direction, limitOrder.getLimitPrice(), limitOrder.getOriginalAmount());
        if (!response.success) {
            throw new ExchangeException("failed to get place order");
        }
        return response;
    }

    public BaseYoBitResponse cancelOrder(CancelOrderByIdParams params) throws IOException {
        return this.cancelOrderById(params.getOrderId());
    }

    protected BaseYoBitResponse cancelOrderById(String orderId) throws IOException {
        return this.service.cancelOrder(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, "CancelOrder", (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), Long.valueOf(orderId));
    }

    public BaseYoBitResponse tradeHistory(Integer count, Long offset, String market, Long fromTransactionId, Long endTransactionId, String order, Long fromTimestamp, Long toTimestamp) throws IOException {
        return this.service.tradeHistory(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, "TradeHistory", (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), offset, count, fromTransactionId, endTransactionId, order, fromTimestamp, toTimestamp, market);
    }

    public Collection<Order> getOrderImpl(String ... orderIds) throws IOException {
        ArrayList<Order> orders = new ArrayList<Order>();
        for (String orderId : orderIds) {
            Long id = Long.valueOf(orderId);
            BaseYoBitResponse response = this.service.orderInfo(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, "OrderInfo", (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), id);
            if (response.returnData == null) continue;
            Map map = (Map)response.returnData.get(orderId);
            LimitOrder order = YoBitAdapters.adaptOrder(orderId, map);
            orders.add((Order)order);
        }
        return orders;
    }

    public Collection<Order> getOrder(OrderQueryParams ... orderQueryParams) throws IOException {
        return this.getOrderImpl(TradeService.toOrderIds((OrderQueryParams[])orderQueryParams));
    }
}

