/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.service;

import java.io.IOException;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.yobit.YoBit;
import org.knowm.xchange.yobit.YoBitAdapters;
import org.knowm.xchange.yobit.dto.marketdata.YoBitInfo;
import org.knowm.xchange.yobit.dto.marketdata.YoBitOrderBooksReturn;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTickersReturn;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTrades;
import org.knowm.xchange.yobit.service.YoBitBaseService;

public class YoBitMarketDataServiceRaw
extends YoBitBaseService<YoBit> {
    private static final int MAX_PAIR_LIST_SIZE = 512;

    protected YoBitMarketDataServiceRaw(Exchange exchange) {
        super(YoBit.class, exchange);
    }

    public YoBitInfo getProducts() throws IOException {
        return this.service.getProducts();
    }

    public YoBitTickersReturn getYoBitTickers(Iterable<CurrencyPair> currencyPairs) throws IOException {
        return this.service.getTickers(this.getPairListAsString(currencyPairs));
    }

    public YoBitOrderBooksReturn getOrderBooks(Iterable<CurrencyPair> currencyPairs, Integer limit) throws IOException {
        return this.service.getOrderBooks(this.getPairListAsString(currencyPairs), limit.intValue());
    }

    public YoBitTrades getPublicTrades(Iterable<CurrencyPair> currencyPairs) throws IOException {
        return this.service.getTrades(this.getPairListAsString(currencyPairs));
    }

    private String getPairListAsString(Iterable<CurrencyPair> currencyPairs) {
        String markets = YoBitAdapters.adaptCcyPairsToUrlFormat(currencyPairs);
        if (markets.length() > 512) {
            throw new ExchangeException("URL too long: YoBit allows a maximum of 512 characters for total pair lists size. Provided string is " + markets.length() + " characters long.");
        }
        return markets;
    }
}

