/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.service.account.AccountService;
import org.knowm.xchange.service.trade.params.DefaultWithdrawFundsParams;
import org.knowm.xchange.yobit.YoBit;
import org.knowm.xchange.yobit.YoBitAdapters;
import org.knowm.xchange.yobit.YoBitExchange;
import org.knowm.xchange.yobit.dto.BaseYoBitResponse;
import org.knowm.xchange.yobit.service.YoBitBaseService;
import si.mazi.rescu.SynchronizedValueFactory;

public abstract class YoBitAccountServiceRaw
extends YoBitBaseService<YoBit>
implements AccountService {
    public YoBitAccountServiceRaw(YoBitExchange exchange) {
        super(YoBit.class, exchange);
    }

    public AccountInfo getInfo() throws IOException {
        HashMap fundsIncludingOrders;
        BaseYoBitResponse response = this.service.getInfo(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, "getInfo", (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        if (!response.success) {
            throw new ExchangeException("failed to get account info");
        }
        Map walletData = response.returnData;
        HashMap funds = (HashMap)walletData.get("funds");
        if (funds == null) {
            funds = new HashMap();
        }
        if ((fundsIncludingOrders = (HashMap)walletData.get("funds_incl_orders")) == null) {
            fundsIncludingOrders = new HashMap();
        }
        ArrayList<Wallet> wallets = new ArrayList<Wallet>();
        for (Object key : funds.keySet()) {
            Currency currency = YoBitAdapters.adaptCurrency(key.toString());
            BigDecimal amountAvailable = new BigDecimal(funds.get(key).toString());
            BigDecimal amountIncludingOrders = new BigDecimal(fundsIncludingOrders.get(key).toString());
            Balance balance = new Balance(currency, amountIncludingOrders, amountAvailable, amountIncludingOrders.subtract(amountAvailable), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
            wallets.add(Wallet.Builder.from(Arrays.asList(balance)).id(currency.getCurrencyCode()).build());
        }
        return new AccountInfo(wallets);
    }

    public BaseYoBitResponse withdrawCoinsToAddress(DefaultWithdrawFundsParams params) throws IOException {
        DefaultWithdrawFundsParams defaultWithdrawFundsParams = params;
        BaseYoBitResponse response = this.service.withdrawCoinsToAddress(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, "WithdrawCoinsToAddress", (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), defaultWithdrawFundsParams.getCurrency().getCurrencyCode(), defaultWithdrawFundsParams.getAmount(), defaultWithdrawFundsParams.getAddress());
        if (!response.success) {
            throw new ExchangeException("failed to withdraw funds");
        }
        return response;
    }

    public BaseYoBitResponse getDepositAddress(Currency currency) throws IOException {
        boolean needNew = false;
        return this.service.getDepositAddress(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, "GetDepositAddress", (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), currency.getCurrencyCode(), needNew);
    }
}

