/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTrade;

@JsonDeserialize(using=YoBitTradesDeserializer.class)
public class YoBitTrades {
    public final Map<String, List<YoBitTrade>> trades;

    public YoBitTrades(Map<String, List<YoBitTrade>> trades) {
        this.trades = trades;
    }

    public Map<String, List<YoBitTrade>> getTrades() {
        return this.trades;
    }

    static class YoBitTradesDeserializer
    extends JsonDeserializer<YoBitTrades> {
        YoBitTradesDeserializer() {
        }

        public YoBitTrades deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            HashMap<String, List<YoBitTrade>> trades = new HashMap<String, List<YoBitTrade>>();
            ObjectCodec oc = p.getCodec();
            JsonNode node = (JsonNode)oc.readTree(p);
            if (node.isObject()) {
                Iterator priceEntryIter = node.fields();
                while (priceEntryIter.hasNext()) {
                    Map.Entry priceEntryNode = (Map.Entry)priceEntryIter.next();
                    JsonNode priceNode = (JsonNode)priceEntryNode.getValue();
                    String ccyPair = (String)priceEntryNode.getKey();
                    ArrayList<YoBitTrade> res = new ArrayList<YoBitTrade>();
                    trades.put(ccyPair, res);
                    if (!priceNode.isArray()) continue;
                    for (JsonNode jsonNode : priceNode) {
                        ObjectMapper jsonObjectMapper = new ObjectMapper();
                        res.add((YoBitTrade)jsonObjectMapper.convertValue((Object)jsonNode, YoBitTrade.class));
                    }
                }
            }
            return new YoBitTrades(trades);
        }
    }
}

