/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knowm.xchange.yobit.dto.marketdata.YoBitOrderBook;
import org.knowm.xchange.yobit.dto.marketdata.YoBitOrderBooksReturn;

public class YoBitOrderBooksDeserializer
extends JsonDeserializer<YoBitOrderBooksReturn> {
    public YoBitOrderBooksReturn deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        HashMap<String, YoBitOrderBook> tickers = new HashMap<String, YoBitOrderBook>();
        if (node.isObject()) {
            Iterator priceEntryIter = node.fields();
            while (priceEntryIter.hasNext()) {
                Map.Entry priceEntryNode = (Map.Entry)priceEntryIter.next();
                JsonNode jsonNode = (JsonNode)priceEntryNode.getValue();
                ObjectReader jsonObjectReader = new ObjectMapper().readerFor(YoBitOrderBook.class);
                YoBitOrderBook orderBook = (YoBitOrderBook)jsonObjectReader.readValue(jsonNode);
                String ccy = (String)priceEntryNode.getKey();
                tickers.put(ccy, orderBook);
            }
        }
        return new YoBitOrderBooksReturn(tickers);
    }
}

