/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit.dto.marketdata;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.yobit.dto.marketdata.YoBitAsksBidsData;

@JsonDeserialize(using=YoBitOrderBookDeserializer.class)
public class YoBitOrderBook {
    private List<YoBitAsksBidsData> asks;
    private List<YoBitAsksBidsData> bids;

    public YoBitOrderBook(List<YoBitAsksBidsData> asks, List<YoBitAsksBidsData> bids) {
        this.asks = asks;
        this.bids = bids;
    }

    public List<YoBitAsksBidsData> getAsks() {
        return this.asks;
    }

    public List<YoBitAsksBidsData> getBids() {
        return this.bids;
    }

    static class YoBitOrderBookDeserializer
    extends JsonDeserializer<YoBitOrderBook> {
        YoBitOrderBookDeserializer() {
        }

        public YoBitOrderBook deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            ObjectCodec oc = jp.getCodec();
            JsonNode node = (JsonNode)oc.readTree(jp);
            List<YoBitAsksBidsData> asks = this.parse(node.get("asks"));
            List<YoBitAsksBidsData> bids = this.parse(node.get("bids"));
            return new YoBitOrderBook(asks, bids);
        }

        private List<YoBitAsksBidsData> parse(JsonNode nodeArray) {
            ArrayList<YoBitAsksBidsData> res = new ArrayList<YoBitAsksBidsData>();
            if (nodeArray != null) {
                for (JsonNode jsonNode : nodeArray) {
                    res.add(new YoBitAsksBidsData(BigDecimal.valueOf(jsonNode.get(1).asDouble()), BigDecimal.valueOf(jsonNode.get(0).asDouble())));
                }
            }
            return res;
        }
    }
}

