/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit;

import java.io.IOException;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.utils.nonce.AtomicLongIncrementalTime2014NonceFactory;
import org.knowm.xchange.yobit.YoBitAdapters;
import org.knowm.xchange.yobit.dto.marketdata.YoBitInfo;
import org.knowm.xchange.yobit.service.YoBitAccountService;
import org.knowm.xchange.yobit.service.YoBitMarketDataService;
import org.knowm.xchange.yobit.service.YoBitMarketDataServiceRaw;
import org.knowm.xchange.yobit.service.YoBitTradeService;
import si.mazi.rescu.SynchronizedValueFactory;

public class YoBitExchange
extends BaseExchange
implements Exchange {
    private SynchronizedValueFactory<Long> nonceFactory = new AtomicLongIncrementalTime2014NonceFactory();

    public SynchronizedValueFactory<Long> getNonceFactory() {
        return this.nonceFactory;
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpecification = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpecification.setSslUri("https://yobit.net");
        exchangeSpecification.setHost("yobit.net");
        exchangeSpecification.setPort(80);
        exchangeSpecification.setExchangeName("YoBit");
        exchangeSpecification.setExchangeDescription("YoBit.Net - Ethereum (ETH) Exchange");
        return exchangeSpecification;
    }

    protected void initServices() {
        this.marketDataService = new YoBitMarketDataService(this);
        this.accountService = new YoBitAccountService(this);
        this.tradeService = new YoBitTradeService(this);
    }

    public void remoteInit() throws IOException {
        YoBitInfo products = ((YoBitMarketDataServiceRaw)this.marketDataService).getProducts();
        this.exchangeMetaData = YoBitAdapters.adaptToExchangeMetaData(this.exchangeMetaData, products);
    }
}

