/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.Fee;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.meta.FeeTier;
import org.knowm.xchange.dto.meta.InstrumentMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.DateUtils;
import org.knowm.xchange.yobit.dto.marketdata.YoBitAsksBidsData;
import org.knowm.xchange.yobit.dto.marketdata.YoBitInfo;
import org.knowm.xchange.yobit.dto.marketdata.YoBitOrderBook;
import org.knowm.xchange.yobit.dto.marketdata.YoBitPair;
import org.knowm.xchange.yobit.dto.marketdata.YoBitPairs;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTicker;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTrade;

public class YoBitAdapters {
    public static CurrencyPair adaptCurrencyPair(String pair) {
        String[] currencies = pair.toUpperCase().split("_");
        if (currencies.length != 2) {
            throw new IllegalStateException("Cannot parse currency pair: " + pair);
        }
        return new CurrencyPair(YoBitAdapters.adaptCurrency(currencies[0]), YoBitAdapters.adaptCurrency(currencies[1]));
    }

    public static Currency adaptCurrency(String ccy) {
        return Currency.getInstance((String)ccy.toUpperCase());
    }

    public static OrderBook adaptOrderBook(YoBitOrderBook book, CurrencyPair currencyPair) {
        List<LimitOrder> asks = YoBitAdapters.toLimitOrderList(book.getAsks(), Order.OrderType.ASK, currencyPair);
        List<LimitOrder> bids = YoBitAdapters.toLimitOrderList(book.getBids(), Order.OrderType.BID, currencyPair);
        return new OrderBook(null, asks, bids);
    }

    public static ExchangeMetaData adaptToExchangeMetaData(ExchangeMetaData exchangeMetaData, YoBitInfo products) {
        Map currencyPairs = exchangeMetaData.getInstruments();
        Map currencies = exchangeMetaData.getCurrencies();
        YoBitPairs pairs = products.getPairs();
        Map<CurrencyPair, YoBitPair> price = pairs.getPrice();
        for (Map.Entry<CurrencyPair, YoBitPair> entry : price.entrySet()) {
            BigDecimal withdrawalFee;
            CurrencyMetaData currencyMetaData;
            CurrencyPair pair = entry.getKey();
            YoBitPair value = entry.getValue();
            BigDecimal minSize = value.getMin_amount();
            Integer priceScale = value.getDecimal_places();
            currencyPairs.put(pair, new InstrumentMetaData.Builder().tradingFee(value.getFee()).minimumAmount(minSize).priceScale(priceScale).feeTiers(new FeeTier[]{new FeeTier(BigDecimal.ZERO, new Fee(value.getFee_seller(), value.getFee_buyer()))}).build());
            if (!currencies.containsKey(pair.base)) {
                currencyMetaData = (CurrencyMetaData)exchangeMetaData.getCurrencies().get(pair.base);
                withdrawalFee = currencyMetaData == null ? null : currencyMetaData.getWithdrawalFee();
                currencies.put(pair.base, new CurrencyMetaData(Integer.valueOf(8), withdrawalFee));
            }
            if (currencies.containsKey(pair.counter)) continue;
            currencyMetaData = (CurrencyMetaData)exchangeMetaData.getCurrencies().get(pair.counter);
            withdrawalFee = currencyMetaData == null ? null : new CurrencyMetaData(Integer.valueOf(8), currencyMetaData.getWithdrawalFee());
            currencies.put(pair.counter, withdrawalFee);
        }
        return exchangeMetaData;
    }

    private static List<LimitOrder> toLimitOrderList(List<YoBitAsksBidsData> levels, Order.OrderType orderType, CurrencyPair currencyPair) {
        ArrayList<LimitOrder> allLevels = new ArrayList<LimitOrder>(levels.size());
        for (YoBitAsksBidsData ask : levels) {
            if (ask == null) continue;
            allLevels.add(new LimitOrder(orderType, ask.getQuantity(), (Instrument)currencyPair, "0", null, ask.getRate()));
        }
        return allLevels;
    }

    public static Trades adaptTrades(List<YoBitTrade> ctrades, CurrencyPair currencyPair) {
        ArrayList<Trade> trades = new ArrayList<Trade>(ctrades.size());
        int lastTrade = 0;
        int i = 0;
        while (i < ctrades.size()) {
            YoBitTrade trade = ctrades.get(i);
            Order.OrderType type = trade.getType().equals("bid") ? Order.OrderType.BID : Order.OrderType.ASK;
            Trade t = new Trade.Builder().type(type).originalAmount(trade.getAmount()).currencyPair(currencyPair).price(trade.getPrice()).timestamp(YoBitAdapters.parseDate(trade.getTimestamp())).id(String.valueOf(trade.getTid())).build();
            trades.add(t);
            lastTrade = i++;
        }
        return new Trades(trades, ctrades.get(lastTrade).getTid().longValue(), Trades.TradeSortType.SortByID);
    }

    private static Date parseDate(Long rawDateLong) {
        return new Date(rawDateLong * 1000L);
    }

    public static Ticker adaptTicker(YoBitTicker ticker, CurrencyPair currencyPair) {
        Ticker.Builder builder = new Ticker.Builder();
        builder.currencyPair(currencyPair);
        builder.last(ticker.getLast());
        builder.bid(ticker.getBuy());
        builder.ask(ticker.getSell());
        builder.high(ticker.getHigh());
        builder.low(ticker.getLow());
        builder.volume(ticker.getVolCur());
        builder.timestamp(new Date(ticker.getUpdated() * 1000L));
        return builder.build();
    }

    public static String adaptCcyPairsToUrlFormat(Iterable<CurrencyPair> currencyPairs) {
        return StreamSupport.stream(currencyPairs.spliterator(), false).map(YoBitAdapters::adaptCcyPairToUrlFormat).collect(Collectors.joining("-"));
    }

    public static String adaptCcyPairToUrlFormat(CurrencyPair currencyPair) {
        return currencyPair.base.getCurrencyCode().toLowerCase() + "_" + currencyPair.counter.getCurrencyCode().toLowerCase();
    }

    public static Order.OrderType adaptType(String type) {
        return type.equalsIgnoreCase("sell") ? Order.OrderType.ASK : Order.OrderType.BID;
    }

    public static Order.OrderStatus adaptOrderStatus(String status) {
        Order.OrderStatus orderStatus = Order.OrderStatus.PARTIALLY_FILLED;
        switch (status) {
            case "0": {
                orderStatus = Order.OrderStatus.NEW;
                break;
            }
            case "1": {
                orderStatus = Order.OrderStatus.FILLED;
                break;
            }
            case "2": {
                orderStatus = Order.OrderStatus.CANCELED;
                break;
            }
            case "3": {
                orderStatus = Order.OrderStatus.STOPPED;
            }
        }
        return orderStatus;
    }

    public static LimitOrder adaptOrder(String orderId, Map map) {
        String pair = map.get("pair").toString();
        String type = map.get("type").toString();
        String amountRemaining = map.get("amount").toString();
        String rate = map.get("rate").toString();
        String timestamp = map.get("timestamp_created").toString();
        String status = map.get("status").toString();
        Date time = DateUtils.fromUnixTime((long)Long.valueOf(timestamp));
        Order.OrderStatus orderStatus = YoBitAdapters.adaptOrderStatus(status);
        return new LimitOrder(YoBitAdapters.adaptType(type), new BigDecimal(amountRemaining), (Instrument)YoBitAdapters.adaptCurrencyPair(pair), orderId, time, new BigDecimal(rate), null, null, null, orderStatus);
    }

    public static UserTrade adaptUserTrade(Object key, Map tradeData) {
        String id = key.toString();
        String type = tradeData.get("type").toString();
        String amount = tradeData.get("amount").toString();
        String rate = tradeData.get("rate").toString();
        String orderId = tradeData.get("order_id").toString();
        String pair = tradeData.get("pair").toString();
        String timestamp = tradeData.get("timestamp").toString();
        Date time = DateUtils.fromUnixTime((long)Long.parseLong(timestamp));
        return UserTrade.builder().type(YoBitAdapters.adaptType(type)).originalAmount(new BigDecimal(amount)).currencyPair(YoBitAdapters.adaptCurrencyPair(pair)).price(new BigDecimal(rate)).timestamp(time).id(id).orderId(orderId).build();
    }
}

