/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.yobit;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.yobit.YoBitDigest;
import org.knowm.xchange.yobit.dto.BaseYoBitResponse;
import org.knowm.xchange.yobit.dto.marketdata.YoBitInfo;
import org.knowm.xchange.yobit.dto.marketdata.YoBitOrderBooksReturn;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTickersReturn;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTrades;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="/")
@Produces(value={"application/json"})
public interface YoBit {
    @GET
    @Path(value="api/3/info")
    public YoBitInfo getProducts() throws IOException;

    @GET
    @Path(value="api/3/depth/{currencyPairs}")
    public YoBitOrderBooksReturn getOrderBooks(@PathParam(value="currencyPairs") String var1, @QueryParam(value="limit") long var2) throws IOException;

    @GET
    @Path(value="api/3/trades/{currencyPairs}")
    public YoBitTrades getTrades(@PathParam(value="currencyPairs") String var1) throws IOException;

    @GET
    @Path(value="api/3/ticker/{currencyPairs}")
    public YoBitTickersReturn getTickers(@PathParam(value="currencyPairs") String var1) throws IOException;

    @POST
    @Path(value="/tapi")
    public BaseYoBitResponse getInfo(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") YoBitDigest var2, @FormParam(value="method") String var3, @FormParam(value="nonce") SynchronizedValueFactory<Long> var4) throws IOException;

    @POST
    @Path(value="/tapi")
    public BaseYoBitResponse withdrawCoinsToAddress(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") YoBitDigest var2, @FormParam(value="method") String var3, @FormParam(value="nonce") SynchronizedValueFactory<Long> var4, @FormParam(value="coinName") String var5, @FormParam(value="amount") BigDecimal var6, @FormParam(value="address") String var7) throws IOException;

    @POST
    @Path(value="/tapi")
    public BaseYoBitResponse getDepositAddress(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") YoBitDigest var2, @FormParam(value="method") String var3, @FormParam(value="nonce") SynchronizedValueFactory<Long> var4, @FormParam(value="coinName") String var5, @FormParam(value="need_new") Boolean var6) throws IOException;

    @POST
    @Path(value="/tapi")
    public BaseYoBitResponse tradeHistory(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") YoBitDigest var2, @FormParam(value="method") String var3, @FormParam(value="nonce") SynchronizedValueFactory<Long> var4, @FormParam(value="form") Long var5, @FormParam(value="count") Integer var6, @FormParam(value="from_id") Long var7, @FormParam(value="end_id") Long var8, @FormParam(value="order") String var9, @FormParam(value="since") Long var10, @FormParam(value="end") Long var11, @FormParam(value="pair") String var12) throws IOException;

    @POST
    @Path(value="/tapi")
    public BaseYoBitResponse activeOrders(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") YoBitDigest var2, @FormParam(value="method") String var3, @FormParam(value="nonce") SynchronizedValueFactory<Long> var4, @FormParam(value="pair") String var5) throws IOException;

    @POST
    @Path(value="/tapi")
    public BaseYoBitResponse orderInfo(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") YoBitDigest var2, @FormParam(value="method") String var3, @FormParam(value="nonce") SynchronizedValueFactory<Long> var4, @FormParam(value="order_id") Long var5) throws IOException;

    @POST
    @Path(value="/tapi")
    public BaseYoBitResponse cancelOrder(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") YoBitDigest var2, @FormParam(value="method") String var3, @FormParam(value="nonce") SynchronizedValueFactory<Long> var4, @FormParam(value="order_id") Long var5) throws IOException;

    @POST
    @Path(value="/tapi")
    public BaseYoBitResponse trade(@HeaderParam(value="Key") String var1, @HeaderParam(value="Sign") YoBitDigest var2, @FormParam(value="method") String var3, @FormParam(value="nonce") SynchronizedValueFactory<Long> var4, @FormParam(value="pair") String var5, @FormParam(value="type") String var6, @FormParam(value="rate") BigDecimal var7, @FormParam(value="amount") BigDecimal var8) throws IOException;
}

