package org.knowm.xchange.yobit;

import jakarta.ws.rs.FormParam;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.math.BigDecimal;
import org.knowm.xchange.yobit.dto.BaseYoBitResponse;
import org.knowm.xchange.yobit.dto.marketdata.YoBitInfo;
import org.knowm.xchange.yobit.dto.marketdata.YoBitOrderBooksReturn;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTickersReturn;
import org.knowm.xchange.yobit.dto.marketdata.YoBitTrades;
import si.mazi.rescu.SynchronizedValueFactory;

@Path("/")
@Produces(MediaType.APPLICATION_JSON)
public interface YoBit {
  @GET
  @Path("api/3/info")
  YoBitInfo getProducts() throws IOException;

  @GET
  @Path("api/3/depth/{currencyPairs}")
  YoBitOrderBooksReturn getOrderBooks(
      @PathParam("currencyPairs") String currencyPairs, @QueryParam("limit") long limit)
      throws IOException;

  @GET
  @Path("api/3/trades/{currencyPairs}")
  YoBitTrades getTrades(@PathParam("currencyPairs") String currencyPairsCurrency)
      throws IOException;

  @GET
  @Path("api/3/ticker/{currencyPairs}")
  YoBitTickersReturn getTickers(@PathParam("currencyPairs") String currencyPairs)
      throws IOException;

  @POST
  @Path("/tapi")
  BaseYoBitResponse getInfo(
      @HeaderParam("Key") String apiKey,
      @HeaderParam("Sign") YoBitDigest signatureCreator,
      @FormParam("method") String method,
      @FormParam("nonce") SynchronizedValueFactory<Long> nonce)
      throws IOException;

  @POST
  @Path("/tapi")
  BaseYoBitResponse withdrawCoinsToAddress(
      @HeaderParam("Key") String apiKey,
      @HeaderParam("Sign") YoBitDigest signatureCreator,
      @FormParam("method") String method,
      @FormParam("nonce") SynchronizedValueFactory<Long> nonce,
      @FormParam("coinName") String coinName,
      @FormParam("amount") BigDecimal amount,
      @FormParam("address") String address)
      throws IOException;

  @POST
  @Path("/tapi")
  BaseYoBitResponse getDepositAddress(
      @HeaderParam("Key") String apiKey,
      @HeaderParam("Sign") YoBitDigest signatureCreator,
      @FormParam("method") String method,
      @FormParam("nonce") SynchronizedValueFactory<Long> nonce,
      @FormParam("coinName") String coinName,
      @FormParam("need_new") Boolean needNew)
      throws IOException;

  @POST
  @Path("/tapi")
  BaseYoBitResponse tradeHistory(
      @HeaderParam("Key") String apiKey,
      @HeaderParam("Sign") YoBitDigest signatureCreator,
      @FormParam("method") String method,
      @FormParam("nonce") SynchronizedValueFactory<Long> nonce,
      @FormParam("form") Long offset,
      @FormParam("count") Integer count,
      @FormParam("from_id") Long fromTransactionId,
      @FormParam("end_id") Long endTransactionId,
      @FormParam("order") String order,
      @FormParam("since") Long sinceTime,
      @FormParam("end") Long endTime,
      @FormParam("pair") String currencyPair)
      throws IOException;

  @POST
  @Path("/tapi")
  BaseYoBitResponse activeOrders(
      @HeaderParam("Key") String apiKey,
      @HeaderParam("Sign") YoBitDigest signatureCreator,
      @FormParam("method") String method,
      @FormParam("nonce") SynchronizedValueFactory<Long> nonce,
      @FormParam("pair") String market)
      throws IOException;

  @POST
  @Path("/tapi")
  BaseYoBitResponse orderInfo(
      @HeaderParam("Key") String apiKey,
      @HeaderParam("Sign") YoBitDigest signatureCreator,
      @FormParam("method") String method,
      @FormParam("nonce") SynchronizedValueFactory<Long> nonce,
      @FormParam("order_id") Long orderId)
      throws IOException;

  @POST
  @Path("/tapi")
  BaseYoBitResponse cancelOrder(
      @HeaderParam("Key") String apiKey,
      @HeaderParam("Sign") YoBitDigest signatureCreator,
      @FormParam("method") String method,
      @FormParam("nonce") SynchronizedValueFactory<Long> nonce,
      @FormParam("order_id") Long orderId)
      throws IOException;

  @POST
  @Path("/tapi")
  BaseYoBitResponse trade(
      @HeaderParam("Key") String apiKey,
      @HeaderParam("Sign") YoBitDigest signatureCreator,
      @FormParam("method") String method,
      @FormParam("nonce") SynchronizedValueFactory<Long> nonce,
      @FormParam("pair") String market,
      @FormParam("type") String type,
      @FormParam("rate") BigDecimal price,
      @FormParam("amount") BigDecimal amount)
      throws IOException;
}
