/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.therock.service;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ExchangeRestProxyBuilder;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.therock.TheRock;
import org.knowm.xchange.therock.TheRockAuthenticated;
import org.knowm.xchange.therock.dto.TheRockException;
import org.knowm.xchange.therock.dto.trade.TheRockOrder;
import org.knowm.xchange.therock.dto.trade.TheRockOrders;
import org.knowm.xchange.therock.dto.trade.TheRockTransaction;
import org.knowm.xchange.therock.dto.trade.TheRockUserTrades;
import org.knowm.xchange.therock.service.TheRockBaseService;
import org.knowm.xchange.therock.service.TheRockDigest;
import si.mazi.rescu.SynchronizedValueFactory;

public class TheRockTradeServiceRaw
extends TheRockBaseService {
    private final TheRockAuthenticated theRockAuthenticated;
    private final TheRockDigest signatureCreator;

    public TheRockTradeServiceRaw(Exchange exchange) {
        super(exchange);
        ExchangeSpecification spec = exchange.getExchangeSpecification();
        this.theRockAuthenticated = (TheRockAuthenticated)ExchangeRestProxyBuilder.forInterface(TheRockAuthenticated.class, (ExchangeSpecification)spec).build();
        this.signatureCreator = new TheRockDigest(spec.getSecretKey());
    }

    public TheRockOrder placeTheRockOrder(CurrencyPair currencyPair, BigDecimal amount, BigDecimal price, TheRockOrder.Side side, TheRockOrder.Type type) throws ExchangeException, IOException {
        return this.placeTheRockOrder(currencyPair, new TheRockOrder(new TheRock.Pair(currencyPair), side, type, amount, price));
    }

    public TheRockOrder placeTheRockOrder(CurrencyPair currencyPair, TheRockOrder order) throws ExchangeException, IOException {
        try {
            return this.theRockAuthenticated.placeOrder(new TheRock.Pair(currencyPair), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), order);
        }
        catch (TheRockException e) {
            throw new ExchangeException((Throwable)((Object)e));
        }
    }

    public TheRockOrder cancelTheRockOrder(CurrencyPair currencyPair, Long orderId) throws TheRockException, IOException {
        try {
            return this.theRockAuthenticated.cancelOrder(new TheRock.Pair(currencyPair), orderId, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        }
        catch (TheRockException e) {
            throw new ExchangeException((Throwable)((Object)e));
        }
    }

    public TheRockOrders getTheRockOrders(CurrencyPair currencyPair) throws TheRockException, IOException {
        try {
            return this.theRockAuthenticated.orders(new TheRock.Pair(currencyPair), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        }
        catch (TheRockException e) {
            throw new ExchangeException((Throwable)((Object)e));
        }
    }

    public TheRockOrders getTheRockOrders(CurrencyPair currencyPair, Date after, Date before, String status, TheRockOrder.Side side, Long positionId, int page) throws TheRockException, IOException {
        try {
            return this.theRockAuthenticated.orders(new TheRock.Pair(currencyPair), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), after, before, status, side, positionId, page);
        }
        catch (TheRockException e) {
            throw new ExchangeException((Throwable)((Object)e));
        }
    }

    public TheRockOrder showTheRockOrder(CurrencyPair currencyPair, Long orderId) throws TheRockException, IOException {
        try {
            return this.theRockAuthenticated.showOrder(new TheRock.Pair(currencyPair), orderId, this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory());
        }
        catch (TheRockException e) {
            throw new ExchangeException((Throwable)((Object)e));
        }
    }

    public TheRockUserTrades getTheRockUserTrades(CurrencyPair currencyPair, Long sinceTradeId, Date after, Date before, int pageSize, int page) throws IOException {
        try {
            return this.theRockAuthenticated.trades(new TheRock.Pair(currencyPair), this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), sinceTradeId, after, before, pageSize, page);
        }
        catch (Throwable e) {
            throw new ExchangeException(e);
        }
    }

    public TheRockTransaction[] getTheRockTransactions(String type, Date after, Date before) throws IOException {
        try {
            return this.theRockAuthenticated.transactions(this.exchange.getExchangeSpecification().getApiKey(), this.signatureCreator, (SynchronizedValueFactory<Long>)this.exchange.getNonceFactory(), type, after, before, null, 0).getTransactions();
        }
        catch (Throwable e) {
            throw new ExchangeException(e);
        }
    }
}

