/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.therock;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.HeaderParam;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.Date;
import org.knowm.xchange.therock.TheRock;
import org.knowm.xchange.therock.dto.TheRockException;
import org.knowm.xchange.therock.dto.account.TheRockBalance;
import org.knowm.xchange.therock.dto.account.TheRockBalances;
import org.knowm.xchange.therock.dto.account.TheRockWithdrawal;
import org.knowm.xchange.therock.dto.account.TheRockWithdrawalResponse;
import org.knowm.xchange.therock.dto.trade.TheRockOrder;
import org.knowm.xchange.therock.dto.trade.TheRockOrders;
import org.knowm.xchange.therock.dto.trade.TheRockTransactions;
import org.knowm.xchange.therock.dto.trade.TheRockUserTrades;
import org.knowm.xchange.therock.service.TheRockDigest;
import si.mazi.rescu.SynchronizedValueFactory;

@Path(value="v1")
@Produces(value={"application/json"})
public interface TheRockAuthenticated {
    public static final String X_TRT_SIGN = "X-TRT-SIGN";
    public static final String X_TRT_KEY = "X-TRT-KEY";
    public static final String X_TRT_NONCE = "X-TRT-NONCE";

    @GET
    @Path(value="balances/{currency}")
    public TheRockBalance balance(@HeaderParam(value="X-TRT-KEY") String var1, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var2, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var3, @PathParam(value="currency") String var4) throws TheRockException, IOException;

    @GET
    @Path(value="balances")
    public TheRockBalances balances(@HeaderParam(value="X-TRT-KEY") String var1, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var2, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var3) throws TheRockException, IOException;

    @POST
    @Consumes(value={"application/json"})
    @Path(value="atms/withdraw")
    public TheRockWithdrawalResponse withdraw(@HeaderParam(value="X-TRT-KEY") String var1, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var2, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var3, TheRockWithdrawal var4) throws TheRockException, IOException;

    @POST
    @Consumes(value={"application/json"})
    @Path(value="funds/{fund_id}/orders")
    public TheRockOrder placeOrder(@PathParam(value="fund_id") TheRock.Pair var1, @HeaderParam(value="X-TRT-KEY") String var2, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var3, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var4, TheRockOrder var5) throws TheRockException, IOException;

    @DELETE
    @Path(value="funds/{fund_id}/orders/{id}")
    public TheRockOrder cancelOrder(@PathParam(value="fund_id") TheRock.Pair var1, @PathParam(value="id") Long var2, @HeaderParam(value="X-TRT-KEY") String var3, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var4, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var5) throws TheRockException, IOException;

    @GET
    @Path(value="funds/{fund_id}/orders")
    public TheRockOrders orders(@PathParam(value="fund_id") TheRock.Pair var1, @HeaderParam(value="X-TRT-KEY") String var2, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var3, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var4) throws TheRockException, IOException;

    @GET
    @Path(value="funds/{fund_id}/orders")
    public TheRockOrders orders(@PathParam(value="fund_id") TheRock.Pair var1, @HeaderParam(value="X-TRT-KEY") String var2, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var3, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var4, @QueryParam(value="after") Date var5, @QueryParam(value="before") Date var6, @QueryParam(value="status") String var7, @QueryParam(value="side") TheRockOrder.Side var8, @QueryParam(value="position_id") Long var9, @QueryParam(value="page") int var10) throws TheRockException, IOException;

    @GET
    @Path(value="funds/{fund_id}/orders/{id}")
    public TheRockOrder showOrder(@PathParam(value="fund_id") TheRock.Pair var1, @PathParam(value="id") Long var2, @HeaderParam(value="X-TRT-KEY") String var3, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var4, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var5) throws TheRockException, IOException;

    @GET
    @Path(value="funds/{fund_id}/trades")
    public TheRockUserTrades trades(@PathParam(value="fund_id") TheRock.Pair var1, @HeaderParam(value="X-TRT-KEY") String var2, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var3, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var4, @QueryParam(value="trade_id") Long var5, @QueryParam(value="after") Date var6, @QueryParam(value="before") Date var7, @QueryParam(value="per_page") int var8, @QueryParam(value="page") int var9) throws TheRockException, IOException;

    @GET
    @Path(value="transactions")
    public TheRockTransactions transactions(@HeaderParam(value="X-TRT-KEY") String var1, @HeaderParam(value="X-TRT-SIGN") TheRockDigest var2, @HeaderParam(value="X-TRT-NONCE") SynchronizedValueFactory<Long> var3, @QueryParam(value="type") String var4, @QueryParam(value="after") Date var5, @QueryParam(value="before") Date var6, @QueryParam(value="currency") String var7, @QueryParam(value="page") Integer var8) throws TheRockException, IOException;
}

