/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.therock;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.AccountInfo;
import org.knowm.xchange.dto.account.Balance;
import org.knowm.xchange.dto.account.Wallet;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.marketdata.Trades;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.therock.dto.account.TheRockBalance;
import org.knowm.xchange.therock.dto.marketdata.TheRockBid;
import org.knowm.xchange.therock.dto.marketdata.TheRockOrderBook;
import org.knowm.xchange.therock.dto.marketdata.TheRockTrade;
import org.knowm.xchange.therock.dto.marketdata.TheRockTrades;
import org.knowm.xchange.therock.dto.trade.TheRockOrder;
import org.knowm.xchange.therock.dto.trade.TheRockOrders;
import org.knowm.xchange.therock.dto.trade.TheRockUserTrade;
import org.knowm.xchange.therock.dto.trade.TheRockUserTrades;
import org.knowm.xchange.utils.DateUtils;

public final class TheRockAdapters {
    private TheRockAdapters() {
    }

    public static TheRockOrder.Side adaptSide(Order.OrderType type) {
        return type == Order.OrderType.BID ? TheRockOrder.Side.buy : TheRockOrder.Side.sell;
    }

    public static AccountInfo adaptAccountInfo(List<TheRockBalance> trBalances, String userName) {
        ArrayList<Balance> balances = new ArrayList<Balance>(trBalances.size());
        for (TheRockBalance blc : trBalances) {
            Currency currency = Currency.getInstance((String)blc.getCurrency());
            balances.add(new Balance(currency, blc.getBalance(), blc.getTradingBalance()));
        }
        return new AccountInfo(userName, new Wallet[]{Wallet.Builder.from(balances).id("spot").build()});
    }

    public static OrderBook adaptOrderBook(TheRockOrderBook theRockOrderBook) {
        ArrayList<LimitOrder> asks = new ArrayList<LimitOrder>();
        ArrayList<LimitOrder> bids = new ArrayList<LimitOrder>();
        for (TheRockBid theRockBid : theRockOrderBook.getAsks()) {
            asks.add(TheRockAdapters.adaptBid(theRockOrderBook.getCurrencyPair(), Order.OrderType.ASK, theRockBid, theRockOrderBook.getDate()));
        }
        for (TheRockBid theRockBid : theRockOrderBook.getBids()) {
            bids.add(TheRockAdapters.adaptBid(theRockOrderBook.getCurrencyPair(), Order.OrderType.BID, theRockBid, theRockOrderBook.getDate()));
        }
        return new OrderBook(theRockOrderBook.getDate(), asks, bids);
    }

    private static LimitOrder adaptBid(CurrencyPair currencyPair, Order.OrderType orderType, TheRockBid theRockBid, Date timestamp) {
        return new LimitOrder.Builder(orderType, (Instrument)currencyPair).limitPrice(theRockBid.getPrice()).originalAmount(theRockBid.getAmount()).timestamp(timestamp).build();
    }

    public static Trades adaptTrades(TheRockTrades trades, CurrencyPair currencyPair) {
        ArrayList<Trade> tradesList = new ArrayList<Trade>(trades.getCount());
        long lastTradeId = 0L;
        for (int i = 0; i < trades.getCount(); ++i) {
            TheRockTrade trade = trades.getTrades()[i];
            if (trade.getSide() != TheRockTrade.Side.buy && trade.getSide() != TheRockTrade.Side.sell) continue;
            long tradeId = trade.getId();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            tradesList.add(TheRockAdapters.adaptTrade(trade, currencyPair));
        }
        return new Trades(tradesList, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static Trade adaptTrade(TheRockTrade trade, CurrencyPair currencyPair) {
        String tradeId = String.valueOf(trade.getId());
        return new Trade.Builder().type(trade.getSide() == TheRockTrade.Side.sell ? Order.OrderType.ASK : Order.OrderType.BID).originalAmount(trade.getAmount()).currencyPair(currencyPair).price(trade.getPrice()).timestamp(trade.getDate()).id(tradeId).build();
    }

    public static UserTrade adaptUserTrade(TheRockUserTrade trade, CurrencyPair currencyPair) {
        String tradeId = String.valueOf(trade.getId());
        return UserTrade.builder().id(tradeId).originalAmount(trade.getAmount()).currencyPair(currencyPair).price(trade.getPrice()).timestamp(trade.getDate()).orderId(String.valueOf(trade.getOrderId())).type(trade.getSide() == TheRockTrade.Side.buy ? Order.OrderType.BID : Order.OrderType.ASK).feeAmount(trade.getFeeAmount()).feeCurrency(trade.getFeeCurrency() == null ? null : Currency.getInstance((String)trade.getFeeCurrency())).build();
    }

    public static UserTrades adaptUserTrades(TheRockUserTrades trades, CurrencyPair currencyPair) {
        ArrayList<UserTrade> tradesList = new ArrayList<UserTrade>(trades.getCount());
        long lastTradeId = 0L;
        for (int i = 0; i < trades.getCount(); ++i) {
            TheRockUserTrade trade = trades.getTrades()[i];
            long tradeId = trade.getId();
            if (tradeId > lastTradeId) {
                lastTradeId = tradeId;
            }
            tradesList.add(TheRockAdapters.adaptUserTrade(trade, currencyPair));
        }
        return new UserTrades(tradesList, lastTradeId, Trades.TradeSortType.SortByID);
    }

    public static LimitOrder adaptOrder(TheRockOrder order) {
        Date timestamp;
        try {
            timestamp = order.getDate() == null ? null : DateUtils.fromISODateString((String)order.getDate());
        }
        catch (Exception e) {
            timestamp = null;
        }
        BigDecimal amount = order.getAmount();
        BigDecimal unfilled = order.getAmountUnfilled();
        BigDecimal cumulative = unfilled != null && amount != null ? amount.subtract(unfilled) : null;
        return new LimitOrder(TheRockAdapters.adaptOrderType(order.getSide()), order.getAmount(), (Instrument)order.getFundId().pair, Long.toString(order.getId()), timestamp, order.getPrice(), order.getPrice(), cumulative, null, TheRockAdapters.adaptOrderStatus(order));
    }

    public static Order.OrderType adaptOrderType(TheRockOrder.Side orderSide) {
        return orderSide.equals((Object)TheRockOrder.Side.buy) ? Order.OrderType.BID : Order.OrderType.ASK;
    }

    public static OpenOrders adaptOrders(TheRockOrders theRockOrders) {
        ArrayList<LimitOrder> orders = new ArrayList<LimitOrder>(theRockOrders.getOrders().length);
        for (TheRockOrder theRockOrder : theRockOrders.getOrders()) {
            orders.add(TheRockAdapters.adaptOrder(theRockOrder));
        }
        return new OpenOrders(orders);
    }

    public static Order.OrderStatus adaptOrderStatus(TheRockOrder order) {
        if ("active".equalsIgnoreCase(order.getStatus())) {
            return Order.OrderStatus.NEW;
        }
        if ("conditional".equalsIgnoreCase(order.getStatus())) {
            return Order.OrderStatus.NEW;
        }
        if ("executed".equalsIgnoreCase(order.getStatus())) {
            return Order.OrderStatus.FILLED;
        }
        if ("deleted".equalsIgnoreCase(order.getStatus())) {
            return Order.OrderStatus.CANCELED;
        }
        return Order.OrderStatus.UNKNOWN;
    }
}

