/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.therock;

import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.therock.dto.TheRockException;
import org.knowm.xchange.therock.dto.marketdata.TheRockOrderBook;
import org.knowm.xchange.therock.dto.marketdata.TheRockTicker;
import org.knowm.xchange.therock.dto.marketdata.TheRockTrades;
import org.knowm.xchange.utils.jackson.CurrencyPairDeserializer;

@Path(value="v1")
@Produces(value={"application/json"})
public interface TheRock {
    @GET
    @Path(value="funds/{id}/ticker")
    public TheRockTicker getTicker(@PathParam(value="id") Pair var1) throws TheRockException, IOException;

    @GET
    @Path(value="funds/{id}/orderbook")
    public TheRockOrderBook getOrderbook(@PathParam(value="id") Pair var1) throws TheRockException, IOException;

    @GET
    @Path(value="funds/{id}/trades")
    public TheRockTrades getTrades(@PathParam(value="id") Pair var1, @QueryParam(value="after") Date var2) throws IOException;

    public static class Pair {
        public final CurrencyPair pair;

        public Pair(CurrencyPair pair) {
            if (pair == null) {
                throw new IllegalArgumentException("Currency pair required.");
            }
            this.pair = pair;
        }

        public Pair(String pair) {
            this(CurrencyPairDeserializer.getCurrencyPairFromString((String)pair));
        }

        public boolean equals(Object o) {
            return this == o || o != null && this.getClass() == o.getClass() && Objects.equals(this.pair, ((Pair)o).pair);
        }

        public int hashCode() {
            return Objects.hash(this.pair);
        }

        public String toString() {
            return String.format("%s%s", this.pair.base.getCurrencyCode(), this.pair.counter.getCurrencyCode());
        }
    }
}

