/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.service.pubnub;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.pubnub.api.PNConfiguration;
import com.pubnub.api.PubNub;
import com.pubnub.api.callbacks.SubscribeCallback;
import com.pubnub.api.enums.PNStatusCategory;
import com.pubnub.api.models.consumer.PNStatus;
import com.pubnub.api.models.consumer.pubsub.PNMessageResult;
import com.pubnub.api.models.consumer.pubsub.PNPresenceEventResult;
import com.pubnub.api.models.consumer.pubsub.PNSignalResult;
import com.pubnub.api.models.consumer.pubsub.message_actions.PNMessageActionResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNMembershipResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNSpaceResult;
import com.pubnub.api.models.consumer.pubsub.objects.PNUserResult;
import io.reactivex.Completable;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PubnubStreamingService {
    private static final Logger LOG = LoggerFactory.getLogger(PubnubStreamingService.class);
    private final PubNub pubnub;
    private PNStatusCategory pnStatusCategory;
    private final Map<String, ObservableEmitter<JsonNode>> subscriptions = new ConcurrentHashMap<String, ObservableEmitter<JsonNode>>();
    private final ObjectMapper mapper = new ObjectMapper();

    public PubnubStreamingService(String publicKey) {
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        PNConfiguration pnConfiguration = new PNConfiguration();
        pnConfiguration.setSubscribeKey(publicKey);
        this.pubnub = new PubNub(pnConfiguration);
        this.pnStatusCategory = PNStatusCategory.PNDisconnectedCategory;
    }

    public Completable connect() {
        return Completable.create(e -> {
            this.pubnub.addListener(new SubscribeCallback(){

                public void status(PubNub pubNub, PNStatus pnStatus) {
                    PubnubStreamingService.this.pnStatusCategory = pnStatus.getCategory();
                    LOG.debug("PubNub status: {} {}", (Object)PubnubStreamingService.this.pnStatusCategory.toString(), (Object)pnStatus.getStatusCode());
                    if (PubnubStreamingService.this.pnStatusCategory == PNStatusCategory.PNConnectedCategory || pnStatus.isError()) {
                        // empty if block
                    }
                }

                public void message(PubNub pubNub, PNMessageResult pnMessageResult) {
                    String channelName = pnMessageResult.getChannel();
                    ObservableEmitter subscription = (ObservableEmitter)PubnubStreamingService.this.subscriptions.get(channelName);
                    LOG.debug("PubNub Message: {}", (Object)pnMessageResult.toString());
                    if (subscription != null) {
                        JsonNode jsonMessage = null;
                        try {
                            jsonMessage = PubnubStreamingService.this.mapper.readTree(pnMessageResult.getMessage().toString());
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                        }
                        subscription.onNext(jsonMessage);
                    } else {
                        LOG.debug("No subscriber for channel {}.", (Object)channelName);
                    }
                }

                public void presence(PubNub pubNub, PNPresenceEventResult pnPresenceEventResult) {
                    LOG.debug("PubNub presence: {}", (Object)pnPresenceEventResult.toString());
                }

                public void signal(PubNub pubnub, PNSignalResult pnSignalResult) {
                    LOG.debug("PubNub signal: {}", (Object)pnSignalResult.toString());
                }

                public void user(PubNub pubnub, PNUserResult pnUserResult) {
                    LOG.debug("PubNub user: {}", (Object)pnUserResult.toString());
                }

                public void space(PubNub pubnub, PNSpaceResult pnSpaceResult) {
                    LOG.debug("PubNub space: {}", (Object)pnSpaceResult.toString());
                }

                public void membership(PubNub pubnub, PNMembershipResult pnMembershipResult) {
                    LOG.debug("PubNub membership: {}", (Object)pnMembershipResult.toString());
                }

                public void messageAction(PubNub pubnub, PNMessageActionResult pnMessageActionResult) {
                    LOG.debug("PubNub messageAction: {}", (Object)pnMessageActionResult.toString());
                }
            });
            e.onComplete();
        });
    }

    public Observable<JsonNode> subscribeChannel(String channelName) {
        LOG.info("Subscribing to channel {}.", (Object)channelName);
        return Observable.create(e -> {
            if (!this.subscriptions.containsKey(channelName)) {
                this.subscriptions.put(channelName, (ObservableEmitter<JsonNode>)e);
                this.pubnub.subscribe().channels(Collections.singletonList(channelName)).execute();
                LOG.debug("Subscribe channel: {}", (Object)channelName);
            }
        }).doOnDispose(() -> {
            LOG.debug("Unsubscribe channel: {}", (Object)channelName);
            this.pubnub.unsubscribe().channels(Collections.singletonList(channelName)).execute();
        }).share();
    }

    public Completable disconnect() {
        return Completable.create(completable -> {
            this.pubnub.disconnect();
            completable.onComplete();
        });
    }

    public boolean isAlive() {
        return this.pnStatusCategory == PNStatusCategory.PNConnectedCategory;
    }

    public void useCompressedMessages(boolean compressedMessages) {
        throw new UnsupportedOperationException();
    }
}

