/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.serum.datamapper;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.knowm.xchange.serum.core.Market;
import com.knowm.xchange.serum.structures.EventQueueLayout;
import info.bitrich.xchangestream.serum.datamapper.DataMapper;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class EventQueueDataMapper
extends DataMapper {
    private long lastSeqNum = -1L;

    public EventQueueDataMapper(String symbol, Market market, int priceDecimalPlaces, int sizeDecimalPlaces) {
        super(symbol, market, priceDecimalPlaces, sizeDecimalPlaces);
    }

    @Override
    public Stream<JsonNode> map(byte[] bytes, long slot, long timestamp) throws IOException {
        try {
            Stream<EventQueueLayout.EventNode> events = this.decodeEventQueue(bytes);
            if (events == null) {
                throw new NullPointerException("Issue with events");
            }
            ArrayList fillIds = new ArrayList();
            return events.map(e -> this.normalizeData((EventQueueLayout.EventNode)e, timestamp, slot, fillIds)).filter(Objects::nonNull).peek(m -> {
                if (m.has("type") && "fill".equals(m.get("type").asText())) {
                    fillIds.add(m.get("orderId").asText());
                }
            });
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw e2;
        }
    }

    public BigDecimal getFillPrice(EventQueueLayout.EventNode event, int decimalPlaces) {
        BigDecimal nativeQuantity = new BigDecimal(String.valueOf(event.eventFlags.bid ? event.nativeQuantityPaid : event.nativeQuantityReleased));
        BigDecimal nativeFeeOrRebate = new BigDecimal(String.valueOf(event.nativeFeeOrRebate));
        BigDecimal priceBeforeFees = event.eventFlags.maker ? nativeQuantity.subtract(nativeFeeOrRebate) : nativeQuantity.add(nativeFeeOrRebate);
        return new BigDecimal(String.valueOf(this.market.divideBNToNumber(priceBeforeFees.multiply(this.market.baseSplTokenMultiplier()), this.market.baseSplTokenMultiplier().multiply(new BigDecimal(String.valueOf(event.eventFlags.bid ? event.nativeQuantityReleased : event.nativeQuantityPaid)))))).setScale(decimalPlaces, RoundingMode.HALF_UP);
    }

    public BigDecimal getFillSize(EventQueueLayout.EventNode event, int decimalPlaces) {
        return new BigDecimal(String.valueOf(this.market.divideBNToNumber(new BigDecimal(String.valueOf(event.eventFlags.bid ? event.nativeQuantityReleased : event.nativeQuantityPaid)), this.market.baseSplTokenMultiplier()))).setScale(decimalPlaces, RoundingMode.HALF_UP);
    }

    public JsonNode normalizeData(EventQueueLayout.EventNode event, long timestamp, long slot, List<String> fillIds) {
        String side;
        String string = side = event.eventFlags.bid ? "buy" : "sell";
        if (event.eventFlags.fill) {
            ObjectNode fill = JsonNodeFactory.instance.objectNode();
            fill.put("type", "fill");
            fill.put("symbol", this.symbol);
            fill.put("market", this.market.decoded.getOwnAddress().getKeyString());
            fill.put("timestamp", timestamp);
            fill.put("slot", slot);
            fill.put("orderId", event.orderId);
            fill.put("clientId", event.clientOrderId);
            fill.put("side", side);
            fill.put("price", this.getFillPrice(event, this.priceDecimalPlaces).toPlainString());
            fill.put("size", this.getFillSize(event, this.sizeDecimalPlaces).toPlainString());
            fill.put("maker", event.eventFlags.maker);
            fill.put("feeCost", this.market.quoteSplTokenMultiplier().toPlainString());
            fill.put("openOrders", event.openOrders.getKeyString());
            fill.put("openOrdersSlot", event.openOrdersSlot);
            fill.put("feeTier", event.feeTier);
            return fill;
        }
        if (Double.compare(event.nativeQuantityPaid, 0.0) == 0) {
            ObjectNode done = JsonNodeFactory.instance.objectNode();
            done.put("type", "done");
            done.put("symbol", this.symbol);
            done.put("market", this.market.decoded.getOwnAddress().getKeyString());
            done.put("timestamp", timestamp);
            done.put("slot", slot);
            done.put("orderId", event.orderId);
            done.put("clientId", event.clientOrderId);
            done.put("side", side);
            done.put("reason", fillIds.contains(event.orderId) ? "filled" : "cancelled");
            done.put("maker", event.eventFlags.maker);
            done.put("openOrders", event.openOrders.getKeyString());
            done.put("openOrdersSlot", event.openOrdersSlot);
            done.put("feeTier", event.feeTier);
            return done;
        }
        return null;
    }

    private Stream<EventQueueLayout.EventNode> decodeEventQueue(byte[] bytes) throws IOException {
        Stream<EventQueueLayout.EventNode> stream = Stream.empty();
        try {
            EventQueueLayout.Header header = (EventQueueLayout.Header)EventQueueLayout.HeaderLayout.DECODER.decode(Arrays.copyOfRange(bytes, 0, EventQueueLayout.HEADER_LEN));
            if (this.lastSeqNum != -1L) {
                long newEventsCount = header.seqNum - this.lastSeqNum;
                stream = IntStream.range(0, (int)newEventsCount).mapToObj(i -> {
                    int startIndex = EventQueueLayout.HEADER_LEN + i * EventQueueLayout.NODE_LEN;
                    try {
                        return (EventQueueLayout.EventNode)EventQueueLayout.NodeLayout.DECODER.decode(Arrays.copyOfRange(bytes, startIndex, startIndex + EventQueueLayout.NODE_LEN));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        return null;
                    }
                }).filter(Objects::nonNull);
            }
            this.lastSeqNum = header.seqNum;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return stream;
    }
}

