/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.serum;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerumSubscriptionManager {
    private static final Logger LOG = LoggerFactory.getLogger(SerumSubscriptionManager.class);
    private final Map<Integer, String> inflightSubscriptionMap = new ConcurrentHashMap<Integer, String>();
    private final Map<Integer, String> requestIdToChannelName = new ConcurrentHashMap<Integer, String>();
    private final Map<Integer, Integer> requestIdToSubscriptionId = new ConcurrentHashMap<Integer, Integer>();
    private final Map<Integer, Integer> subscriptionIdToRequestId = new ConcurrentHashMap<Integer, Integer>();

    public void newSubscription(int reqID, int subID) {
        String channelName = this.inflightSubscriptionMap.remove(reqID);
        this.requestIdToSubscriptionId.put(reqID, subID);
        this.requestIdToChannelName.put(reqID, channelName);
        this.subscriptionIdToRequestId.put(subID, reqID);
        LOG.info("Channel={} has been subscribed on subscription={}", (Object)channelName, (Object)subID);
    }

    public void removedSubscription(int reqID, boolean status) {
        int subID1 = this.requestIdToSubscriptionId.remove(reqID);
        String channelName1 = this.requestIdToChannelName.remove(reqID);
        this.subscriptionIdToRequestId.remove(subID1);
        LOG.info("Channel={} has been unsubscribed for subscription={} status={}", new Object[]{channelName1, subID1, status});
    }

    public String getChannelName(int subID) {
        int reqId = this.subscriptionIdToRequestId.get(subID);
        return this.requestIdToChannelName.get(reqId);
    }

    public int generateNewInflightRequest(String channelName) {
        int reqID = Math.abs(UUID.randomUUID().hashCode());
        this.inflightSubscriptionMap.put(reqID, channelName);
        return reqID;
    }
}

