/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.serum;

import com.fasterxml.jackson.databind.JsonNode;
import com.knowm.xchange.serum.SerumAdapters;
import com.knowm.xchange.serum.SerumConfigs;
import info.bitrich.xchangestream.serum.SerumEventType;
import info.bitrich.xchangestream.serum.SerumSubscriptionManager;
import info.bitrich.xchangestream.serum.dto.SerumWsSubscriptionMessage;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import java.io.IOException;
import java.time.Duration;
import org.knowm.xchange.currency.CurrencyPair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerumStreamingService
extends JsonNettyStreamingService {
    private static final Logger LOG = LoggerFactory.getLogger(SerumStreamingService.class);
    private final SerumSubscriptionManager subscriptionManager = new SerumSubscriptionManager();
    private final String RESULT = "result";
    private final String SUBSCRIPTION = "subscription";
    private final String PARAMS = "params";
    private final String ID = "id";

    public SerumStreamingService(String apiUrl) {
        super(apiUrl);
    }

    public SerumStreamingService(String apiUrl, int maxFramePayloadLength, Duration connectionTimeout, Duration retryDuration, int idleTimeoutSeconds) {
        super(apiUrl, maxFramePayloadLength, connectionTimeout, retryDuration, idleTimeoutSeconds);
    }

    protected String getChannelNameFromMessage(JsonNode message) {
        if (message.has("params") && message.get("params").has("subscription")) {
            int subID = message.get("params").get("subscription").intValue();
            return this.subscriptionManager.getChannelName(subID);
        }
        return null;
    }

    private SerumEventType getMessageEvent(JsonNode message) {
        if (message.has("result")) {
            if (message.get("result").isBoolean()) {
                return SerumEventType.unsubscribe;
            }
            if (message.get("result").isInt()) {
                return SerumEventType.subscribe;
            }
        }
        return SerumEventType.unknown;
    }

    protected void handleMessage(JsonNode message) {
        try {
            if (!message.has("id")) {
                super.handleMessage((Object)message);
                return;
            }
            int reqID = message.get("id").intValue();
            switch (this.getMessageEvent(message)) {
                case subscribe: {
                    int subID = message.get("result").intValue();
                    this.subscriptionManager.newSubscription(reqID, subID);
                    break;
                }
                case unsubscribe: {
                    boolean status = message.get("result").asBoolean();
                    this.subscriptionManager.removedSubscription(reqID, status);
                    break;
                }
                default: {
                    LOG.error("Unknown message type on msg {}", (Object)message);
                    break;
                }
            }
        }
        catch (Exception e) {
            LOG.error("Issue processing message {}", (Object)message, (Object)e);
        }
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        if (args.length < 3) {
            throw new IllegalArgumentException("Not enough args");
        }
        if (!(args[0] instanceof CurrencyPair)) {
            throw new IllegalArgumentException("arg[0] must be the currency pairs");
        }
        if (!(args[1] instanceof SerumConfigs.SubscriptionType)) {
            throw new IllegalArgumentException("arg[1] must be the subscription type");
        }
        if (!(args[2] instanceof String)) {
            throw new IllegalArgumentException("arg[1] must be the market data type");
        }
        SerumConfigs.SubscriptionType subscriptionType = (SerumConfigs.SubscriptionType)args[1];
        String account = SerumAdapters.getSolanaDataTypeAddress((CurrencyPair)((CurrencyPair)args[0]), (String)((String)args[2]));
        SerumConfigs.Commitment commitment = args.length > 3 && args[2] != null && args[2] instanceof SerumConfigs.Commitment ? (SerumConfigs.Commitment)args[2] : SerumConfigs.Commitment.max;
        int reqID = this.subscriptionManager.generateNewInflightRequest(channelName);
        return new SerumWsSubscriptionMessage(commitment, subscriptionType, account, reqID).buildMsg();
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        return null;
    }

    public String buildChannelName(CurrencyPair pair, SerumConfigs.SubscriptionType subscriptionType, Object ... args) {
        switch (subscriptionType) {
            case accountSubscribe: {
                if (args == null || args.length < 1 || !(args[0] instanceof String)) {
                    throw new IllegalArgumentException(String.format("No/incorrect market data type for %s specified", pair.toString()));
                }
                String marketDataType = (String)args[0];
                return subscriptionType.name() + "_" + SerumAdapters.getSolanaDataTypeAddress((CurrencyPair)pair, (String)marketDataType);
            }
        }
        throw new UnsupportedOperationException(String.format("Unsupported subscription type %s", subscriptionType));
    }
}

