/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.serum;

import com.knowm.xchange.serum.SerumConfigs;
import com.knowm.xchange.serum.SerumExchange;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.serum.SerumStreamingService;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.Completable;
import io.reactivex.Observable;
import org.knowm.xchange.ExchangeSpecification;

public class SerumStreamingExchange
extends SerumExchange
implements StreamingExchange {
    private SerumStreamingService streamingService;

    public Completable connect(ProductSubscription ... args) {
        String url = SerumConfigs.Solana.valueOf((String)String.valueOf(this.getExchangeSpecification().getExchangeSpecificParametersItem("Env"))).wsUrl();
        this.streamingService = new SerumStreamingService(url);
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)this.streamingService);
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        SerumStreamingService service = this.streamingService;
        this.streamingService = null;
        return service.disconnect();
    }

    public Observable<Throwable> reconnectFailure() {
        return this.streamingService.subscribeReconnectFailure();
    }

    public Observable<Object> connectionSuccess() {
        return this.streamingService.subscribeConnectionSuccess();
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }

    public boolean isAlive() {
        return this.streamingService != null && this.streamingService.isSocketOpen();
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return null;
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification exchangeSpec = new ExchangeSpecification(((Object)((Object)this)).getClass());
        exchangeSpec.setSslUri(SerumConfigs.Solana.MAINNET.restUrl());
        exchangeSpec.setHost("projectserum.com");
        exchangeSpec.setPort(80);
        exchangeSpec.setExchangeName("Serum");
        exchangeSpec.setExchangeDescription("Serum is a decentralized cryptocurrency exchange built on Solana.");
        exchangeSpec.setExchangeSpecificParametersItem("Env", (Object)"MAINNET");
        return exchangeSpec;
    }
}

