/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.poloniex2.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.math.BigDecimal;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexMarketData;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexTicker;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class PoloniexWebSocketTickerTransaction {
    public String channelId;
    public String timestamp;
    public String[] ticker;

    public PoloniexTicker toPoloniexTicker(CurrencyPair currencyPair) {
        PoloniexMarketData poloniexMarketData = new PoloniexMarketData();
        BigDecimal last = new BigDecimal(this.ticker[1]);
        BigDecimal lowestAsk = new BigDecimal(this.ticker[2]);
        BigDecimal highestBid = new BigDecimal(this.ticker[3]);
        BigDecimal percentChange = new BigDecimal(this.ticker[4]);
        BigDecimal baseVolume = new BigDecimal(this.ticker[5]);
        BigDecimal quoteVolume = new BigDecimal(this.ticker[6]);
        BigDecimal isFrozen = new BigDecimal(this.ticker[7]);
        BigDecimal high24hr = new BigDecimal(this.ticker[8]);
        BigDecimal low24hr = new BigDecimal(this.ticker[9]);
        poloniexMarketData.setLast(last);
        poloniexMarketData.setLowestAsk(lowestAsk);
        poloniexMarketData.setHighestBid(highestBid);
        poloniexMarketData.setPercentChange(percentChange);
        poloniexMarketData.setBaseVolume(baseVolume);
        poloniexMarketData.setQuoteVolume(quoteVolume);
        poloniexMarketData.setHigh24hr(high24hr);
        poloniexMarketData.setLow24hr(low24hr);
        return new PoloniexTicker(poloniexMarketData, currencyPair);
    }

    public int getPairId() {
        return Integer.parseInt(this.ticker[0]);
    }
}

