/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.poloniex2.dto;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.poloniex2.dto.OrderbookInsertEvent;
import info.bitrich.xchangestream.poloniex2.dto.OrderbookModifiedEvent;
import info.bitrich.xchangestream.poloniex2.dto.PoloniexWebSocketEvent;
import info.bitrich.xchangestream.poloniex2.dto.PoloniexWebSocketOrderbookInsertEvent;
import info.bitrich.xchangestream.poloniex2.dto.PoloniexWebSocketOrderbookModifiedEvent;
import info.bitrich.xchangestream.poloniex2.dto.PoloniexWebSocketTradeEvent;
import info.bitrich.xchangestream.poloniex2.dto.TradeEvent;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.knowm.xchange.dto.Order;

@JsonFormat(shape=JsonFormat.Shape.ARRAY)
public class PoloniexWebSocketEventsTransaction {
    private Long channelId;
    private Long seqId;
    private List<PoloniexWebSocketEvent> events;

    @JsonCreator
    public PoloniexWebSocketEventsTransaction(@JsonProperty(value="channelId") Long channelId, @JsonProperty(value="seqId") Long seqId, @JsonProperty(value="jsonEvents") List<JsonNode> jsonEvents) {
        this.channelId = channelId;
        this.seqId = seqId;
        this.events = this.createEvents(jsonEvents);
    }

    public Long getChannelId() {
        return this.channelId;
    }

    public Long getSeqId() {
        return this.seqId;
    }

    public List<PoloniexWebSocketEvent> getEvents() {
        return this.events;
    }

    private List<PoloniexWebSocketEvent> createEvents(List<JsonNode> jsonEvents) {
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        ArrayList<PoloniexWebSocketEvent> events = new ArrayList<PoloniexWebSocketEvent>(jsonEvents.size());
        for (JsonNode jsonNode : jsonEvents) {
            String eventType;
            switch (eventType = jsonNode.get(0).asText()) {
                case "i": {
                    OrderbookInsertEvent orderbookInsertEvent = (OrderbookInsertEvent)mapper.convertValue((Object)jsonNode.get(1), OrderbookInsertEvent.class);
                    PoloniexWebSocketEvent insertEvent = new PoloniexWebSocketOrderbookInsertEvent(orderbookInsertEvent);
                    events.add(insertEvent);
                    break;
                }
                case "o": {
                    OrderbookModifiedEvent orderbookModifiedEvent = new OrderbookModifiedEvent(jsonNode.get(1).asText(), new BigDecimal(jsonNode.get(2).asText()), new BigDecimal(jsonNode.get(3).asText()));
                    PoloniexWebSocketEvent insertEvent = new PoloniexWebSocketOrderbookModifiedEvent(orderbookModifiedEvent);
                    events.add(insertEvent);
                    break;
                }
                case "t": {
                    String tradeId = jsonNode.get(1).asText();
                    Order.OrderType side = PoloniexWebSocketEventsTransaction.sideFromString(jsonNode.get(2).asText());
                    BigDecimal price = new BigDecimal(jsonNode.get(3).asText());
                    BigDecimal size = new BigDecimal(jsonNode.get(4).asText());
                    int timestampSeconds = jsonNode.get(5).asInt();
                    TradeEvent tradeEvent = new TradeEvent(tradeId, side, price, size, timestampSeconds);
                    PoloniexWebSocketTradeEvent insertEvent = new PoloniexWebSocketTradeEvent(tradeEvent);
                    events.add(insertEvent);
                    break;
                }
            }
        }
        return events;
    }

    private static Order.OrderType sideFromString(String side) {
        if (side.equals("1")) {
            return Order.OrderType.BID;
        }
        if (side.equals("0")) {
            return Order.OrderType.ASK;
        }
        throw new IllegalArgumentException("Unknown side: " + side);
    }
}

