/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.poloniex2.dto;

import info.bitrich.xchangestream.poloniex2.dto.OrderbookModifiedEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import org.knowm.xchange.poloniex.dto.marketdata.PoloniexDepth;

public class PoloniexOrderbook {
    public static BigDecimal zero = new BigDecimal(0);
    private SortedMap<BigDecimal, BigDecimal> asks;
    private SortedMap<BigDecimal, BigDecimal> bids;

    public PoloniexOrderbook(SortedMap<BigDecimal, BigDecimal> asks, SortedMap<BigDecimal, BigDecimal> bids) {
        this.asks = asks;
        this.bids = bids;
    }

    public void modify(OrderbookModifiedEvent modifiedEvent) {
        SortedMap<BigDecimal, BigDecimal> side = modifiedEvent.getType().equals("0") ? this.asks : this.bids;
        BigDecimal price = modifiedEvent.getPrice();
        BigDecimal volume = modifiedEvent.getVolume();
        side.remove(price);
        if (volume.compareTo(zero) != 0) {
            side.put(price, volume);
        }
    }

    private List<List<BigDecimal>> toPoloniexDepthLevels(SortedMap<BigDecimal, BigDecimal> side) {
        ArrayList<List<BigDecimal>> poloniexDepthSide = new ArrayList<List<BigDecimal>>(side.size());
        for (Map.Entry<BigDecimal, BigDecimal> level : side.entrySet()) {
            ArrayList<BigDecimal> poloniexLevel = new ArrayList<BigDecimal>(2);
            poloniexLevel.add(level.getKey());
            poloniexLevel.add(level.getValue());
            poloniexDepthSide.add(poloniexLevel);
        }
        return poloniexDepthSide;
    }

    public PoloniexDepth toPoloniexDepth() {
        PoloniexDepth orderbook = new PoloniexDepth();
        List<List<BigDecimal>> poloniexDepthAsk = this.toPoloniexDepthLevels(this.asks);
        List<List<BigDecimal>> poloniexDepthBid = this.toPoloniexDepthLevels(this.bids);
        orderbook.setAsks(poloniexDepthAsk);
        orderbook.setBids(poloniexDepthBid);
        return orderbook;
    }
}

