/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.poloniex2.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class OrderbookInsertEvent {
    public static final int ASK_SIDE = 0;
    public static final int BID_SIDE = 1;
    private final String currencyPair;
    private final JsonNode[] orderbookSides;

    public OrderbookInsertEvent(@JsonProperty(value="currencyPair") String currencyPair, @JsonProperty(value="orderBook") JsonNode[] orderbookSides) {
        this.currencyPair = currencyPair;
        this.orderbookSides = orderbookSides;
    }

    public String getCurrencyPair() {
        return this.currencyPair;
    }

    public JsonNode[] getOrderbookSides() {
        return this.orderbookSides;
    }

    public SortedMap<BigDecimal, BigDecimal> toDepthLevels(int side) {
        if (side == 0) {
            return this.toDepthLevels(this.orderbookSides[0], false);
        }
        return this.toDepthLevels(this.orderbookSides[1], true);
    }

    private SortedMap<BigDecimal, BigDecimal> toDepthLevels(JsonNode side, boolean reverse) {
        TreeMap<BigDecimal, BigDecimal> levels = new TreeMap<BigDecimal, BigDecimal>(reverse ? Collections.reverseOrder() : null);
        Iterator prices = side.fieldNames();
        while (prices.hasNext()) {
            String strPrice = (String)prices.next();
            BigDecimal price = new BigDecimal(strPrice);
            BigDecimal volume = new BigDecimal(side.get(strPrice).asText());
            levels.put(price, volume);
        }
        return levels;
    }
}

