/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.poloniex2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.poloniex2.PoloniexStreamingMarketDataService;
import info.bitrich.xchangestream.poloniex2.PoloniexStreamingService;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.Completable;
import io.reactivex.Observable;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.poloniex.PoloniexExchange;

public class PoloniexStreamingExchange
extends PoloniexExchange
implements StreamingExchange {
    private static final String API_URI = "wss://api2.poloniex.com";
    private static final String TICKER_URL = "https://poloniex.com/public?command=returnTicker";
    private final PoloniexStreamingService streamingService = new PoloniexStreamingService("wss://api2.poloniex.com");
    private PoloniexStreamingMarketDataService streamingMarketDataService;

    protected void initServices() {
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)this.streamingService);
        super.initServices();
        Map<Integer, CurrencyPair> currencyPairMap = this.getCurrencyPairMap();
        this.streamingMarketDataService = new PoloniexStreamingMarketDataService(this.streamingService, currencyPairMap);
    }

    private Map<Integer, CurrencyPair> getCurrencyPairMap() {
        HashMap<Integer, CurrencyPair> currencyPairMap = new HashMap<Integer, CurrencyPair>();
        ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();
        try {
            URL tickerUrl = new URL(TICKER_URL);
            JsonNode jsonRootTickers = mapper.readTree(tickerUrl);
            Iterator pairSymbols = jsonRootTickers.fieldNames();
            pairSymbols.forEachRemaining(pairSymbol -> {
                String id = jsonRootTickers.get(pairSymbol).get("id").toString();
                String[] currencies = pairSymbol.split("_");
                CurrencyPair currencyPair = new CurrencyPair(new Currency(currencies[1]), new Currency(currencies[0]));
                currencyPairMap.put(Integer.valueOf(id), currencyPair);
            });
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return currencyPairMap;
    }

    public Completable connect(ProductSubscription ... args) {
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        return this.streamingService.disconnect();
    }

    public Observable<Object> connectionIdle() {
        return this.streamingService.subscribeIdle();
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = super.getDefaultExchangeSpecification();
        spec.setShouldLoadRemoteMetaData(false);
        return spec;
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public boolean isAlive() {
        return this.streamingService.isSocketOpen();
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }

    public Observable<Object> connectionSuccess() {
        return this.streamingService.subscribeConnectionSuccess();
    }

    public Observable<Throwable> reconnectFailure() {
        return this.streamingService.subscribeReconnectFailure();
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }
}

