/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.okex;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import info.bitrich.xchangestream.core.StreamingTradeService;
import info.bitrich.xchangestream.okex.OkexStreamingService;
import info.bitrich.xchangestream.service.netty.StreamingObjectMapperHelper;
import io.reactivex.Observable;
import java.util.List;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.UserTrade;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.okex.OkexAdapters;
import org.knowm.xchange.okex.dto.trade.OkexOrderDetails;

public class OkexStreamingTradeService
implements StreamingTradeService {
    private final OkexStreamingService service;
    private final ExchangeMetaData exchangeMetaData;
    private final ObjectMapper mapper = StreamingObjectMapperHelper.getObjectMapper();

    public OkexStreamingTradeService(OkexStreamingService service, ExchangeMetaData exchangeMetaData) {
        this.service = service;
        this.exchangeMetaData = exchangeMetaData;
    }

    public Observable<UserTrade> getUserTrades(Instrument instrument, Object ... args) {
        String channelUniqueId = "orders" + OkexAdapters.adaptInstrument((Instrument)instrument);
        return this.service.subscribeChannel(channelUniqueId, new Object[0]).filter(message -> message.has("data")).flatMap(jsonNode -> {
            List okexOrderDetails = (List)this.mapper.treeToValue((TreeNode)jsonNode.get("data"), (JavaType)this.mapper.getTypeFactory().constructCollectionType(List.class, OkexOrderDetails.class));
            return Observable.fromIterable((Iterable)OkexAdapters.adaptUserTrades((List)okexOrderDetails, (ExchangeMetaData)this.exchangeMetaData).getUserTrades());
        });
    }
}

