/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.okex;

import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.core.StreamingTradeService;
import info.bitrich.xchangestream.okex.OkexStreamingMarketDataService;
import info.bitrich.xchangestream.okex.OkexStreamingService;
import info.bitrich.xchangestream.okex.OkexStreamingTradeService;
import info.bitrich.xchangestream.service.netty.WebSocketClientHandler;
import io.reactivex.Completable;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.okex.OkexExchange;

public class OkexStreamingExchange
extends OkexExchange
implements StreamingExchange {
    public static final String WS_PUBLIC_CHANNEL_URI = "wss://ws.okx.com:8443/ws/v5/public";
    public static final String WS_PRIVATE_CHANNEL_URI = "wss://ws.okx.com:8443/ws/v5/private";
    public static final String AWS_WS_PUBLIC_CHANNEL_URI = "wss://wsaws.okx.com:8443/ws/v5/public";
    public static final String AWS_WS_PRIVATE_CHANNEL_URI = "wss://wsaws.okx.com:8443/ws/v5/private";
    public static final String SANDBOX_WS_PUBLIC_CHANNEL_URI = "wss://wspap.okx.com:8443/ws/v5/public?brokerId=9999";
    public static final String SANDBOX_WS_PRIVATE_CHANNEL_URI = "wss://wspap.okx.com:8443/ws/v5/private?brokerId=9999";
    private OkexStreamingService streamingService;
    private OkexStreamingMarketDataService streamingMarketDataService;
    private OkexStreamingTradeService streamingTradeService;

    public Completable connect(ProductSubscription ... args) {
        this.streamingService = new OkexStreamingService(this.getApiUrl(), this.exchangeSpecification);
        this.streamingMarketDataService = new OkexStreamingMarketDataService(this.streamingService);
        this.streamingTradeService = new OkexStreamingTradeService(this.streamingService, this.exchangeMetaData);
        return this.streamingService.connect();
    }

    private String getApiUrl() {
        ExchangeSpecification exchangeSpec = this.getExchangeSpecification();
        if (exchangeSpec.getOverrideWebsocketApiUri() != null) {
            return exchangeSpec.getOverrideWebsocketApiUri();
        }
        boolean userAws = Boolean.TRUE.equals(this.exchangeSpecification.getExchangeSpecificParametersItem("Use_AWS"));
        String apiUrl = this.useSandbox() ? (this.exchangeSpecification.getApiKey() == null ? SANDBOX_WS_PUBLIC_CHANNEL_URI : SANDBOX_WS_PRIVATE_CHANNEL_URI) : (this.exchangeSpecification.getApiKey() == null ? (userAws ? AWS_WS_PUBLIC_CHANNEL_URI : WS_PUBLIC_CHANNEL_URI) : (userAws ? AWS_WS_PRIVATE_CHANNEL_URI : WS_PRIVATE_CHANNEL_URI));
        return apiUrl;
    }

    public Completable disconnect() {
        this.streamingService.pingPongDisconnectIfConnected();
        return this.streamingService.disconnect();
    }

    public boolean isAlive() {
        return this.streamingService != null && this.streamingService.isSocketOpen();
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public StreamingTradeService getStreamingTradeService() {
        return this.streamingTradeService;
    }

    public void useCompressedMessages(boolean compressedMessages) {
        throw new NotYetImplementedForExchangeException("useCompressedMessage");
    }

    public void setChannelInactiveHandler(WebSocketClientHandler.WebSocketMessageHandler channelInactiveHandler) {
        this.streamingService.setChannelInactiveHandler(channelInactiveHandler);
    }
}

