/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.huobi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import info.bitrich.xchangestream.service.netty.WebSocketClientHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.zip.DataFormatException;
import java.util.zip.GZIPInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HuobiStreamingService
extends JsonNettyStreamingService {
    private final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());

    public HuobiStreamingService(String apiUrl) {
        super(apiUrl, Integer.MAX_VALUE, Duration.ofSeconds(5L), Duration.ofSeconds(20L), 20);
    }

    protected String getChannelNameFromMessage(JsonNode message) throws IOException {
        String status = null;
        String ch = null;
        if (message.has("ch")) {
            ch = message.get("ch").textValue();
        }
        if (message.has("status")) {
            status = message.get("status").textValue();
        }
        if (message.has("ping")) {
            long ping = message.get("ping").longValue();
            this.sendMessage("{\"pong\": " + ping + "}");
            return null;
        }
        if ("ok".equals(status)) {
            String subbed = message.get("subbed").textValue();
            this.LOG.debug("Subscribe [{}] is ok", (Object)subbed);
            return null;
        }
        if (message.has("err-msg")) {
            this.LOG.warn("error: {}", (Object)message.get("err-msg").textValue());
        }
        return ch;
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        ObjectNode send = JsonNodeFactory.instance.objectNode();
        send.put("sub", channelName);
        send.put("id", System.currentTimeMillis());
        return send.toString();
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        return channelName;
    }

    protected WebSocketClientHandler getWebSocketClientHandler(WebSocketClientHandshaker handshaker, WebSocketClientHandler.WebSocketMessageHandler handler) {
        return new HuobiWebSocketClientHandler(handshaker, handler);
    }

    private class HuobiWebSocketClientHandler
    extends NettyStreamingService.NettyWebSocketClientHandler {
        public HuobiWebSocketClientHandler(WebSocketClientHandshaker handshaker, WebSocketClientHandler.WebSocketMessageHandler handler) {
            super((NettyStreamingService)HuobiStreamingService.this, handshaker, handler);
        }

        public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            if (!this.handshaker.isHandshakeComplete()) {
                super.channelRead0(ctx, msg);
                return;
            }
            super.channelRead0(ctx, msg);
            WebSocketFrame frame = (WebSocketFrame)msg;
            if (frame instanceof BinaryWebSocketFrame) {
                BinaryWebSocketFrame binaryFrame = (BinaryWebSocketFrame)frame;
                ByteBuf byteBuf = binaryFrame.content();
                try {
                    this.handler.onMessage(this.decodeByteBuff(byteBuf));
                }
                catch (Exception e) {
                    HuobiStreamingService.this.LOG.warn("Error when inflate websocket binary message: {}", (Object)e.toString());
                }
            }
        }

        public String decodeByteBuff(ByteBuf buf) throws IOException, DataFormatException {
            StringBuilder sb = new StringBuilder();
            byte[] temp = new byte[1024];
            try (GZIPInputStream biz = new GZIPInputStream((InputStream)new ByteBufInputStream(buf));){
                int data = biz.read(temp);
                while (data != -1) {
                    sb.append(new String(temp, 0, data, StandardCharsets.UTF_8));
                    data = biz.read(temp);
                }
            }
            return sb.toString();
        }
    }
}

