/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.huobi;

import com.fasterxml.jackson.databind.JsonNode;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.huobi.HuobiStreamingService;
import io.reactivex.Observable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.OrderBook;
import org.knowm.xchange.dto.marketdata.Ticker;
import org.knowm.xchange.dto.marketdata.Trade;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.huobi.HuobiUtils;
import org.knowm.xchange.instrument.Instrument;

public class HuobiStreamingMarketDataService
implements StreamingMarketDataService {
    private final HuobiStreamingService streamingService;

    public HuobiStreamingMarketDataService(HuobiStreamingService streamingService) {
        this.streamingService = streamingService;
    }

    public Observable<OrderBook> getOrderBook(CurrencyPair currencyPair, Object ... args) {
        String channelName = "market." + HuobiUtils.createHuobiCurrencyPair((CurrencyPair)currencyPair) + ".depth." + (args.length == 0 ? "step0" : args[0].toString());
        return this.streamingService.subscribeChannel(channelName, new Object[0]).map(message -> {
            LimitOrder lo;
            BigDecimal amount;
            BigDecimal price;
            JsonNode order;
            int i;
            JsonNode tick = message.get("tick");
            Date ts = new Date(message.get("ts").longValue());
            JsonNode asks = tick.get("asks");
            JsonNode bids = tick.get("bids");
            ArrayList<LimitOrder> askOrders = new ArrayList<LimitOrder>();
            ArrayList<LimitOrder> bidOrders = new ArrayList<LimitOrder>();
            OrderBook orderBook = new OrderBook(ts, askOrders, bidOrders);
            for (i = 0; i < asks.size(); ++i) {
                order = asks.get(i);
                price = order.get(0).decimalValue();
                amount = order.get(1).decimalValue();
                lo = new LimitOrder(Order.OrderType.ASK, amount, (Instrument)currencyPair, null, ts, price);
                askOrders.add(lo);
            }
            for (i = 0; i < bids.size(); ++i) {
                order = bids.get(i);
                price = order.get(0).decimalValue();
                amount = order.get(1).decimalValue();
                lo = new LimitOrder(Order.OrderType.BID, amount, (Instrument)currencyPair, null, ts, price);
                bidOrders.add(lo);
            }
            return orderBook;
        });
    }

    public Observable<Ticker> getTicker(CurrencyPair currencyPair, Object ... args) {
        String channelName = "market." + HuobiUtils.createHuobiCurrencyPair((CurrencyPair)currencyPair) + ".kline." + (args.length == 0 ? "1min" : args[0].toString());
        return this.streamingService.subscribeChannel(channelName, new Object[0]).map(message -> {
            JsonNode data = message.get("tick");
            Date ts = new Date(message.get("ts").longValue());
            BigDecimal amount = data.get("amount").decimalValue();
            BigDecimal open = data.get("open").decimalValue();
            BigDecimal close = data.get("close").decimalValue();
            BigDecimal low = data.get("low").decimalValue();
            BigDecimal high = data.get("high").decimalValue();
            Integer count = data.get("count").intValue();
            BigDecimal vol = data.get("vol").decimalValue();
            Ticker.Builder tickerBuilder = new Ticker.Builder();
            tickerBuilder.currencyPair(currencyPair);
            tickerBuilder.open(open);
            tickerBuilder.last(close);
            tickerBuilder.high(high);
            tickerBuilder.low(low);
            tickerBuilder.timestamp(ts);
            tickerBuilder.volume(amount);
            tickerBuilder.quoteVolume(vol);
            return tickerBuilder.build();
        });
    }

    public Observable<Trade> getTrades(CurrencyPair currencyPair, Object ... args) {
        String channelName = "market." + HuobiUtils.createHuobiCurrencyPair((CurrencyPair)currencyPair) + ".trade.detail";
        return this.streamingService.subscribeChannel(channelName, new Object[0]).map(message -> {
            JsonNode data = message.get("tick").get("data");
            ArrayList<Trade> list = new ArrayList<Trade>();
            for (int i = 0; i < data.size(); ++i) {
                JsonNode json = data.get(i);
                String direction = json.get("direction").textValue();
                Order.OrderType orderType = null;
                switch (direction) {
                    case "buy": {
                        orderType = Order.OrderType.ASK;
                        break;
                    }
                    case "sell": {
                        orderType = Order.OrderType.BID;
                        break;
                    }
                }
                if (orderType == null) {
                    return null;
                }
                BigDecimal price = json.get("price").decimalValue();
                Date ts = new Date(json.get("ts").longValue());
                String id = json.get("id").textValue();
                BigDecimal amount = json.get("amount").decimalValue();
                Trade trade = new Trade(orderType, amount, (Instrument)currencyPair, price, ts, id, null, null);
                list.add(trade);
            }
            return (Trade)list.get(list.size() - 1);
        });
    }
}

