/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.huobi;

import info.bitrich.xchangestream.core.ProductSubscription;
import info.bitrich.xchangestream.core.StreamingExchange;
import info.bitrich.xchangestream.core.StreamingMarketDataService;
import info.bitrich.xchangestream.huobi.HuobiStreamingMarketDataService;
import info.bitrich.xchangestream.huobi.HuobiStreamingService;
import info.bitrich.xchangestream.service.netty.ConnectionStateModel;
import info.bitrich.xchangestream.service.netty.NettyStreamingService;
import io.reactivex.Completable;
import io.reactivex.Observable;
import org.knowm.xchange.huobi.HuobiExchange;

public class HuobiStreamingExchange
extends HuobiExchange
implements StreamingExchange {
    private static final String API_BASE_URI = "wss://api.huobi.pro/ws";
    private static final String API_URI_AWS = "wss://api-aws.huobi.pro/ws";
    private HuobiStreamingService streamingService;
    private HuobiStreamingMarketDataService streamingMarketDataService;

    protected void initServices() {
        super.initServices();
        Boolean aws = this.getExchangeSpecification().getExchangeSpecificParameters().getOrDefault("AWS", Boolean.FALSE);
        this.streamingService = new HuobiStreamingService(aws != false ? API_URI_AWS : API_BASE_URI);
        this.streamingService.useCompressedMessages(true);
        this.applyStreamingSpecification(this.getExchangeSpecification(), (NettyStreamingService)this.streamingService);
        this.streamingMarketDataService = new HuobiStreamingMarketDataService(this.streamingService);
    }

    public Completable connect(ProductSubscription ... args) {
        return this.streamingService.connect();
    }

    public Completable disconnect() {
        return this.streamingService.disconnect();
    }

    public boolean isAlive() {
        return this.streamingService.isSocketOpen();
    }

    public Observable<Throwable> reconnectFailure() {
        return this.streamingService.subscribeReconnectFailure();
    }

    public Observable<Object> connectionSuccess() {
        return this.streamingService.subscribeConnectionSuccess();
    }

    public Observable<ConnectionStateModel.State> connectionStateObservable() {
        return this.streamingService.subscribeConnectionState();
    }

    public StreamingMarketDataService getStreamingMarketDataService() {
        return this.streamingMarketDataService;
    }

    public void useCompressedMessages(boolean compressedMessages) {
        this.streamingService.useCompressedMessages(compressedMessages);
    }
}

