/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.hitbtc.dto;

import info.bitrich.xchangestream.hitbtc.dto.HitbtcWebSocketOrderBookTransaction;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrderBook;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcOrderLimit;

public class HitbtcWebSocketOrderBook {
    private Map<BigDecimal, HitbtcOrderLimit> asks;
    private Map<BigDecimal, HitbtcOrderLimit> bids;
    private long sequence = 0L;

    public HitbtcWebSocketOrderBook(HitbtcWebSocketOrderBookTransaction orderbookTransaction) {
        this.createFromLevels(orderbookTransaction);
    }

    private void createFromLevels(HitbtcWebSocketOrderBookTransaction orderbookTransaction) {
        this.asks = new TreeMap<BigDecimal, HitbtcOrderLimit>(BigDecimal::compareTo);
        this.bids = new TreeMap(Collections.reverseOrder(BigDecimal::compareTo));
        for (HitbtcOrderLimit orderBookItem : orderbookTransaction.getParams().getAsk()) {
            if (orderBookItem.getSize().signum() == 0) continue;
            this.asks.put(orderBookItem.getPrice(), orderBookItem);
        }
        for (HitbtcOrderLimit orderBookItem : orderbookTransaction.getParams().getBid()) {
            if (orderBookItem.getSize().signum() == 0) continue;
            this.bids.put(orderBookItem.getPrice(), orderBookItem);
        }
        this.sequence = orderbookTransaction.getParams().getSequence();
    }

    public HitbtcOrderBook toHitbtcOrderBook() {
        HitbtcOrderLimit[] askLimits = (HitbtcOrderLimit[])this.asks.entrySet().stream().map(Map.Entry::getValue).toArray(HitbtcOrderLimit[]::new);
        HitbtcOrderLimit[] bidLimits = (HitbtcOrderLimit[])this.bids.entrySet().stream().map(Map.Entry::getValue).toArray(HitbtcOrderLimit[]::new);
        return new HitbtcOrderBook(askLimits, bidLimits);
    }

    public void updateOrderBook(HitbtcWebSocketOrderBookTransaction orderBookTransaction) {
        if (orderBookTransaction.getParams().getSequence() <= this.sequence) {
            return;
        }
        this.updateOrderBookItems(orderBookTransaction.getParams().getAsk(), this.asks);
        this.updateOrderBookItems(orderBookTransaction.getParams().getBid(), this.bids);
        this.sequence = orderBookTransaction.getParams().getSequence();
    }

    private void updateOrderBookItems(HitbtcOrderLimit[] itemsToUpdate, Map<BigDecimal, HitbtcOrderLimit> localItems) {
        for (HitbtcOrderLimit itemToUpdate : itemsToUpdate) {
            localItems.remove(itemToUpdate.getPrice());
            if (itemToUpdate.getSize().signum() == 0) continue;
            localItems.put(itemToUpdate.getPrice(), itemToUpdate);
        }
    }
}

