/*
 * Decompiled with CFR 0.152.
 */
package info.bitrich.xchangestream.hitbtc;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import info.bitrich.xchangestream.hitbtc.dto.HitbtcWebSocketBaseParams;
import info.bitrich.xchangestream.hitbtc.dto.HitbtcWebSocketSubscriptionMessage;
import info.bitrich.xchangestream.service.netty.JsonNettyStreamingService;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketClientExtensionHandler;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.knowm.xchange.hitbtc.v2.dto.HitbtcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HitbtcStreamingService
extends JsonNettyStreamingService {
    private static final Logger LOG = LoggerFactory.getLogger(HitbtcStreamingService.class);
    private static final String JSON_METHOD = "method";
    private static final String JSON_SYMBOL = "symbol";
    private static final String JSON_PARAMS = "params";
    private static final String JSON_RESULT = "result";
    private static final String JSON_ERROR = "error";
    private static final String JSON_ID = "id";
    private static final String OP_SNAPSHOT = "snapshot";
    private static final String OP_UPDATE = "update";
    private final Map<Integer, Pair<String, String>> requests = new HashMap<Integer, Pair<String, String>>();

    public HitbtcStreamingService(String apiUrl) {
        super(apiUrl, Integer.MAX_VALUE);
    }

    protected WebSocketClientExtensionHandler getWebSocketClientExtensionHandler() {
        return null;
    }

    protected String getChannelNameFromMessage(JsonNode message) throws IOException {
        int requestId;
        if (message.has(JSON_ID) && this.requests.containsKey(requestId = message.get(JSON_ID).asInt())) {
            return (String)this.requests.get(requestId).getKey();
        }
        if (message.has(JSON_METHOD)) {
            String method = message.get(JSON_METHOD).asText();
            if (message.has(JSON_PARAMS) && message.get(JSON_PARAMS).has(JSON_SYMBOL)) {
                String symbol = message.get(JSON_PARAMS).get(JSON_SYMBOL).asText();
                return Stream.of(OP_UPDATE, OP_SNAPSHOT).filter(method::startsWith).map(name -> method.substring(name.length()).toLowerCase() + "-" + symbol).findFirst().orElse(method.toLowerCase() + "-" + symbol);
            }
            return method;
        }
        throw new IOException("Channel name can't be evaluated from message");
    }

    protected void handleMessage(JsonNode message) {
        String channel;
        if (message.has(JSON_ID)) {
            int requestId = message.get(JSON_ID).asInt();
            if (this.requests.containsKey(requestId)) {
                String subscriptionMethod = (String)this.requests.get(requestId).getLeft();
                if (message.has(JSON_ERROR)) {
                    try {
                        HitbtcException exception = (HitbtcException)this.objectMapper.treeToValue((TreeNode)message, HitbtcException.class);
                        super.handleError((Object)message, (Throwable)exception);
                    }
                    catch (JsonProcessingException e) {
                        super.handleError((Object)message, (Throwable)e);
                    }
                } else {
                    boolean result = message.get(JSON_RESULT).asBoolean();
                    LOG.info("HitBTC returned {} as result of '{}' method", (Object)result, (Object)subscriptionMethod);
                }
                this.requests.remove(requestId);
                return;
            }
            LOG.error("Unknown request ID {}", (Object)requestId);
        }
        if (!this.channels.containsKey(channel = this.getChannel(message))) {
            LOG.warn("The message has been received from disconnected channel '{}'. Skipped.", (Object)channel);
            return;
        }
        super.handleMessage((Object)message);
    }

    public String getSubscribeMessage(String channelName, Object ... args) throws IOException {
        HitbtcWebSocketSubscriptionMessage subscribeMessage = this.generateSubscribeMessage(channelName, "subscribe");
        this.requests.put(subscribeMessage.getId(), (Pair<String, String>)ImmutablePair.of((Object)channelName, (Object)subscribeMessage.getMethod()));
        return this.objectMapper.writeValueAsString((Object)subscribeMessage);
    }

    public String getUnsubscribeMessage(String channelName, Object ... args) throws IOException {
        HitbtcWebSocketSubscriptionMessage subscribeMessage = this.generateSubscribeMessage(channelName, "unsubscribe");
        this.requests.put(subscribeMessage.getId(), (Pair<String, String>)ImmutablePair.of((Object)channelName, (Object)subscribeMessage.getMethod()));
        return this.objectMapper.writeValueAsString((Object)subscribeMessage);
    }

    private HitbtcWebSocketSubscriptionMessage generateSubscribeMessage(String channelName, String methodType) throws IOException {
        String[] chanelInfo = channelName.split("-");
        if (chanelInfo.length < 2) {
            throw new IOException(methodType + " message: channel name must has format <channelName>-<Symbol> (e.g orderbook-ETHBTC)");
        }
        String method = methodType + StringUtils.capitalize((String)chanelInfo[0]);
        String symbol = chanelInfo[1];
        int requestId = ThreadLocalRandom.current().nextInt(1, Integer.MAX_VALUE);
        return new HitbtcWebSocketSubscriptionMessage(requestId, method, new HitbtcWebSocketBaseParams(symbol));
    }
}

